/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.proxy.relay;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.netty.MockServer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class RelayConnectHandler<T>
extends SimpleChannelInboundHandler<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelayConnectHandler.class);
    public static final String PROXIED = "PROXIED_";
    public static final String PROXIED_SECURE = "PROXIED_SECURE_";
    public static final String PROXIED_RESPONSE = "PROXIED_RESPONSE_";
    private final MockServerConfiguration configuration;
    private final MockServer server;
    protected final String host;
    protected final int port;

    public RelayConnectHandler(MockServerConfiguration configuration, MockServer server, String host, int port) {
        this.configuration = configuration;
        this.server = server;
        this.host = host;
        this.port = port;
    }

    public void channelRead0(ChannelHandlerContext proxyClientCtx, T request) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)proxyClientCtx.channel().eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new /* Unavailable Anonymous Inner Class!! */);
        InetSocketAddress remoteSocket = this.getDownstreamSocket(proxyClientCtx);
        bootstrap.connect((SocketAddress)remoteSocket).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                this.failure("Connection failed to " + String.valueOf(remoteSocket), future.cause(), proxyClientCtx, this.failureResponse(request));
            }
        }));
    }

    private InetSocketAddress getDownstreamSocket(ChannelHandlerContext ctx) {
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress((ChannelHandlerContext)ctx);
        if (remoteAddress != null) {
            return remoteAddress;
        }
        return new InetSocketAddress(this.server.getLocalPort());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.failure("Exception caught by CONNECT proxy handler -> closing pipeline ", cause, ctx, this.failureResponse(null));
    }

    private void failure(String message, Throwable cause, ChannelHandlerContext ctx, Object response) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            log.error(message, cause);
        }
        Channel channel = ctx.channel();
        channel.writeAndFlush(response);
        if (channel.isActive()) {
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected abstract void removeCodecSupport(ChannelHandlerContext var1);

    protected abstract Object successResponse(Object var1);

    protected abstract Object failureResponse(Object var1);

    protected void removeHandler(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerType) {
        if (pipeline.get(handlerType) != null) {
            pipeline.remove(handlerType);
        }
    }

    protected void removeHandler(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.toMap().containsValue(channelHandler)) {
            pipeline.remove(channelHandler);
        }
    }
}

