/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.proxy;

import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageKind;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.httpclient.BinaryBridgeHandler;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.netty.proxy.BinaryModifierApplier;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyException;
import de.gematik.test.tiger.proxy.handler.MultipleBinaryConnectionParser;
import de.gematik.test.tiger.proxy.handler.RbelBinaryModifierPlugin;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryModifierApplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryModifierApplier.class);
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private final List<RbelBinaryModifierPlugin> binaryModifierPlugins;
    private final RbelConverter rbelConverter;
    private final MultipleBinaryConnectionParser multipleBinaryConnectionParser;

    public BinaryModifierApplier(MockServerConfiguration configuration) {
        this.binaryModifierPlugins = configuration.binaryModifierPlugins();
        this.rbelConverter = configuration.rbelConverter();
        this.multipleBinaryConnectionParser = new MultipleBinaryConnectionParser(conId -> new NonRememberingSingleConnectionParser(this, conId, executor, configuration.rbelConverter(), configuration.binaryProxyListener()));
    }

    public List<BinaryMessage> applyModifierPlugins(BinaryMessage message, ChannelHandlerContext ctx, RbelMessageKind messageKind) {
        return this.applyModifierPluginsInternal(message, ctx, messageKind);
    }

    private List<BinaryMessage> applyModifierPluginsInternal(BinaryMessage message, ChannelHandlerContext ctx, RbelMessageKind messageKind) {
        if (this.binaryModifierPlugins == null || this.binaryModifierPlugins.isEmpty()) {
            return List.of(message);
        }
        return this.binaryMessageToRbelElement(message, ctx, messageKind).stream().map(target -> this.filterMessageThroughPlugins(message, target)).toList();
    }

    private BinaryMessage filterMessageThroughPlugins(BinaryMessage message, RbelElement target) {
        AtomicReference<BinaryMessage> modifiedMessage = new AtomicReference<BinaryMessage>(new BinaryMessage(target.getRawContent(), message.getTimestamp()));
        AtomicReference<RbelElement> parsedMessage = new AtomicReference<RbelElement>(target);
        for (RbelBinaryModifierPlugin plugin : this.binaryModifierPlugins) {
            try {
                plugin.modify(parsedMessage.get(), this.rbelConverter).ifPresent(res -> {
                    modifiedMessage.set(new BinaryMessage(res, message.getTimestamp()));
                    parsedMessage.set(this.rbelConverter.convertElement(new RbelElement(res, null).addFacet(((RbelElement)parsedMessage.get()).getFacetOrFail(RbelMessageMetadata.class))));
                });
            }
            catch (Exception e) {
                log.warn("Exception during modification of binary message with plugin {}: {}", (Object)plugin.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
        return modifiedMessage.get();
    }

    private List<RbelElement> binaryMessageToRbelElement(BinaryMessage message, ChannelHandlerContext ctx, RbelMessageKind messageKind) {
        try {
            Optional<RbelSocketAddress> incoming = Optional.ofNullable((Channel)ctx.channel().attr(BinaryBridgeHandler.INCOMING_CHANNEL).get()).map(Channel::remoteAddress).or(() -> Optional.ofNullable(ctx.channel().remoteAddress())).map(RbelSocketAddress::create);
            Optional<RbelSocketAddress> outgoing = Optional.ofNullable((InetSocketAddress)ctx.channel().attr(HttpActionHandler.REMOTE_SOCKET).get()).map(SocketAddress.class::cast).or(() -> Optional.ofNullable((Channel)ctx.channel().attr(BinaryBridgeHandler.OUTGOING_CHANNEL).get()).map(Channel::remoteAddress)).map(RbelSocketAddress::create);
            return (List)this.multipleBinaryConnectionParser.addToBuffer((RbelSocketAddress)incoming.orElse(null), (RbelSocketAddress)outgoing.orElse(null), message.getBytes(), ZonedDateTime.of(message.getTimestamp(), ZoneId.systemDefault()), messageKind).get(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | TimeoutException e) {
            Thread.currentThread().interrupt();
            throw new TigerProxyException("Could not complete waiting for message to be parsed before applying binary modifier!", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TigerProxyException("Exception while converting message!", (Throwable)e);
        }
    }
}

