/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.proxy;

import de.gematik.rbellogger.data.RbelMessageKind;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.httpclient.BinaryRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.netty.proxy.BinaryModifierApplier;
import de.gematik.test.tiger.mockserver.netty.unification.PortUnificationHandler;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BinaryHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryHandler.class);
    private final NettyHttpClient httpClient;
    private final BinaryExchangeHandler binaryExchangeCallback;
    private final BinaryModifierApplier binaryModifierApplier;

    public BinaryHandler(MockServerConfiguration configuration, NettyHttpClient httpClient) {
        super(true);
        this.httpClient = httpClient;
        this.binaryExchangeCallback = configuration.binaryProxyListener();
        this.binaryModifierApplier = new BinaryModifierApplier(configuration);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
        BinaryMessage binaryRequest = BinaryMessage.bytes((byte[])ByteBufUtil.getBytes((ByteBuf)byteBuf));
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress((ChannelHandlerContext)ctx);
        if (remoteAddress != null) {
            this.binaryModifierApplier.applyModifierPlugins(binaryRequest, ctx, RbelMessageKind.REQUEST).forEach(msg -> this.sendMessage(new BinaryRequestInfo(ctx.channel(), msg, remoteAddress)));
        } else {
            log.info("unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP, found request in binary: {} in utf8 text: {}", (Object)ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), (Object)new String(binaryRequest.getBytes(), StandardCharsets.UTF_8));
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])"unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP".getBytes(StandardCharsets.UTF_8)));
            ctx.close();
        }
    }

    private void sendMessage(BinaryRequestInfo binaryRequestInfo) {
        this.httpClient.sendRequest(binaryRequestInfo, PortUnificationHandler.isSslEnabledUpstream((Channel)binaryRequestInfo.getIncomingChannel())).exceptionally(throwable -> {
            this.binaryExchangeCallback.propagateExceptionMessageSafe(throwable, RbelSocketAddress.create((SocketAddress)binaryRequestInfo.getRemoteServerAddress()), RbelSocketAddress.create((SocketAddress)binaryRequestInfo.getIncomingChannel().remoteAddress()));
            return null;
        });
        this.processNotWaitingForResponse(binaryRequestInfo);
    }

    private void processNotWaitingForResponse(BinaryRequestInfo binaryRequestInfo) {
        if (this.binaryExchangeCallback != null) {
            this.binaryExchangeCallback.onProxy((BinaryMessage)binaryRequestInfo.getDataToSend(), (SocketAddress)binaryRequestInfo.getRemoteServerAddress(), binaryRequestInfo.getIncomingChannel().remoteAddress(), RbelMessageKind.REQUEST);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.binaryExchangeCallback.propagateExceptionMessageSafe(cause, RbelSocketAddress.create((SocketAddress)ctx.channel().remoteAddress()), null);
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

