/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty;

import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.mockserver.httpclient.ClientBootstrapFactory;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import io.netty.channel.Channel;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerInfiniteLoopChecker {
    private static final Logger log = LoggerFactory.getLogger(MockServerInfiniteLoopChecker.class);
    private final NettyHttpClient nettyHttpClient;

    public boolean isInfiniteLoop(Channel incomingChannel) {
        if (incomingChannel == null) {
            return false;
        }
        SocketAddress socketAddress = incomingChannel.remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress remoteClientAddress = (InetSocketAddress)socketAddress;
            int loopCounter = this.nettyHttpClient.queryClientPort(remoteClientAddress.getPort());
            incomingChannel.attr(ClientBootstrapFactory.LOOP_COUNTER).set((Object)loopCounter);
            return loopCounter > (Integer)TigerConfigurationKeys.TIGER_PROXY_MAX_LOOP_COUNTER.getValueOrDefault();
        }
        return false;
    }

    @ConstructorProperties(value={"nettyHttpClient"})
    @Generated
    public MockServerInfiniteLoopChecker(NettyHttpClient nettyHttpClient) {
        this.nettyHttpClient = nettyHttpClient;
    }
}

