/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.lifecycle.LifeCycle;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.netty.MockServer;
import de.gematik.test.tiger.mockserver.netty.MockServerInfiniteLoopChecker;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import de.gematik.test.tiger.proxy.data.TigerConnectionStatus;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer
extends LifeCycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServer.class);
    private final InetSocketAddress remoteSocket;
    private HttpActionHandler actionHandler;
    private final Map<SocketAddress, TigerConnectionStatus> connectionStatusMap = new ConcurrentHashMap();
    private NettySslContextFactory serverSslContextFactory;
    private NettySslContextFactory clientSslContextFactory;
    private MockServerInfiniteLoopChecker infiniteLoopChecker;

    public MockServer(MockServerConfiguration configuration, Integer ... localPorts) {
        super(configuration);
        this.remoteSocket = configuration.directForwarding() != null ? SocketUtils.socketAddress((String)configuration.directForwarding().getHostName(), (int)configuration.directForwarding().getPort()) : null;
        this.createServerBootstrap(configuration, localPorts);
        this.getLocalPort();
    }

    private void createServerBootstrap(MockServerConfiguration configuration, Integer ... localPorts) {
        if (configuration == null) {
            configuration = MockServerConfiguration.configuration();
        }
        List<Integer> portBindings = Collections.singletonList(0);
        if (localPorts != null && localPorts.length > 0) {
            portBindings = Arrays.asList(localPorts);
        }
        this.serverSslContextFactory = new NettySslContextFactory(configuration, true);
        this.clientSslContextFactory = new NettySslContextFactory(configuration, false);
        NettyHttpClient httpClient = new NettyHttpClient(configuration, this.getEventLoopGroup(), this.clientSslContextFactory);
        this.infiniteLoopChecker = new MockServerInfiniteLoopChecker(httpClient);
        this.actionHandler = new HttpActionHandler(configuration, this.httpState, httpClient);
        this.serverServerBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new MockServerChannelInitializer(this, configuration, this, this.httpState, this.actionHandler)).childAttr(HttpActionHandler.REMOTE_SOCKET, (Object)this.remoteSocket);
        try {
            this.bindServerPorts(portBindings);
        }
        catch (RuntimeException throwable) {
            log.error("exception binding to port(s) {}", portBindings, (Object)throwable);
            this.stop();
            throw throwable;
        }
        this.startedServer(this.getLocalPorts());
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }

    public void removeExpectation(String expectationId) {
        this.httpState.clear(expectationId);
    }

    public List<Expectation> retrieveActiveExpectations() {
        return this.httpState.retrieveActiveExpectations();
    }

    public synchronized void addConnectionWithStatus(SocketAddress socketAddress, TigerConnectionStatus status) {
        this.connectionStatusMap.put(socketAddress, status);
    }

    public synchronized Map<SocketAddress, TigerConnectionStatus> getOpenConnections() {
        return this.connectionStatusMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public synchronized void removeRemoteAddress(SocketAddress socketAddress) {
        this.connectionStatusMap.remove(socketAddress);
    }

    public Expectation addRoute(Expectation expectation) {
        this.getHttpState().add(expectation);
        return expectation;
    }

    public void waitForAllParsingTasksToBeFinished() {
        Optional.of(this.getConfiguration()).map(MockServerConfiguration::binaryProxyListener).ifPresent(BinaryExchangeHandler::waitForAllParsingTasksToBeFinished);
    }

    @Generated
    public InetSocketAddress getRemoteSocket() {
        return this.remoteSocket;
    }

    @Generated
    public HttpActionHandler getActionHandler() {
        return this.actionHandler;
    }

    @Generated
    public Map<SocketAddress, TigerConnectionStatus> getConnectionStatusMap() {
        return this.connectionStatusMap;
    }

    @Generated
    public NettySslContextFactory getServerSslContextFactory() {
        return this.serverSslContextFactory;
    }

    @Generated
    public NettySslContextFactory getClientSslContextFactory() {
        return this.clientSslContextFactory;
    }

    @Generated
    public MockServerInfiniteLoopChecker getInfiniteLoopChecker() {
        return this.infiniteLoopChecker;
    }
}

