/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import lombok.Generated;

public class MockserverX509CertificateWrapper
extends ObjectWithJsonToString {
    @JsonIgnore
    private X509Certificate certificate;
    @JsonIgnore
    private byte[] certificateBytes;
    private String issuerDistinguishedName;
    private String subjectDistinguishedName;
    @JsonIgnore
    private String serialNumber;
    @JsonIgnore
    private String signatureAlgorithmName;

    public static MockserverX509CertificateWrapper with(X509Certificate x509Certificate) {
        return new MockserverX509CertificateWrapper().serialNumber(x509Certificate.getSerialNumber().toString()).issuerDistinguishedName(x509Certificate.getIssuerX500Principal().getName()).subjectDistinguishedName(x509Certificate.getSubjectX500Principal().getName()).signatureAlgorithmName(x509Certificate.getSigAlgName()).certificate(x509Certificate);
    }

    @Generated
    public MockserverX509CertificateWrapper() {
    }

    @Generated
    public X509Certificate certificate() {
        return this.certificate;
    }

    @Generated
    public byte[] certificateBytes() {
        return this.certificateBytes;
    }

    @Generated
    public String issuerDistinguishedName() {
        return this.issuerDistinguishedName;
    }

    @Generated
    public String subjectDistinguishedName() {
        return this.subjectDistinguishedName;
    }

    @Generated
    public String serialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String signatureAlgorithmName() {
        return this.signatureAlgorithmName;
    }

    @JsonIgnore
    @Generated
    public MockserverX509CertificateWrapper certificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    @JsonIgnore
    @Generated
    public MockserverX509CertificateWrapper certificateBytes(byte[] certificateBytes) {
        this.certificateBytes = certificateBytes;
        return this;
    }

    @Generated
    public MockserverX509CertificateWrapper issuerDistinguishedName(String issuerDistinguishedName) {
        this.issuerDistinguishedName = issuerDistinguishedName;
        return this;
    }

    @Generated
    public MockserverX509CertificateWrapper subjectDistinguishedName(String subjectDistinguishedName) {
        this.subjectDistinguishedName = subjectDistinguishedName;
        return this;
    }

    @JsonIgnore
    @Generated
    public MockserverX509CertificateWrapper serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @JsonIgnore
    @Generated
    public MockserverX509CertificateWrapper signatureAlgorithmName(String signatureAlgorithmName) {
        this.signatureAlgorithmName = signatureAlgorithmName;
        return this;
    }

    @Generated
    public String toString() {
        return "MockserverX509CertificateWrapper(certificate=" + String.valueOf(this.certificate()) + ", certificateBytes=" + Arrays.toString(this.certificateBytes()) + ", issuerDistinguishedName=" + this.issuerDistinguishedName() + ", subjectDistinguishedName=" + this.subjectDistinguishedName() + ", serialNumber=" + this.serialNumber() + ", signatureAlgorithmName=" + this.signatureAlgorithmName() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockserverX509CertificateWrapper)) {
            return false;
        }
        MockserverX509CertificateWrapper other = (MockserverX509CertificateWrapper)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        X509Certificate this$certificate = this.certificate();
        X509Certificate other$certificate = other.certificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        if (!Arrays.equals(this.certificateBytes(), other.certificateBytes())) {
            return false;
        }
        String this$issuerDistinguishedName = this.issuerDistinguishedName();
        String other$issuerDistinguishedName = other.issuerDistinguishedName();
        if (this$issuerDistinguishedName == null ? other$issuerDistinguishedName != null : !this$issuerDistinguishedName.equals(other$issuerDistinguishedName)) {
            return false;
        }
        String this$subjectDistinguishedName = this.subjectDistinguishedName();
        String other$subjectDistinguishedName = other.subjectDistinguishedName();
        if (this$subjectDistinguishedName == null ? other$subjectDistinguishedName != null : !this$subjectDistinguishedName.equals(other$subjectDistinguishedName)) {
            return false;
        }
        String this$serialNumber = this.serialNumber();
        String other$serialNumber = other.serialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$signatureAlgorithmName = this.signatureAlgorithmName();
        String other$signatureAlgorithmName = other.signatureAlgorithmName();
        return !(this$signatureAlgorithmName == null ? other$signatureAlgorithmName != null : !this$signatureAlgorithmName.equals(other$signatureAlgorithmName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MockserverX509CertificateWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        X509Certificate $certificate = this.certificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        result = result * 59 + Arrays.hashCode(this.certificateBytes());
        String $issuerDistinguishedName = this.issuerDistinguishedName();
        result = result * 59 + ($issuerDistinguishedName == null ? 43 : $issuerDistinguishedName.hashCode());
        String $subjectDistinguishedName = this.subjectDistinguishedName();
        result = result * 59 + ($subjectDistinguishedName == null ? 43 : $subjectDistinguishedName.hashCode());
        String $serialNumber = this.serialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $signatureAlgorithmName = this.signatureAlgorithmName();
        result = result * 59 + ($signatureAlgorithmName == null ? 43 : $signatureAlgorithmName.hashCode());
        return result;
    }
}

