/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock.action.http;

import de.gematik.rbellogger.util.RbelInternetAddressParser;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.mockserver.character.Character;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.filters.HopByHopHeaderFilter;
import de.gematik.test.tiger.mockserver.httpclient.HttpRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.httpclient.SocketCommunicationException;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.mock.HttpAction;
import de.gematik.test.tiger.mockserver.mock.HttpState;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpForwardActionHandler;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpForwardActionResult;
import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.CloseChannel;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.netty.responsewriter.NettyResponseWriter;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRoutingException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpActionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpActionHandler.class);
    public static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf((String)"REMOTE_SOCKET");
    private final MockServerConfiguration configuration;
    private final HttpState httpStateHandler;
    private final Scheduler scheduler;
    private HttpForwardActionHandler httpForwardActionHandler;
    private NettyHttpClient httpClient;
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    public HttpActionHandler(MockServerConfiguration configuration, HttpState httpStateHandler, NettyHttpClient nettyHttp) {
        this.configuration = configuration;
        this.httpStateHandler = httpStateHandler;
        this.scheduler = httpStateHandler.getScheduler();
        this.httpClient = nettyHttp;
    }

    public void processAction(HttpRequest request, NettyResponseWriter responseWriter, ChannelHandlerContext ctx, boolean proxyingRequest, boolean synchronous) {
        Expectation expectation = this.httpStateHandler.firstMatchingExpectation(request);
        if (expectation != null && expectation.getHttpAction() != null) {
            HttpAction action = expectation.getHttpAction();
            this.scheduler.schedule(() -> action.handle(request, ctx.channel(), this, responseWriter, synchronous));
        } else if (!proxyingRequest) {
            log.info("No route found for {}", (Object)request.printLogLineDescription());
            this.closeChannelWithErrorMessage(responseWriter, request, (Throwable)new TigerProxyRoutingException("No route found", RbelSocketAddress.create((SocketAddress)HttpActionHandler.getRemoteAddress((ChannelHandlerContext)ctx)), null, null), new InetSocketAddress[0]);
        } else {
            InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress((ChannelHandlerContext)ctx);
            HttpRequest clonedRequest = this.hopByHopHeaderFilter.onRequest(request);
            HttpForwardActionResult responseFuture = new HttpForwardActionResult(clonedRequest, this.httpClient.sendRequest(new HttpRequestInfo(ctx.channel(), clonedRequest, remoteAddress), this.configuration.socketConnectionTimeoutInMillis()), null, remoteAddress);
            this.scheduler.submit(responseFuture, () -> {
                try {
                    HttpResponse response = (HttpResponse)responseFuture.getHttpResponse().get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                    if (response == null) {
                        response = HttpResponse.notFoundResponse();
                    }
                    log.debug("returning response:{}\nfor forwarded request" + Character.NEW_LINE + Character.NEW_LINE + " in json:{}", (Object)request, (Object)response);
                    responseWriter.writeResponse(request, (Action)response);
                }
                catch (SocketCommunicationException | InterruptedException | ExecutionException | TimeoutException e) {
                    if (e instanceof TimeoutException) {
                        Thread.currentThread().interrupt();
                    }
                    this.closeChannelWithErrorMessage(responseWriter, request, e, new InetSocketAddress[]{remoteAddress});
                }
            }, synchronous, throwable -> throwable.getMessage().contains("Connection refused"));
        }
    }

    public void executeAfterForwardActionResponse(HttpForwardActionResult responseFuture, BiConsumer<HttpResponse, Throwable> command, boolean synchronous) {
        this.scheduler.submit(responseFuture, command, synchronous);
    }

    public void writeForwardActionResponse(HttpForwardActionResult responseFuture, NettyResponseWriter responseWriter, HttpRequest request, Action action, boolean synchronous) {
        this.scheduler.submit(responseFuture, () -> {
            try {
                HttpResponse response = (HttpResponse)responseFuture.getHttpResponse().get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                responseWriter.writeResponse(request, (Action)response);
                log.atDebug().addArgument((Object)response).addArgument(() -> ((HttpForwardActionResult)responseFuture).getHttpRequest()).addArgument((Object)action).addArgument(() -> ((Action)action).getExpectationId()).log("returning response: {} for forwarded request" + Character.NEW_LINE + Character.NEW_LINE + " in json: {}" + Character.NEW_LINE + Character.NEW_LINE + "\nfor action: {} from expectation: {}");
            }
            catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException throwable) {
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.handleExceptionDuringForwardingRequest(action, request, responseWriter, (Throwable)throwable);
            }
        }, synchronous, throwable -> true);
    }

    public void writeForwardActionResponse(HttpResponse response, NettyResponseWriter responseWriter, HttpRequest request) {
        try {
            responseWriter.writeResponse(request, (Action)response);
            log.debug("returning response: {} for forwarded request" + Character.NEW_LINE + Character.NEW_LINE + " in json:{}", (Object)response, (Object)request);
        }
        catch (Exception exception) {
            log.error("Error while returning response", (Throwable)exception);
            this.closeChannelWithErrorMessage(responseWriter, request, (Throwable)exception, new InetSocketAddress[0]);
        }
    }

    public void handleExceptionDuringForwardingRequest(Action action, HttpRequest request, NettyResponseWriter responseWriter, Throwable exception) {
        if (action instanceof CloseChannel) {
            log.debug("closing channel due to close action");
            responseWriter.closeChannel();
        } else {
            this.closeChannelWithErrorMessage(responseWriter, request, exception, new InetSocketAddress[0]);
        }
    }

    private void closeChannelWithErrorMessage(NettyResponseWriter responseWriter, HttpRequest request, Throwable error, InetSocketAddress ... remoteAddress) {
        log.debug("error: {} handling request: {} returning response: {}", new Object[]{error, request, HttpResponse.notFoundResponse()});
        ChannelHandlerContext ctx = responseWriter.getCtx();
        if (this.configuration.exceptionHandlingCallback() != null && ctx.channel().isOpen()) {
            if (error instanceof TigerProxyRoutingException) {
                TigerProxyRoutingException routingException = (TigerProxyRoutingException)error;
                this.configuration.exceptionHandlingCallback().accept(routingException, ctx);
            } else {
                RbelSocketAddress senderAddress = null;
                if (remoteAddress.length > 0) {
                    senderAddress = RbelSocketAddress.create((SocketAddress)remoteAddress[0]);
                }
                TigerProxyRoutingException routingException = new TigerProxyRoutingException(error.getMessage(), senderAddress, null, error);
                this.configuration.exceptionHandlingCallback().accept(routingException, ctx);
            }
        }
        responseWriter.closeChannel();
    }

    public HttpForwardActionHandler getHttpForwardActionHandler() {
        if (this.httpForwardActionHandler == null) {
            this.httpForwardActionHandler = new HttpForwardActionHandler(this.httpClient);
        }
        return this.httpForwardActionHandler;
    }

    public static InetSocketAddress getRemoteAddress(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel() != null && ctx.channel().attr(REMOTE_SOCKET) != null) {
            InetSocketAddress remoteSocket = (InetSocketAddress)ctx.channel().attr(REMOTE_SOCKET).get();
            SocketAddress localAddress = ctx.channel().localAddress();
            if (remoteSocket != null) {
                if (remoteSocket.getAddress() != null && remoteSocket.getAddress().isLoopbackAddress() && localAddress instanceof InetSocketAddress) {
                    InetSocketAddress localInetSocketAddress = (InetSocketAddress)localAddress;
                    return new InetSocketAddress(localInetSocketAddress.getAddress(), remoteSocket.getPort());
                }
                return RbelInternetAddressParser.parseInetAddress((String)remoteSocket.toString()).toInetAddress().map(inetAdr -> new InetSocketAddress((InetAddress)inetAdr, remoteSocket.getPort())).orElse(remoteSocket);
            }
            return remoteSocket;
        }
        return null;
    }

    @Generated
    public NettyHttpClient getHttpClient() {
        return this.httpClient;
    }
}

