/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import de.gematik.test.tiger.mockserver.uuid.UUIDService;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpState.class);
    private static final ThreadLocal<Integer> LOCAL_PORT = new ThreadLocal();
    private final Scheduler scheduler;
    private final MockServerConfiguration configuration;
    private final List<Expectation> expectations = new ArrayList();

    public static void setPort(HttpRequest request) {
        if (request != null && request.getReceiverAddress() != null) {
            HttpState.setPort((Integer)request.getReceiverAddress().getPort());
            request.setReceiverAddress(null);
        }
    }

    public static void clearPort() {
        LOCAL_PORT.remove();
    }

    public static void setPort(Integer port) {
        LOCAL_PORT.set(port);
    }

    public static void setPort(Integer ... port) {
        if (port != null && port.length > 0) {
            HttpState.setPort((Integer)port[0]);
        }
    }

    public static void setPort(List<Integer> port) {
        if (port != null && !port.isEmpty()) {
            HttpState.setPort((Integer)port.get(0));
        }
    }

    public static Integer getPort() {
        return (Integer)LOCAL_PORT.get();
    }

    public HttpState(MockServerConfiguration configuration, Scheduler scheduler) {
        this.configuration = configuration;
        this.scheduler = scheduler;
    }

    public void add(Expectation expectation) {
        this.expectations.add(expectation);
        String hostHeader = expectation.getRequestPattern().getFirstHeader(HttpHeaderNames.HOST.toString());
        if (StringUtils.isNotBlank((CharSequence)hostHeader)) {
            this.scheduler.submit(() -> this.configuration.addSubjectAlternativeName(hostHeader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expectation firstMatchingExpectation(HttpRequest request) {
        log.atTrace().addArgument(() -> ((HttpRequest)request).printLogLineDescription()).log("Trying to find route for {}");
        RbelElement oldCorrespondingMessage = request.getCorrespondingRbelMessage();
        try {
            request.setCorrespondingRbelMessage(null);
            for (Expectation expectation : this.expectations.stream().sorted().toList()) {
                if (!expectation.matches(request)) continue;
                log.atDebug().addArgument(() -> ((Expectation)expectation).createShortDescription()).addArgument(() -> ((HttpRequest)request).printLogLineDescription()).log("Route {} matched request {}");
                Expectation expectation2 = expectation;
                return expectation2;
            }
            log.atWarn().addArgument(() -> ((HttpRequest)request).printLogLineDescription()).log("No matching route found for request {}");
            Iterator iterator = null;
            return iterator;
        }
        finally {
            request.setCorrespondingRbelMessage(oldCorrespondingMessage);
        }
    }

    public boolean handle(HttpRequest request) {
        request.setLogCorrelationId(UUIDService.getUUID());
        HttpState.setPort((HttpRequest)request);
        return false;
    }

    public List<Expectation> retrieveActiveExpectations() {
        return this.expectations.stream().toList();
    }

    public void clear(String expectationId) {
        boolean foundRoute = this.expectations.removeIf(expectation -> expectation.getId().equals(expectationId));
        log.info("removed expectation with id [{}]: {}", (Object)expectationId, (Object)foundRoute);
    }

    @Generated
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public MockServerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public List<Expectation> getExpectations() {
        return this.expectations;
    }
}

