/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mappers;

import de.gematik.test.tiger.mockserver.codec.BodyDecoderEncoder;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerHttpResponseToFullHttpResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServerHttpResponseToFullHttpResponse.class);
    private final BodyDecoderEncoder bodyDecoderEncoder = new BodyDecoderEncoder();

    public List<DefaultHttpObject> mapMockServerResponseToNettyResponse(HttpResponse httpResponse) {
        try {
            ByteBuf body = this.getBody(httpResponse);
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(httpResponse), body);
            this.setHeaders(httpResponse, (DefaultHttpResponse)defaultFullHttpResponse, body);
            return Collections.singletonList(defaultFullHttpResponse);
        }
        catch (Exception e) {
            log.error("exception encoding response{}", (Object)httpResponse, (Object)e);
            return Collections.singletonList(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(httpResponse)));
        }
    }

    private HttpResponseStatus getStatus(HttpResponse httpResponse) {
        int statusCode = httpResponse.getStatusCode() != null ? httpResponse.getStatusCode() : 200;
        String reasonPhrase = httpResponse.getReasonPhrase() != null ? httpResponse.getReasonPhrase() : "";
        return new HttpResponseStatus(statusCode, reasonPhrase);
    }

    private ByteBuf getBody(HttpResponse httpResponse) {
        return this.bodyDecoderEncoder.bodyToByteBuf(httpResponse.getBody());
    }

    private void setHeaders(HttpResponse httpResponse, DefaultHttpResponse response, ByteBuf body) {
        Integer streamId;
        if (httpResponse.getHeaders() != null) {
            httpResponse.getHeaderMultimap().entries().forEach(entry -> response.headers().add((String)entry.getKey(), entry.getValue()));
        }
        if (StringUtils.isBlank((CharSequence)httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_LENGTH.toString()))) {
            boolean chunkedEncoding = response.headers().contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            if (chunkedEncoding) {
                response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            } else {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
            }
        }
        if ((streamId = httpResponse.getStreamId()) != null) {
            response.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
    }
}

