/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mappers;

import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.MockserverX509CertificateWrapper;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDKCertificateToMockServerX509Certificate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDKCertificateToMockServerX509Certificate.class);

    public HttpRequest setClientCertificates(HttpRequest httpRequest, Certificate[] clientCertificates) {
        List x509Certificates;
        if (clientCertificates != null && !(x509Certificates = Arrays.stream(clientCertificates).flatMap(certificate -> {
            try {
                X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate.getEncoded()));
                return Stream.of(MockserverX509CertificateWrapper.with((X509Certificate)x509Certificate));
            }
            catch (Exception e) {
                log.info("exception decoding client certificate", (Throwable)e);
                return Stream.empty();
            }
        }).toList()).isEmpty()) {
            httpRequest.setClientCertificateChain(x509Certificates);
        }
        return httpRequest;
    }
}

