/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mappers;

import de.gematik.test.tiger.mockserver.codec.BodyDecoderEncoder;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullHttpResponseToMockServerHttpResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FullHttpResponseToMockServerHttpResponse.class);
    private final BodyDecoderEncoder bodyDecoderEncoder = new BodyDecoderEncoder();

    public HttpResponse mapFullHttpResponseToMockServerResponse(FullHttpResponse fullHttpResponse) {
        HttpResponse httpResponse = new HttpResponse();
        try {
            if (fullHttpResponse != null) {
                if (fullHttpResponse.decoderResult().isFailure()) {
                    log.error("exception decoding response ", fullHttpResponse.decoderResult().cause());
                }
                this.setStatusCode(httpResponse, fullHttpResponse);
                this.setHeaders(httpResponse, fullHttpResponse);
                this.setBody(httpResponse, fullHttpResponse);
            }
        }
        catch (RuntimeException e) {
            log.error("exception decoding response {}", (Object)fullHttpResponse, (Object)e);
        }
        return httpResponse;
    }

    private void setStatusCode(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        HttpResponseStatus status = fullHttpResponse.status();
        httpResponse.withStatusCode(Integer.valueOf(status.code()));
        httpResponse.withReasonPhrase(status.reasonPhrase());
    }

    private void setHeaders(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        Set headerNames = fullHttpResponse.headers().names();
        if (!headerNames.isEmpty()) {
            Headers headers = new Headers(new Header[0]);
            for (String headerName : headerNames) {
                headers.withEntry(headerName, fullHttpResponse.headers().getAll(headerName));
            }
            httpResponse.withHeaders(headers);
        }
    }

    private void setBody(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        httpResponse.withBody(this.bodyDecoderEncoder.byteBufToBody(fullHttpResponse.content()));
    }
}

