/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mappers;

import de.gematik.test.tiger.mockserver.codec.BodyDecoderEncoder;
import de.gematik.test.tiger.mockserver.codec.ExpandedParameterDecoder;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.mappers.JDKCertificateToMockServerX509Certificate;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.url.URLParser;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullHttpRequestToMockServerHttpRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FullHttpRequestToMockServerHttpRequest.class);
    private final BodyDecoderEncoder bodyDecoderEncoder = new BodyDecoderEncoder();
    private final ExpandedParameterDecoder formParameterParser;
    private final boolean isSecure;
    private final Certificate[] clientCertificates;
    private final Integer port;
    private final JDKCertificateToMockServerX509Certificate jdkCertificateToMockServerX509Certificate;

    public FullHttpRequestToMockServerHttpRequest(MockServerConfiguration configuration, boolean isSecure, Certificate[] clientCertificates, Integer port) {
        this.formParameterParser = new ExpandedParameterDecoder(configuration);
        this.isSecure = isSecure;
        this.clientCertificates = clientCertificates;
        this.port = port;
        this.jdkCertificateToMockServerX509Certificate = new JDKCertificateToMockServerX509Certificate();
    }

    public HttpRequest mapFullHttpRequestToMockServerRequest(FullHttpRequest fullHttpRequest, List<Header> preservedHeaders, SocketAddress senderAddress, Optional<HttpProtocol> protocol, SSLSession sslSession, boolean isProxying) {
        HttpRequest httpRequest = new HttpRequest();
        try {
            if (fullHttpRequest != null) {
                if (fullHttpRequest.decoderResult().isFailure()) {
                    log.warn("exception decoding request {}", (Object)fullHttpRequest.decoderResult().cause().getMessage(), (Object)fullHttpRequest.decoderResult().cause());
                }
                this.setMethod(httpRequest, fullHttpRequest);
                httpRequest.setKeepAlive(Boolean.valueOf(HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)));
                httpRequest.setSecure(Boolean.valueOf(this.isSecure));
                httpRequest.setProtocol(protocol.orElse(HttpProtocol.HTTP_1_1));
                this.setPath(httpRequest, fullHttpRequest);
                this.setQueryString(httpRequest, fullHttpRequest);
                this.setHeaders(httpRequest, fullHttpRequest, preservedHeaders);
                this.setBody(httpRequest, fullHttpRequest);
                this.setSocketAddress(httpRequest, fullHttpRequest, this.isSecure, this.port, senderAddress);
                this.setForwardProxyRequest(httpRequest, fullHttpRequest, isProxying);
                this.jdkCertificateToMockServerX509Certificate.setClientCertificates(httpRequest, this.clientCertificates);
                this.tryToSetTlsParameter(httpRequest, sslSession);
            }
        }
        catch (RuntimeException e) {
            log.error("exception decoding request{}", (Object)fullHttpRequest, (Object)e);
        }
        return httpRequest;
    }

    private void setForwardProxyRequest(HttpRequest httpRequest, FullHttpRequest fullHttpRequest, boolean isProxying) {
        if (isProxying) {
            httpRequest.setForwardProxyRequest(Boolean.valueOf(true));
        } else {
            try {
                String uriHost = new URI(fullHttpRequest.uri()).getHost();
                if (StringUtils.isNotBlank((CharSequence)uriHost) || fullHttpRequest.method() == HttpMethod.CONNECT) {
                    httpRequest.setForwardProxyRequest(Boolean.valueOf(true));
                }
            }
            catch (URISyntaxException e) {
                httpRequest.setForwardProxyRequest(Boolean.valueOf(false));
            }
        }
    }

    private void tryToSetTlsParameter(HttpRequest httpRequest, SSLSession sslSession) {
        if (sslSession != null) {
            httpRequest.setTlsVersion(sslSession.getProtocol());
            httpRequest.setCipherSuite(sslSession.getCipherSuite());
        }
    }

    private void setSocketAddress(HttpRequest httpRequest, FullHttpRequest fullHttpRequest, boolean isSecure, Integer port, SocketAddress senderAddress) {
        httpRequest.setReceiverAddress(Boolean.valueOf(isSecure), fullHttpRequest.headers().get("host"), port);
        if (senderAddress instanceof InetSocketAddress) {
            httpRequest.setSenderAddress(StringUtils.removeStart((String)senderAddress.toString(), (String)"/"));
        }
    }

    private void setMethod(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        httpRequest.setMethod(fullHttpResponse.method().name());
    }

    private void setPath(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        httpRequest.setPath(URLParser.returnPath((String)fullHttpRequest.uri()));
    }

    private void setQueryString(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        if (fullHttpRequest.uri().contains("?")) {
            httpRequest.setQueryStringParameters(this.formParameterParser.retrieveQueryParameters(fullHttpRequest.uri(), true));
        }
    }

    private void setHeaders(HttpRequest httpRequest, FullHttpRequest fullHttpResponse, List<Header> preservedHeaders) {
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        if (!httpHeaders.isEmpty()) {
            Headers headers = new Headers(new Header[0]);
            for (String headerName : httpHeaders.names()) {
                headers.withEntry(headerName, httpHeaders.getAll(headerName));
            }
            httpRequest.withHeaders(headers);
        }
        if (preservedHeaders != null && !preservedHeaders.isEmpty()) {
            for (Header preservedHeader : preservedHeaders) {
                httpRequest.withHeader(preservedHeader);
            }
        }
        if (HttpProtocol.HTTP_2.equals((Object)httpRequest.getProtocol())) {
            Integer streamId = fullHttpResponse.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            httpRequest.setStreamId(streamId);
        }
    }

    private void setBody(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        httpRequest.withBody(this.bodyDecoderEncoder.byteBufToBody(fullHttpRequest.content()));
    }
}

