/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.lifecycle;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.mock.HttpState;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LifeCycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LifeCycle.class);
    protected final EventLoopGroup bossGroup;
    protected final EventLoopGroup workerGroup;
    protected final HttpState httpState;
    private final MockServerConfiguration configuration;
    protected ServerBootstrap serverServerBootstrap;
    private final List<Future<Channel>> serverChannelFutures = new ArrayList();
    private final CompletableFuture<String> stopFuture = new CompletableFuture();
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final Scheduler scheduler;

    protected LifeCycle(MockServerConfiguration configuration) {
        HttpState.clearPort();
        this.configuration = configuration != null ? configuration : MockServerConfiguration.configuration();
        this.bossGroup = new NioEventLoopGroup(5, (ThreadFactory)new Scheduler.SchedulerThreadFactory(this.getMockServerName() + "-bossGroup"));
        this.workerGroup = new NioEventLoopGroup(this.configuration.nioEventLoopThreadCount().intValue(), (ThreadFactory)new Scheduler.SchedulerThreadFactory(this.getMockServerName() + "-workerEventLoop"));
        this.scheduler = new Scheduler(this.configuration);
        this.httpState = new HttpState(this.configuration, this.scheduler);
    }

    private String getMockServerName() {
        if (this.configuration.mockServerName() != null) {
            return this.configuration.mockServerName();
        }
        return this.getClass().getSimpleName();
    }

    public CompletableFuture<String> stopAsync() {
        if (!this.stopFuture.isDone() && this.stopping.compareAndSet(false, true)) {
            String message = "stopped for port" + (this.getLocalPorts().size() == 1 ? ": " + String.valueOf(this.getLocalPorts().get(0)) : "s: " + String.valueOf(this.getLocalPorts()));
            log.info(message);
            new Scheduler.SchedulerThreadFactory("Stop").newThread(() -> {
                List<ChannelFuture> collect = this.serverChannelFutures.stream().flatMap(channelFuture -> {
                    try {
                        return Stream.of((Channel)channelFuture.get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        return Stream.empty();
                    }
                }).map(ChannelOutboundInvoker::disconnect).toList();
                try {
                    for (ChannelFuture channelFuture2 : collect) {
                        channelFuture2.get();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    log.debug("Ignoring exception", (Throwable)e);
                }
                this.scheduler.shutdown();
                this.bossGroup.shutdownGracefully(5L, 5L, TimeUnit.MILLISECONDS);
                this.workerGroup.shutdownGracefully(5L, 5L, TimeUnit.MILLISECONDS);
                this.bossGroup.terminationFuture().syncUninterruptibly();
                this.workerGroup.terminationFuture().syncUninterruptibly();
                this.stopFuture.complete(message);
            }).start();
        }
        return this.stopFuture;
    }

    public void stop() {
        try {
            this.stopAsync().get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.debug("Ignoring exception while stopping", (Throwable)e);
        }
    }

    public void close() {
        this.stop();
    }

    protected EventLoopGroup getEventLoopGroup() {
        return this.workerGroup;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isRunning() {
        return !this.bossGroup.isShuttingDown() || !this.workerGroup.isShuttingDown();
    }

    public List<Integer> getLocalPorts() {
        return this.getBoundPorts(this.serverChannelFutures);
    }

    @Deprecated
    public Integer getPort() {
        return this.getLocalPort();
    }

    public int getLocalPort() {
        return this.getFirstBoundPort(this.serverChannelFutures);
    }

    private Integer getFirstBoundPort(List<Future<Channel>> channelFutures) {
        for (Future<Channel> channelOpened : channelFutures) {
            try {
                return ((InetSocketAddress)channelOpened.get(15L, TimeUnit.SECONDS).localAddress()).getPort();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.debug("exception while retrieving port from channel future, ignoring port for this channel", (Throwable)e);
            }
        }
        return -1;
    }

    private List<Integer> getBoundPorts(List<Future<Channel>> channelFutures) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Future<Channel> channelOpened : channelFutures) {
            try {
                ports.add(((InetSocketAddress)channelOpened.get(3L, TimeUnit.SECONDS).localAddress()).getPort());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.debug("exception while retrieving port from channel future, ignoring port for this channel", (Throwable)e);
            }
        }
        return ports;
    }

    public List<Integer> bindServerPorts(List<Integer> requestedPortBindings) {
        return this.bindPorts(this.serverServerBootstrap, requestedPortBindings, this.serverChannelFutures);
    }

    private List<Integer> bindPorts(ServerBootstrap serverBootstrap, List<Integer> requestedPortBindings, List<Future<Channel>> channelFutures) {
        ArrayList<Integer> actualPortBindings = new ArrayList<Integer>();
        for (Integer portToBind : requestedPortBindings) {
            try {
                CompletableFuture channelOpened = new CompletableFuture();
                channelFutures.add(channelOpened);
                new Scheduler.SchedulerThreadFactory(this.getMockServerName() + " thread for port: " + portToBind, false).newThread(() -> {
                    try {
                        InetSocketAddress inetSocketAddress = new InetSocketAddress(portToBind);
                        serverBootstrap.bind((SocketAddress)inetSocketAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                            if (future.isSuccess()) {
                                channelOpened.complete(future.channel());
                            } else {
                                channelOpened.completeExceptionally(future.cause());
                            }
                        })).channel().closeFuture().syncUninterruptibly();
                    }
                    catch (Exception e) {
                        channelOpened.completeExceptionally(new RuntimeException("Exception while binding MockServer to port " + portToBind, e));
                    }
                }).start();
                actualPortBindings.add(((InetSocketAddress)((Channel)channelOpened.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS)).localAddress()).getPort());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new RuntimeException("Exception while binding MockServer to port " + portToBind, e instanceof ExecutionException ? e.getCause() : e);
            }
        }
        return actualPortBindings;
    }

    protected void startedServer(List<Integer> ports) {
        String message = "started mockserver on port" + (ports.size() == 1 ? ": " + String.valueOf(ports.get(0)) : "s: " + String.valueOf(ports));
        HttpState.setPort(ports);
        log.trace(message);
    }

    @Generated
    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    @Generated
    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public HttpState getHttpState() {
        return this.httpState;
    }

    @Generated
    public MockServerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public ServerBootstrap getServerServerBootstrap() {
        return this.serverServerBootstrap;
    }

    @Generated
    public List<Future<Channel>> getServerChannelFutures() {
        return this.serverChannelFutures;
    }

    @Generated
    public CompletableFuture<String> getStopFuture() {
        return this.stopFuture;
    }

    @Generated
    public AtomicBoolean getStopping() {
        return this.stopping;
    }
}

