/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.test.tiger.mockserver.codec.MockServerBinaryClientCodec;
import de.gematik.test.tiger.mockserver.codec.MockServerHttpClientCodec;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.httpclient.BinaryBridgeHandler;
import de.gematik.test.tiger.mockserver.httpclient.Http2SettingsHandler;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientConnectionErrorHandler;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientHandler;
import de.gematik.test.tiger.mockserver.httpclient.HttpOrHttp2Initializer;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClientInitializer.class);
    public static final String CONNECTION_ERROR_HANDLER_NAME = "connection-error-handler";
    private final HttpProtocol httpProtocol;
    private final HttpClientConnectionErrorHandler httpClientConnectionHandler;
    private final CompletableFuture<HttpProtocol> protocolFuture;
    private final HttpClientHandler httpClientHandler;
    private final ProxyConfiguration proxyConfiguration;
    private final NettySslContextFactory nettySslContextFactory;
    private final BinaryBridgeHandler binaryBridgeHandler;

    HttpClientInitializer(MockServerConfiguration configuration, NettySslContextFactory nettySslContextFactory, HttpProtocol httpProtocol) {
        this.proxyConfiguration = configuration.proxyConfiguration();
        this.httpProtocol = httpProtocol;
        this.protocolFuture = new CompletableFuture();
        this.httpClientHandler = new HttpClientHandler();
        this.httpClientConnectionHandler = new HttpClientConnectionErrorHandler();
        this.binaryBridgeHandler = new BinaryBridgeHandler(configuration);
        this.nettySslContextFactory = nettySslContextFactory;
    }

    public void whenComplete(BiConsumer<? super HttpProtocol, ? super Throwable> action) {
        this.protocolFuture.whenComplete(action);
    }

    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        boolean secure = channel.attr(NettyHttpClient.SECURE) != null && channel.attr(NettyHttpClient.SECURE).get() != null && (Boolean)channel.attr(NettyHttpClient.SECURE).get() != false;
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.attr(NettyHttpClient.REMOTE_SOCKET).get();
        pipeline.addFirst(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
        if (this.isHostNotOnNoProxyHostList(remoteAddress)) {
            this.addProxyHandlerIfApplicable(pipeline, secure);
        }
        pipeline.addLast(CONNECTION_ERROR_HANDLER_NAME, (ChannelHandler)this.httpClientConnectionHandler);
        if (secure) {
            log.atTrace().log(() -> "Adding SSL Handler in HttpClientInitializer.initChannel for channel %s. Current pipeline: %s".formatted(channel.toString(), pipeline.toMap()));
            pipeline.addLast(new ChannelHandler[]{this.nettySslContextFactory.createClientSslContext(Optional.ofNullable(this.httpProtocol)).newHandler(channel.alloc(), remoteAddress.getHostName(), remoteAddress.getPort())});
        }
        if (this.httpProtocol == null) {
            this.configureBinaryPipeline(pipeline);
        } else if (secure) {
            pipeline.addLast(new ChannelHandler[]{new HttpOrHttp2Initializer(arg_0 -> this.configureHttp1Pipeline(arg_0), arg_0 -> this.configureHttp2Pipeline(arg_0))});
        } else {
            this.configureHttp1Pipeline(pipeline);
        }
    }

    private void addProxyHandlerIfApplicable(ChannelPipeline pipeline, boolean secure) {
        if (this.proxyConfiguration != null) {
            if (this.proxyConfiguration.getType() == ProxyConfiguration.Type.HTTP && secure) {
                if (StringUtils.isNotBlank((CharSequence)this.proxyConfiguration.getUsername()) && StringUtils.isNotBlank((CharSequence)this.proxyConfiguration.getPassword())) {
                    log.atTrace().addArgument((Object)this.proxyConfiguration.getProxyAddress()).addArgument((Object)this.proxyConfiguration.getUsername()).addArgument((Object)this.proxyConfiguration.getPassword()).log("Adding HTTP Proxy Handler with authentication {} with {}:{}");
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress(), this.proxyConfiguration.getUsername(), this.proxyConfiguration.getPassword())});
                } else {
                    log.atTrace().addArgument((Object)this.proxyConfiguration.getProxyAddress()).log("Adding HTTP Proxy Handler without authentication {}");
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress())});
                }
            } else if (this.proxyConfiguration.getType() == ProxyConfiguration.Type.SOCKS5) {
                if (StringUtils.isNotBlank((CharSequence)this.proxyConfiguration.getUsername()) && StringUtils.isNotBlank((CharSequence)this.proxyConfiguration.getPassword())) {
                    log.atTrace().addArgument((Object)this.proxyConfiguration.getProxyAddress()).addArgument((Object)this.proxyConfiguration.getUsername()).addArgument((Object)this.proxyConfiguration.getPassword()).log("Adding SOCKS5 Proxy Handler with authentication {} with {}:{}");
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress(), this.proxyConfiguration.getUsername(), this.proxyConfiguration.getPassword())});
                } else {
                    log.atTrace().addArgument((Object)this.proxyConfiguration.getProxyAddress()).log("Adding SOCKS Proxy Handler without authentication {}");
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress())});
                }
            }
        }
    }

    private void configureHttp1Pipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpClientCodec(this.proxyConfiguration)});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
        this.protocolFuture.complete(HttpProtocol.HTTP_1_1);
    }

    private void configureHttp2Pipeline(ChannelPipeline pipeline) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        HttpToHttp2ConnectionHandlerBuilder http2ConnectionHandlerBuilder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(Integer.MAX_VALUE).propagateSettings(true).validateHttpHeaders(false).build())).connection((Http2Connection)connection).flushPreface(true);
        if (log.isTraceEnabled()) {
            http2ConnectionHandlerBuilder.frameLogger(new Http2FrameLogger(LogLevel.TRACE, HttpClientHandler.class.getName()));
        }
        pipeline.addLast(new ChannelHandler[]{http2ConnectionHandlerBuilder.build()});
        pipeline.addLast(new ChannelHandler[]{new Http2SettingsHandler(this.protocolFuture)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpClientCodec(this.proxyConfiguration)});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
    }

    private void configureBinaryPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new MockServerBinaryClientCodec()});
        pipeline.addLast(new ChannelHandler[]{this.binaryBridgeHandler});
        this.protocolFuture.complete(null);
    }

    private boolean isHostNotOnNoProxyHostList(InetSocketAddress remoteAddress) {
        if (remoteAddress == null || this.proxyConfiguration == null) {
            return true;
        }
        return this.proxyConfiguration.getNoProxyHosts().stream().map(String::trim).map(host -> {
            try {
                return InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }).filter(Objects::nonNull).noneMatch(a -> remoteAddress.getHostName().equals(a.getHostName()));
    }
}

