/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.httpclient.ClientBootstrapFactory;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientInitializer;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.httpclient.RequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.ReusableChannel;
import de.gematik.test.tiger.mockserver.model.Message;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientBootstrapFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientBootstrapFactory.class);
    public static final AttributeKey<Integer> LOOP_COUNTER = AttributeKey.valueOf((String)"loopCounter");
    private final MockServerConfiguration configuration;
    private final EventLoopGroup eventLoop;
    private final ReusableChannelMap channelMap = new ReusableChannelMap();

    private ChannelFuture createOrReuseChannel(boolean isSecure, @Nullable RequestInfo<?> requestInfo, @Nullable Channel incomingChannel, @Nullable InetSocketAddress remoteAddress, HttpClientInitializer clientInitializer, boolean errorIfChannelClosedWithoutResponse, @Nullable CompletableFuture<Message> responseFuture, @Nullable ChannelFutureListener onCreationListener, @Nullable ChannelFutureListener onReuseListener, @Nullable Long timeoutInMilliseconds, @Nullable EventLoopGroup eventLoopGroup) {
        ChannelFuture existingChannel = null;
        if (requestInfo != null) {
            existingChannel = this.channelMap.getChannelToReuse(requestInfo);
            remoteAddress = requestInfo.getRemoteServerAddress();
            incomingChannel = requestInfo.getIncomingChannel();
        }
        if (existingChannel != null) {
            log.trace("reusing already existing channel");
            existingChannel.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    Optional.ofNullable((CompletableFuture)future.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).ifPresent(oldFuture -> oldFuture.complete(null));
                    future.channel().attr(NettyHttpClient.RESPONSE_FUTURE).set((Object)responseFuture);
                }
            }));
            if (onReuseListener != null) {
                existingChannel.addListener((GenericFutureListener)onReuseListener);
            }
            return existingChannel;
        }
        log.trace("creating a new channel");
        if (timeoutInMilliseconds == null) {
            timeoutInMilliseconds = this.configuration.socketConnectionTimeoutInMillis();
        }
        if (eventLoopGroup == null) {
            eventLoopGroup = this.eventLoop;
        }
        Integer timeout = timeoutInMilliseconds != null ? Integer.valueOf(timeoutInMilliseconds.intValue()) : null;
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeout)).attr(NettyHttpClient.SECURE, (Object)isSecure)).attr(NettyHttpClient.REMOTE_SOCKET, (Object)remoteAddress)).attr(NettyHttpClient.ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE, (Object)errorIfChannelClosedWithoutResponse)).attr(LOOP_COUNTER, (Object)(incomingChannel.hasAttr(LOOP_COUNTER) ? (Integer)incomingChannel.attr(LOOP_COUNTER).get() + 1 : 0))).handler((ChannelHandler)clientInitializer);
        if (responseFuture != null) {
            bootstrap.attr(NettyHttpClient.RESPONSE_FUTURE, responseFuture);
        }
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)remoteAddress);
        this.channelMap.addChannel(ReusableChannelMap.ChannelId.from((Channel)incomingChannel, (InetSocketAddress)remoteAddress), channelFuture);
        if (onCreationListener != null) {
            channelFuture.addListener((GenericFutureListener)onCreationListener);
        }
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> future.channel().closeFuture().addListener(f -> this.channelMap.remove(future))));
        return channelFuture;
    }

    public int getLoopCounterForOpenConnectionFromPort(int port) {
        return this.channelMap.getEntries().stream().filter(e -> this.isLocalPortOfChannelEqualToIncomingPortInQuestion(port, e)).mapToInt(entry -> (Integer)((ReusableChannel)entry.getValue()).getFutureOutgoingChannel().channel().attr(LOOP_COUNTER).get()).max().orElse(0);
    }

    private boolean isLocalPortOfChannelEqualToIncomingPortInQuestion(int port, Map.Entry<ReusableChannelMap.ChannelId, ReusableChannel> entry) {
        SocketAddress loc = entry.getValue().getFutureOutgoingChannel().channel().localAddress();
        if (loc instanceof InetSocketAddress) {
            InetSocketAddress localAddress = (InetSocketAddress)loc;
            return localAddress.getPort() == port;
        }
        return false;
    }

    @Generated
    public ChannelFutureBuilder configureChannel() {
        return new ChannelFutureBuilder(this);
    }

    @ConstructorProperties(value={"configuration", "eventLoop"})
    @Generated
    public ClientBootstrapFactory(MockServerConfiguration configuration, EventLoopGroup eventLoop) {
        this.configuration = configuration;
        this.eventLoop = eventLoop;
    }

    @Generated
    public ReusableChannelMap getChannelMap() {
        return this.channelMap;
    }
}

