/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.rbellogger.data.RbelMessageKind;
import de.gematik.rbellogger.util.RbelSocketAddress;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.logging.ChannelContextLogger;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.netty.proxy.BinaryModifierApplier;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryBridgeHandler
extends SimpleChannelInboundHandler<BinaryMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryBridgeHandler.class);
    public static final AttributeKey<Channel> OUTGOING_CHANNEL = AttributeKey.valueOf((String)"OUTGOING_CHANNEL");
    public static final AttributeKey<Channel> INCOMING_CHANNEL = AttributeKey.valueOf((String)"INCOMING_CHANNEL");
    private final BinaryExchangeHandler binaryProxyListener;
    private final BinaryModifierApplier binaryModifierApplier;
    private final ChannelContextLogger contextLogger = new ChannelContextLogger(log);

    public BinaryBridgeHandler(MockServerConfiguration configuration) {
        this.binaryProxyListener = configuration.binaryProxyListener();
        this.binaryModifierApplier = new BinaryModifierApplier(configuration);
    }

    protected void channelRead0(ChannelHandlerContext ctx, BinaryMessage msg) {
        for (BinaryMessage msgToSend : this.binaryModifierApplier.applyModifierPlugins(msg, ctx, RbelMessageKind.RESPONSE)) {
            Optional.ofNullable((Channel)ctx.channel().attr(INCOMING_CHANNEL).get()).orElseThrow(() -> new IllegalStateException("Incoming channel is not set.")).writeAndFlush((Object)Unpooled.copiedBuffer((byte[])msgToSend.getBytes()));
            this.binaryProxyListener.onProxy(msgToSend, ((Channel)ctx.channel().attr(INCOMING_CHANNEL).get()).remoteAddress(), ctx.channel().remoteAddress(), RbelMessageKind.RESPONSE);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.contextLogger.logStage(ctx, "Outgoing channel of binary proxy is being closed");
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.binaryProxyListener.propagateExceptionMessageSafe(cause, RbelSocketAddress.create((SocketAddress)ctx.channel().remoteAddress()), RbelSocketAddress.create((SocketAddress)((Channel)ctx.channel().attr(INCOMING_CHANNEL).get()).remoteAddress()));
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

