/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.filters;

import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.KeyToMultiValue;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class HopByHopHeaderFilter {
    private static final List<String> requestHeadersToRemove = Arrays.asList("proxy-connection", "keep-alive", "transfer-encoding", "te", "connection", "trailer", "proxy-authorization", "proxy-authenticate", "upgrade");

    public HttpRequest onRequest(HttpRequest request) {
        if (request != null) {
            Headers headers = new Headers(new Header[0]);
            for (Header header : request.getHeaderList()) {
                if (requestHeadersToRemove.contains(header.getName().toLowerCase(Locale.ENGLISH))) continue;
                headers.withEntry((KeyToMultiValue)header);
            }
            if (!headers.isEmpty()) {
                request.withHeaders(headers);
            }
            return request;
        }
        return null;
    }
}

