/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.codec;

import com.google.common.collect.ImmutableList;
import de.gematik.test.tiger.mockserver.model.Header;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.Collection;
import java.util.List;

public class PreserveHeadersNettyRemoves
extends MessageToMessageDecoder<HttpObject> {
    private static final AttributeKey<List<Header>> PRESERVED_HEADERS = AttributeKey.valueOf((String)"PRESERVED_HEADERS");

    protected void decode(ChannelHandlerContext ctx, HttpObject httpObject, List<Object> out) throws Exception {
        HttpHeaders headers;
        if (httpObject instanceof HttpMessage && (headers = ((HttpMessage)httpObject).headers()).contains((CharSequence)HttpHeaderNames.CONTENT_ENCODING)) {
            ctx.channel().attr(PRESERVED_HEADERS).set((Object)ImmutableList.of((Object)new Header(HttpHeaderNames.CONTENT_ENCODING.toString(), (Collection)headers.getAll((CharSequence)HttpHeaderNames.CONTENT_ENCODING))));
        }
        ReferenceCountUtil.retain((Object)httpObject);
        out.add(httpObject);
    }

    public static List<Header> preservedHeaders(Channel channel) {
        if (channel.attr(PRESERVED_HEADERS) != null && channel.attr(PRESERVED_HEADERS).get() != null) {
            return (List)channel.attr(PRESERVED_HEADERS).get();
        }
        return ImmutableList.of();
    }
}

