/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tracing;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.PreviousMessageFacet;
import de.gematik.rbellogger.data.facet.ProxyTransmissionHistory;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.TigerNonPairedMessageFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.data.facet.UnparsedChunkFacet;
import de.gematik.rbellogger.file.MessageTimeWriter;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.rbellogger.file.TcpIpMessageFacetWriter;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class TracingPushService {
    public static final int MAX_MESSAGE_SIZE = 524288;
    private final SimpMessagingTemplate template;
    private final TigerProxy tigerProxy;
    private Logger log = LoggerFactory.getLogger(TracingPushService.class);

    public void addWebSocketListener() {
        this.tigerProxy.addRbelMessageListener(this::propagateRbelMessageSafe);
        this.tigerProxy.addNewExceptionConsumer(this::propagateExceptionSafe);
        this.tigerProxy.getRbelLogger().getRbelConverter().addLastPostConversionListener(RbelConverterPlugin.createPlugin(this::markUnsuccessfulMessageAsProcessed));
        this.log = LoggerFactory.getLogger((String)(TracingPushService.class.getName() + "(" + this.tigerProxy.proxyName() + ")"));
    }

    private void markUnsuccessfulMessageAsProcessed(RbelElement result, RbelConverter rbelConverter) {
        if (result.getFacets().stream().noneMatch(f -> f instanceof RbelRootFacet || f instanceof RbelResponseFacet || f instanceof RbelRequestFacet)) {
            RbelConverter.setMessageFullyProcessed((RbelElement)result);
        }
    }

    private void propagateExceptionSafe(Throwable exc) {
        try {
            this.propagateException(exc);
        }
        catch (RuntimeException e) {
            this.log.error("Error while propagating Exception", (Throwable)e);
            throw e;
        }
    }

    private void propagateRbelMessageSafe(RbelElement msg) {
        try {
            if (!msg.hasFacet(RbelTcpIpMessageFacet.class)) {
                this.log.info("Skipping propagation, not a TCP/IP message {}", (Object)msg.getUuid());
                return;
            }
            this.waitForPreviousMessageFullyProcessed(msg);
            this.propagateRbelMessage(msg);
        }
        catch (RuntimeException e) {
            this.log.error("Error while propagating new Rbel-Message", (Throwable)e);
            throw e;
        }
    }

    private synchronized void propagateRbelMessage(RbelElement msg) {
        this.log.atTrace().addArgument(() -> TracingPushService.getSequenceNumber(msg)).addArgument(() -> ((RbelElement)msg).printHttpDescription()).log("Transmitting message #{}: {}");
        if (msg.hasFacet(TigerNonPairedMessageFacet.class)) {
            this.sendNonPairedMessage(msg);
        } else if (msg.hasFacet(RbelHttpResponseFacet.class) || msg.getFacet(TracingMessagePairFacet.class).map(facet -> facet.isResponse(msg)).orElse(false).booleanValue()) {
            this.sendPairedMessage(msg);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("Skipping propagation, not a response (facets: {}, uuid: {})", (Object)msg.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")), (Object)msg.getUuid());
        }
    }

    private void sendNonPairedMessage(RbelElement msg) {
        try {
            RbelTcpIpMessageFacet rbelTcpIpMessageFacet = (RbelTcpIpMessageFacet)msg.getFacetOrFail(RbelTcpIpMessageFacet.class);
            RbelHostname sender = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getSender().getRawStringContent()).orElse(null);
            RbelHostname receiver = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getReceiver().getRawStringContent()).orElse(null);
            this.log.trace("Propagating new non-paired message (ID: {})", (Object)msg.getUuid());
            this.template.convertAndSend((Object)"/topic/traces", (Object)TigerTracingDto.builder().receiver(receiver).sender(sender).requestUuid(msg.getUuid()).requestTransmissionTime(msg.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).additionalInformationRequest(this.gatherAdditionalInformation(msg)).unparsedChunk(msg.hasFacet(UnparsedChunkFacet.class)).sequenceNumberRequest(rbelTcpIpMessageFacet.getSequenceNumber()).proxyTransmissionHistoryRequest(new ProxyTransmissionHistory(this.tigerProxy.getTigerProxyConfiguration().getName(), List.of(rbelTcpIpMessageFacet.getSequenceNumber()), (ProxyTransmissionHistory)msg.getFacet(ProxyTransmissionHistory.class).orElse(null))).build());
            this.mapRbelMessageAndSent(msg);
        }
        catch (RuntimeException e) {
            this.log.error("Error while sending non-paired message: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private void sendPairedMessage(RbelElement response) {
        RbelElement request = response.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getRequest).or(() -> response.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::getRequest)).orElseThrow(() -> new TigerRemoteProxyClientException("Failure to correctly push message with id '" + response.getUuid() + "': Unable to find matching request"));
        RbelTcpIpMessageFacet requestTcpIpFacet = (RbelTcpIpMessageFacet)request.getFacetOrFail(RbelTcpIpMessageFacet.class);
        RbelTcpIpMessageFacet responseTcpIpFacet = (RbelTcpIpMessageFacet)response.getFacetOrFail(RbelTcpIpMessageFacet.class);
        RbelHostname sender = RbelHostname.fromString((String)requestTcpIpFacet.getSender().getRawStringContent()).orElse(null);
        RbelHostname receiver = RbelHostname.fromString((String)requestTcpIpFacet.getReceiver().getRawStringContent()).orElse(null);
        this.log.trace("Propagating new request/response pair (IDs: {} and {})", (Object)request.getUuid(), (Object)response.getUuid());
        this.template.convertAndSend((Object)"/topic/traces", (Object)TigerTracingDto.builder().receiver(receiver).sender(sender).responseUuid(response.getUuid()).requestUuid(request.getUuid()).responseTransmissionTime(response.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).requestTransmissionTime(request.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).additionalInformationRequest(this.gatherAdditionalInformation(request)).additionalInformationResponse(this.gatherAdditionalInformation(response)).sequenceNumberRequest(requestTcpIpFacet.getSequenceNumber()).sequenceNumberResponse(responseTcpIpFacet.getSequenceNumber()).proxyTransmissionHistoryRequest(new ProxyTransmissionHistory(this.tigerProxy.getTigerProxyConfiguration().getName(), List.of(requestTcpIpFacet.getSequenceNumber()), (ProxyTransmissionHistory)request.getFacet(ProxyTransmissionHistory.class).orElse(null))).proxyTransmissionHistoryResponse(new ProxyTransmissionHistory(this.tigerProxy.getTigerProxyConfiguration().getName(), List.of(responseTcpIpFacet.getSequenceNumber()), (ProxyTransmissionHistory)response.getFacet(ProxyTransmissionHistory.class).orElse(null))).build());
        this.mapRbelMessageAndSent(request);
        this.mapRbelMessageAndSent(response);
    }

    private Map<String, String> gatherAdditionalInformation(RbelElement msg) {
        JSONObject infoObject = new JSONObject();
        RbelFileWriter.DEFAULT_PRE_SAVE_LISTENER.stream().filter(listener -> !(listener instanceof TcpIpMessageFacetWriter) && !(listener instanceof MessageTimeWriter)).forEach(listener -> listener.preSaveCallback(msg, infoObject));
        return infoObject.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
    }

    private void propagateException(Throwable exception) {
        this.template.convertAndSend((Object)"/topic/errors", (Object)TigerExceptionDto.builder().className(exception.getClass().getName()).message(exception.getMessage()).stacktrace(ExceptionUtils.getStackTrace((Throwable)exception)).build());
    }

    private void mapRbelMessageAndSent(RbelElement rbelMessage) {
        if (rbelMessage == null) {
            return;
        }
        RbelContent content = rbelMessage.getContent();
        if (content.isNull()) {
            return;
        }
        int size = content.getSize();
        int chunkSize = content.getChunkSize();
        int numberOfParts = (size + chunkSize - 1) / chunkSize;
        int i = 0;
        int nextPartIndex = 0;
        while (nextPartIndex < size) {
            byte[] partContent = content.subArray(nextPartIndex, Math.min(nextPartIndex + chunkSize, size));
            this.log.trace("sending part {} of {} for UUID {}...", new Object[]{i + 1, numberOfParts, rbelMessage.getUuid()});
            this.template.convertAndSend((Object)"/topic/data", (Object)TracingMessagePart.builder().data(partContent).index(i).uuid(rbelMessage.getUuid()).numberOfMessages(numberOfParts).build());
            nextPartIndex += partContent.length;
            ++i;
        }
    }

    private static Long getSequenceNumber(RbelElement msg) {
        return msg.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).orElse(-1L);
    }

    private void waitForMessageFullyProcessed(RbelElement msg) {
        this.log.atTrace().addArgument(() -> TracingPushService.getSequenceNumber(msg)).log("Waiting for message #{}");
        RbelConverter.waitUntilFullyProcessed((RbelElement)msg);
    }

    private void waitForPreviousMessageFullyProcessed(RbelElement msg) {
        this.log.atTrace().addArgument(() -> TracingPushService.getSequenceNumber(msg)).log("Waiting for previous message of #{}");
        msg.getFacet(PreviousMessageFacet.class).map(PreviousMessageFacet::getMessage).ifPresent(this::waitForMessageFullyProcessed);
        msg.removeFacetsOfType(PreviousMessageFacet.class);
    }

    @ConstructorProperties(value={"template", "tigerProxy"})
    @Generated
    public TracingPushService(SimpMessagingTemplate template, TigerProxy tigerProxy) {
        this.template = template;
        this.tigerProxy = tigerProxy;
    }
}

