/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls.vau;

import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelVauEpaFacet;
import de.gematik.test.tiger.proxy.tls.vau.VauSessionFacet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"epa-vau"}, addAsPostConversionListener=true)
public class RbelVauSessionListener
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauSessionListener.class);
    private static final String RECORD_ID_KVNR_RBEL_PATH = "$.Data.content.decoded.AuthorizationAssertion.content.decoded.Assertion.AttributeStatement.Attribute.AttributeValue.RecordIdentifier.InsurantId.extension";
    private final Map<String, VauSessionFacet> clientHelloHashToSessionMap = new HashMap<String, VauSessionFacet>();
    private final Map<String, VauSessionFacet> keyIdToSessionMap = new HashMap<String, VauSessionFacet>();

    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        if (rbelElement.hasFacet(VauSessionFacet.class)) {
            return;
        }
        this.safeExecute(() -> this.tagVauClientHello(rbelElement));
        this.safeExecute(() -> this.tagVauServerHello(rbelElement));
        this.safeExecute(() -> this.tagVauClientSigFin(rbelElement));
        this.safeExecute(() -> this.tagVauServerFin(rbelElement));
        this.safeExecute(() -> this.tagDocvMessageByKeyId(rbelElement));
    }

    private void tagVauClientHello(RbelElement rbelElement) {
        if (rbelElement.getFacet(RbelRootFacet.class).map(RbelRootFacet::getRootFacet).filter(RbelJsonFacet.class::isInstance).isPresent()) {
            Optional rbelJsonFacet = rbelElement.getFacet(RbelJsonFacet.class);
            if (rbelJsonFacet.isEmpty()) {
                return;
            }
            if (!((RbelJsonFacet)rbelJsonFacet.get()).getJsonElement().get("MessageType").textValue().equals("VAUClientHello")) {
                return;
            }
            rbelElement.findElement(RECORD_ID_KVNR_RBEL_PATH).map(RbelElement::getRawStringContent).ifPresent(insurantId -> rbelElement.addFacet((RbelFacet)VauSessionFacet.builder().recordId(RbelElement.wrap((RbelElement)rbelElement, (Object)insurantId)).build()));
        }
    }

    private void tagVauServerHello(RbelElement rbelElement) {
        if (rbelElement.getParentNode().hasFacet(RbelHttpResponseFacet.class) && rbelElement.getKey().map("body"::equals).orElse(false).booleanValue()) {
            rbelElement.getParentNode().getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::getRequest).flatMap(req -> req.getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getBody).flatMap(body -> body.getFacet(VauSessionFacet.class))).ifPresent(vauSessionFacet -> {
                rbelElement.addFacet((RbelFacet)vauSessionFacet.toBuilder().build());
                rbelElement.findElement("$.Data.content.decoded.VAUClientHelloDataHash").map(RbelElement::getRawStringContent).ifPresent(hash -> this.clientHelloHashToSessionMap.put((String)hash, (VauSessionFacet)vauSessionFacet));
            });
        }
    }

    private void tagVauClientSigFin(RbelElement rbelElement) {
        if (rbelElement.getFacet(RbelRootFacet.class).map(RbelRootFacet::getRootFacet).filter(RbelJsonFacet.class::isInstance).isPresent()) {
            rbelElement.findElement("$.VAUClientHelloDataHash").map(RbelElement::getRawStringContent).map(this.clientHelloHashToSessionMap::get).ifPresent(vauSessionFacet -> {
                rbelElement.addFacet((RbelFacet)vauSessionFacet.toBuilder().build());
                rbelElement.findElement("$.FinishedData.content.keyId").map(RbelElement::getRawStringContent).ifPresent(hash -> this.keyIdToSessionMap.put((String)hash, (VauSessionFacet)vauSessionFacet));
            });
        }
    }

    private void tagVauServerFin(RbelElement rbelElement) {
        if (rbelElement.getParentNode().hasFacet(RbelHttpResponseFacet.class) && rbelElement.getKey().map("body"::equals).orElse(false).booleanValue()) {
            rbelElement.getParentNode().getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::getRequest).flatMap(req -> req.getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getBody).flatMap(body -> body.getFacet(VauSessionFacet.class))).ifPresent(vauSessionFacet -> rbelElement.addFacet((RbelFacet)vauSessionFacet.toBuilder().build()));
        }
    }

    private void tagDocvMessageByKeyId(RbelElement rbelElement) {
        if (rbelElement.getFacet(RbelRootFacet.class).map(RbelRootFacet::getRootFacet).filter(RbelVauEpaFacet.class::isInstance).isPresent()) {
            rbelElement.findElement("$.keyId").map(RbelElement::getRawStringContent).map(this.keyIdToSessionMap::get).filter(Objects::nonNull).ifPresent(vauSessionFacet -> rbelElement.addFacet((RbelFacet)vauSessionFacet.toBuilder().build()));
        }
    }

    private void safeExecute(Runnable function) {
        try {
            function.run();
        }
        catch (RuntimeException e) {
            log.atTrace().addArgument(RbelVauSessionListener.class::getSimpleName).addArgument((Object)e).log("Swallowed exception during safe execution in {}: {}");
        }
    }
}

