/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls;

import de.gematik.test.tiger.TigerAgent;
import de.gematik.test.tiger.TigerMasterSecretListeners;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerTlsConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.TigerProxyMasterSecretListener;
import de.gematik.test.tiger.proxy.exceptions.TigerProxySslException;
import de.gematik.test.tiger.proxy.tls.CombinedKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.DynamicKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.OcspUtils;
import de.gematik.test.tiger.proxy.tls.StaticKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.TlsCertificateGenerator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.beans.ConstructorProperties;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerTlsConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServerTlsConfigurator.class);
    private static final String NAMED_GROUPS = "jdk.tls.namedGroups";
    private final MockServerConfiguration mockServerConfiguration;
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private Optional<TigerTlsConfiguration> tlsConfiguration;
    private TigerPkiIdentity serverRootCa;
    private final Optional<String> tigerProxyName;
    private final List<KeyAndCertificateFactory> tlsFactories = new ArrayList<KeyAndCertificateFactory>();
    private boolean usingGenericCa;

    public void execute() {
        this.tlsConfiguration = Optional.ofNullable(this.tigerProxyConfiguration.getTls());
        this.serverRootCa = this.determineServerRootCa();
        this.mockServerConfiguration.serverKeyAndCertificateFactory(this.buildServerKeyAndCertificateFactory());
        this.mockServerConfiguration.clientKeyAndCertificateFactory(this.buildClientKeyAndCertificateFactory());
        this.customizeSslIfApplicable();
    }

    private void customizeSslIfApplicable() {
        this.customizeServerBuilderCustomizer();
        this.customizeClientBuilderCustomizer();
        this.customizeClientBuilderFunction();
        this.tlsConfiguration.map(TigerTlsConfiguration::getMasterSecretsFile).ifPresent(filename -> TigerAgent.addListener((TigerMasterSecretListeners)new TigerProxyMasterSecretListener((String)filename)));
    }

    private void customizeClientBuilderFunction() {
        if (this.tlsConfiguration.map(TigerTlsConfiguration::getClientSupportedGroups).filter(CollectionUtils::isNotEmpty).isPresent()) {
            this.mockServerConfiguration.clientSslContextBuilderFunction(sslContextBuilder -> {
                String previousGroups = System.getProperty(NAMED_GROUPS);
                try {
                    System.setProperty(NAMED_GROUPS, String.join((CharSequence)",", this.tlsConfiguration.get().getClientSupportedGroups()));
                    sslContextBuilder.sslProvider(SslProvider.JDK);
                    SslContext sslContext = sslContextBuilder.build();
                    return sslContext;
                }
                catch (SSLException e) {
                    throw new TigerProxySslException("Error while building SSL context in Tiger-Proxy " + this.tigerProxyName.orElse(""), e);
                }
                finally {
                    if (previousGroups != null) {
                        System.setProperty(NAMED_GROUPS, previousGroups);
                    } else {
                        System.clearProperty(NAMED_GROUPS);
                    }
                }
            });
        }
    }

    private KeyAndCertificateFactory buildServerKeyAndCertificateFactory() {
        boolean allowGenericFallbackIdentity = this.tlsConfiguration.map(TigerTlsConfiguration::isAllowGenericFallbackIdentity).orElse(false);
        Optional<KeyAndCertificateFactory> staticFactory = this.generateStaticFactory();
        if (staticFactory.isPresent()) {
            if (!this.usingGenericCa || allowGenericFallbackIdentity) {
                DynamicKeyAndCertificateFactory dynamicFactory = this.generateDynamicFactory();
                CombinedKeyAndCertificateFactory combinedFactory = new CombinedKeyAndCertificateFactory(staticFactory.get(), dynamicFactory);
                this.tlsFactories.add(combinedFactory);
                return combinedFactory;
            }
            this.tlsFactories.add(staticFactory.get());
            return staticFactory.get();
        }
        DynamicKeyAndCertificateFactory dynamicFactory = this.generateDynamicFactory();
        this.tlsFactories.add(dynamicFactory);
        return dynamicFactory;
    }

    private Optional<KeyAndCertificateFactory> generateStaticFactory() {
        if (this.tlsConfiguration.map(TigerTlsConfiguration::getServerIdentity).isPresent()) {
            return Optional.of(new StaticKeyAndCertificateFactory(List.of(this.tlsConfiguration.get().getServerIdentity())));
        }
        if (this.tlsConfiguration.map(TigerTlsConfiguration::getServerIdentities).isPresent()) {
            return Optional.of(new StaticKeyAndCertificateFactory(this.tlsConfiguration.get().getServerIdentities().stream().map(TigerPkiIdentity.class::cast).toList()));
        }
        return Optional.empty();
    }

    private DynamicKeyAndCertificateFactory generateDynamicFactory() {
        return new DynamicKeyAndCertificateFactory(this.tigerProxyConfiguration, this.serverRootCa, this.mockServerConfiguration);
    }

    private KeyAndCertificateFactory buildClientKeyAndCertificateFactory() {
        if (this.tlsConfiguration.map(TigerTlsConfiguration::getForwardMutualTlsIdentity).isPresent()) {
            return new StaticKeyAndCertificateFactory(Collections.singletonList(this.tlsConfiguration.get().getForwardMutualTlsIdentity()));
        }
        return new DynamicKeyAndCertificateFactory(this.tigerProxyConfiguration, new TigerPkiIdentity("CertificateAuthorityCertificate.pem;CertificateAuthorityPrivateKey.pem;PKCS1"), this.mockServerConfiguration);
    }

    private void customizeServerBuilderCustomizer() {
        this.mockServerConfiguration.sslServerContextBuilderCustomizer(builder -> {
            this.tlsConfiguration.map(TigerTlsConfiguration::getServerSslSuites).ifPresent(arg_0 -> ((SslContextBuilder)builder).ciphers(arg_0));
            this.tlsConfiguration.map(TigerTlsConfiguration::getServerTlsProtocols).ifPresent(arg_0 -> ((SslContextBuilder)builder).protocols(arg_0));
            this.tlsConfiguration.map(TigerTlsConfiguration::getOcspSignerIdentity).ifPresentOrElse(ocspSignerIdentity -> {
                builder.enableOcsp(true);
                this.mockServerConfiguration.ocspResponseSupplier(certificate -> OcspUtils.buildOcspResponse(certificate, ocspSignerIdentity));
                builder.sslProvider(SslProvider.OPENSSL);
            }, () -> {
                builder.sslProvider(SslProvider.JDK);
                BouncyCastleJsseProvider sslContextProvider = new BouncyCastleJsseProvider();
                builder.sslContextProvider((Provider)sslContextProvider);
                builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, List.of("http/1.1")));
            });
            return builder;
        });
    }

    private static List<String> extractSelectedCipherSuites(SslContextBuilder builder) {
        return builder.build().cipherSuites();
    }

    private void customizeClientBuilderCustomizer() {
        this.mockServerConfiguration.sslClientContextBuilderCustomizer(builder -> {
            this.tlsConfiguration.map(TigerTlsConfiguration::getClientSslSuites).ifPresent(arg_0 -> ((SslContextBuilder)builder).ciphers(arg_0));
            builder.sslProvider(SslProvider.JDK);
            return builder;
        });
    }

    private TigerPkiIdentity determineServerRootCa() {
        if (this.tigerProxyConfiguration.getTls().getServerRootCa() != null) {
            this.usingGenericCa = false;
            return this.tigerProxyConfiguration.getTls().getServerRootCa();
        }
        if (this.serverRootCa != null) {
            this.usingGenericCa = true;
            return this.serverRootCa;
        }
        this.usingGenericCa = true;
        return TlsCertificateGenerator.generateNewCaCertificate();
    }

    @Generated
    public static MockServerTlsConfiguratorBuilder builder() {
        return new MockServerTlsConfiguratorBuilder();
    }

    @ConstructorProperties(value={"mockServerConfiguration", "tigerProxyConfiguration", "tlsConfiguration", "serverRootCa", "tigerProxyName", "usingGenericCa"})
    @Generated
    private MockServerTlsConfigurator(MockServerConfiguration mockServerConfiguration, TigerProxyConfiguration tigerProxyConfiguration, Optional<TigerTlsConfiguration> tlsConfiguration, TigerPkiIdentity serverRootCa, Optional<String> tigerProxyName, boolean usingGenericCa) {
        this.mockServerConfiguration = mockServerConfiguration;
        this.tigerProxyConfiguration = tigerProxyConfiguration;
        this.tlsConfiguration = tlsConfiguration;
        this.serverRootCa = serverRootCa;
        this.tigerProxyName = tigerProxyName;
        this.usingGenericCa = usingGenericCa;
    }

    @Generated
    public TigerPkiIdentity getServerRootCa() {
        return this.serverRootCa;
    }

    @Generated
    public static class MockServerTlsConfiguratorBuilder {
        @Generated
        private MockServerConfiguration mockServerConfiguration;
        @Generated
        private TigerProxyConfiguration tigerProxyConfiguration;
        @Generated
        private Optional<TigerTlsConfiguration> tlsConfiguration;
        @Generated
        private TigerPkiIdentity serverRootCa;
        @Generated
        private Optional<String> tigerProxyName;
        @Generated
        private boolean usingGenericCa;

        @Generated
        MockServerTlsConfiguratorBuilder() {
        }

        @Generated
        public MockServerTlsConfiguratorBuilder mockServerConfiguration(MockServerConfiguration mockServerConfiguration) {
            this.mockServerConfiguration = mockServerConfiguration;
            return this;
        }

        @Generated
        public MockServerTlsConfiguratorBuilder tigerProxyConfiguration(TigerProxyConfiguration tigerProxyConfiguration) {
            this.tigerProxyConfiguration = tigerProxyConfiguration;
            return this;
        }

        @Generated
        public MockServerTlsConfiguratorBuilder tlsConfiguration(Optional<TigerTlsConfiguration> tlsConfiguration) {
            this.tlsConfiguration = tlsConfiguration;
            return this;
        }

        @Generated
        public MockServerTlsConfiguratorBuilder serverRootCa(TigerPkiIdentity serverRootCa) {
            this.serverRootCa = serverRootCa;
            return this;
        }

        @Generated
        public MockServerTlsConfiguratorBuilder tigerProxyName(Optional<String> tigerProxyName) {
            this.tigerProxyName = tigerProxyName;
            return this;
        }

        @Generated
        public MockServerTlsConfiguratorBuilder usingGenericCa(boolean usingGenericCa) {
            this.usingGenericCa = usingGenericCa;
            return this;
        }

        @Generated
        public MockServerTlsConfigurator build() {
            return new MockServerTlsConfigurator(this.mockServerConfiguration, this.tigerProxyConfiguration, this.tlsConfiguration, this.serverRootCa, this.tigerProxyName, this.usingGenericCa);
        }

        @Generated
        public String toString() {
            return "MockServerTlsConfigurator.MockServerTlsConfiguratorBuilder(mockServerConfiguration=" + String.valueOf(this.mockServerConfiguration) + ", tigerProxyConfiguration=" + String.valueOf(this.tigerProxyConfiguration) + ", tlsConfiguration=" + String.valueOf(this.tlsConfiguration) + ", serverRootCa=" + String.valueOf(this.serverRootCa) + ", tigerProxyName=" + String.valueOf(this.tigerProxyName) + ", usingGenericCa=" + this.usingGenericCa + ")";
        }
    }
}

