/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.handler.AbstractRouteProxyCallback;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxyCallback
extends AbstractRouteProxyCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyCallback.class);

    public ReverseProxyCallback(TigerProxy tigerProxy, TigerProxyRoute route) {
        super(tigerProxy, route);
    }

    @Override
    public HttpRequest handleRequest(HttpRequest httpRequest) {
        this.applyModifications(httpRequest);
        HttpRequest request = this.cloneRequest(httpRequest).setReceiverAddress(this.getTargetUrl().getProtocol().equals("https"), this.getTargetUrl().getHost(), this.getPort()).setSecure(this.getTigerRoute().getTo().startsWith("https")).setPath(this.patchPath(httpRequest.getPath()));
        if (this.getTigerProxy().getTigerProxyConfiguration().isRewriteHostHeader()) {
            request.removeHeader("Host").withHeader("Host", this.getTargetUrl().getHost() + ":" + this.getPort());
        }
        if (this.getTigerRoute().getAuthentication() != null) {
            this.getTigerRoute().getAuthentication().toAuthorizationHeaderValue().ifPresent(auth -> request.replaceHeader(Header.header("Authorization", auth)));
        }
        return request;
    }

    @Override
    protected String rewriteConcreteLocation(String originalLocation) {
        try {
            URI newUri = new URI(this.getTargetUrl().getPath()).relativize(new URI(originalLocation));
            if (newUri.isAbsolute()) {
                return newUri.toString();
            }
            return "/" + String.valueOf(newUri);
        }
        catch (URISyntaxException e) {
            return originalLocation;
        }
    }

    @Override
    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        return this.getTigerRoute().getTo();
    }

    @Override
    protected String printTrafficTarget(HttpRequest req) {
        return this.getTigerRoute().getTo();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReverseProxyCallback)) {
            return false;
        }
        ReverseProxyCallback other = (ReverseProxyCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReverseProxyCallback;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

