/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelElementConvertionPair;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.TigerNonPairedMessageFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.test.tiger.common.data.config.tigerproxy.DirectReverseProxyInfo;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRoutingException;
import de.gematik.test.tiger.proxy.exceptions.TigerRoutingErrorFacet;
import de.gematik.test.tiger.proxy.handler.BinaryChunksBuffer;
import de.gematik.test.tiger.proxy.handler.TigerExceptionUtils;
import java.net.SocketAddress;
import java.net.SocketException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryExchangeHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryExchangeHandler.class);
    private final TigerProxy tigerProxy;
    private final BinaryChunksBuffer binaryChunksBuffer;

    public BinaryExchangeHandler(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
        this.binaryChunksBuffer = new BinaryChunksBuffer(tigerProxy.getRbelLogger().getRbelConverter(), tigerProxy.getTigerProxyConfiguration());
    }

    public void onProxy(BinaryMessage binaryRequest, Optional<CompletableFuture<BinaryMessage>> binaryResponseFuture, SocketAddress serverAddress, SocketAddress clientAddress) {
        try {
            log.trace("Finalizing binary exchange...");
            Optional<RbelElement> convertedRequest = this.convertBinaryMessageOrPushToBuffer(binaryRequest, clientAddress, serverAddress);
            boolean shouldWaitForResponse = this.shouldWaitForResponse(convertedRequest);
            log.trace("Converted request, waiting on response: {}", (Object)shouldWaitForResponse);
            if (!shouldWaitForResponse) {
                convertedRequest.ifPresent(msg -> {
                    msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
                    this.getTigerProxy().triggerListener((RbelElement)msg);
                });
            }
            binaryResponseFuture.ifPresent(f -> ((CompletableFuture)((CompletableFuture)f.thenApply(binaryResponse -> this.convertBinaryMessageOrPushToBuffer((BinaryMessage)binaryResponse, serverAddress, clientAddress))).thenAccept(convertedResponse -> this.pairWithRequestAndPropagate((Optional<RbelElement>)convertedResponse, convertedRequest, shouldWaitForResponse))).exceptionally(t -> {
                this.handleConversionException((Throwable)t, clientAddress, serverAddress);
                return null;
            }));
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of request", (Throwable)e);
            this.propagateExceptionMessageSafe(e, RbelHostname.create((SocketAddress)clientAddress), RbelHostname.create((SocketAddress)serverAddress));
            throw e;
        }
    }

    private void pairWithRequestAndPropagate(Optional<RbelElement> convertedResponse, Optional<RbelElement> convertedRequest, boolean shouldWaitForResponse) {
        if (shouldWaitForResponse) {
            if (convertedResponse.isPresent() && convertedRequest.isPresent()) {
                RbelElement request = convertedRequest.get();
                RbelElement response = convertedResponse.get();
                TracingMessagePairFacet pairFacet = new TracingMessagePairFacet(response, request);
                request.addOrReplaceFacet((RbelFacet)pairFacet);
                response.addOrReplaceFacet((RbelFacet)pairFacet);
                this.getTigerProxy().triggerListener(request);
                this.getTigerProxy().triggerListener(response);
            } else {
                convertedRequest.or(() -> convertedResponse).ifPresent(msg -> {
                    msg.addOrReplaceFacet((RbelFacet)new TigerNonPairedMessageFacet());
                    this.getTigerProxy().triggerListener((RbelElement)msg);
                });
            }
        } else {
            convertedResponse.ifPresent(msg -> {
                msg.addOrReplaceFacet((RbelFacet)new TigerNonPairedMessageFacet());
                this.getTigerProxy().triggerListener((RbelElement)msg);
            });
        }
    }

    private void handleConversionException(Throwable exception, SocketAddress clientAddress, SocketAddress serverAddress) {
        if (!this.shouldIgnoreConnectionErrors()) {
            if (BinaryExchangeHandler.isConnectionResetException(exception)) {
                log.trace("Connection reset:", exception);
            } else {
                log.warn("Exception during Direct-Proxy handling:", exception);
                this.propagateExceptionMessageSafe(exception, RbelHostname.create((SocketAddress)clientAddress), RbelHostname.create((SocketAddress)serverAddress));
            }
        }
    }

    private boolean shouldIgnoreConnectionErrors() {
        return Optional.ofNullable(this.getTigerProxy().getTigerProxyConfiguration().getDirectReverseProxy()).map(DirectReverseProxyInfo::isIgnoreConnectionErrors).orElse(false);
    }

    private static boolean isConnectionResetException(Throwable t) {
        return TigerExceptionUtils.getCauseWithType((Throwable)t, SocketException.class).filter(e -> "Connection reset".equals(e.getMessage())).isPresent();
    }

    private boolean shouldWaitForResponse(Optional<RbelElement> convertedRequest) {
        return convertedRequest.map(RbelElement::getFacets).stream().flatMap(Collection::stream).anyMatch(RbelFacet::shouldExpectReplyMessage);
    }

    private Optional<RbelElement> convertBinaryMessageOrPushToBuffer(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        if (message == null) {
            return Optional.empty();
        }
        Optional<RbelElement> rbelMessageOptional = this.binaryChunksBuffer.tryToConvertMessageAndBufferUnusedBytes(RbelContent.of((byte[])message.getBytes()), senderAddress, receiverAddress);
        if (rbelMessageOptional.isEmpty()) {
            return Optional.empty();
        }
        rbelMessageOptional.get().addFacet((RbelFacet)RbelMessageTimingFacet.builder().transmissionTime(message.getTimestamp().atZone(ZoneId.systemDefault())).build());
        rbelMessageOptional.get().addFacet((RbelFacet)new RbelBinaryFacet());
        log.debug("Finalized binary exchange {}", (Object)rbelMessageOptional.flatMap(msg -> msg.getFacet(RbelTcpIpMessageFacet.class)).map(RbelTcpIpMessageFacet::getSenderHostname).map(Objects::toString).orElse(""));
        return rbelMessageOptional;
    }

    public void propagateExceptionMessageSafe(Throwable exception, RbelHostname senderAddress, RbelHostname receiverAddress) {
        try {
            this.tigerProxy.propagateException(exception);
            TigerProxyRoutingException routingException = new TigerProxyRoutingException("Exception during handling of HTTP request: " + exception.getMessage(), senderAddress, receiverAddress, exception);
            log.info(routingException.getMessage(), (Throwable)((Object)routingException));
            RbelElement message = new RbelElement(new byte[0], null);
            message.addFacet((RbelFacet)new TigerRoutingErrorFacet(routingException));
            this.tigerProxy.getRbelLogger().getRbelConverter().parseMessage(new RbelElementConvertionPair(message), senderAddress, receiverAddress, Optional.of(routingException.getTimestamp()));
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occured (ignoring):", (Throwable)handlingException);
        }
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public BinaryChunksBuffer getBinaryChunksBuffer() {
        return this.binaryChunksBuffer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryExchangeHandler)) {
            return false;
        }
        BinaryExchangeHandler other = (BinaryExchangeHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        BinaryChunksBuffer this$binaryChunksBuffer = this.getBinaryChunksBuffer();
        BinaryChunksBuffer other$binaryChunksBuffer = other.getBinaryChunksBuffer();
        return !(this$binaryChunksBuffer == null ? other$binaryChunksBuffer != null : !this$binaryChunksBuffer.equals(other$binaryChunksBuffer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BinaryExchangeHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        BinaryChunksBuffer $binaryChunksBuffer = this.getBinaryChunksBuffer();
        result = result * 59 + ($binaryChunksBuffer == null ? 43 : $binaryChunksBuffer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BinaryExchangeHandler(tigerProxy=" + String.valueOf(this.getTigerProxy()) + ", binaryChunksBuffer=" + String.valueOf(this.getBinaryChunksBuffer()) + ")";
    }
}

