/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelElementConvertionPair;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.UnparsedChunkFacet;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.proxy.data.SenderReceiverPair;
import de.gematik.test.tiger.proxy.handler.BundledServerNamesAdder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryChunksBuffer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryChunksBuffer.class);
    private final BundledServerNamesAdder bundledServerNamesAdder = new BundledServerNamesAdder();
    private final Map<SenderReceiverPair, RbelContent> bufferedParts = new ConcurrentHashMap<SenderReceiverPair, RbelContent>();
    private final RbelConverter rbelConverter;
    private final TigerProxyConfiguration proxyConfiguration;

    public BinaryChunksBuffer(RbelConverter rbelConverter, TigerProxyConfiguration proxyConfiguration) {
        this.rbelConverter = rbelConverter;
        this.proxyConfiguration = proxyConfiguration;
    }

    private void removePart(SenderReceiverPair key) {
        this.bufferedParts.remove(key);
    }

    private RbelContent addToBuffer(SenderReceiverPair key, RbelContent part) {
        RbelContent bufferedContent = this.bufferedParts.computeIfAbsent(key, k -> RbelContent.builder().build());
        bufferedContent.append(part);
        return bufferedContent;
    }

    public Optional<RbelElement> tryToConvertMessageAndBufferUnusedBytes(RbelContent message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        SenderReceiverPair key = new SenderReceiverPair(senderAddress, receiverAddress);
        Optional<RbelElement> requestOptional = this.tryToConvertMessage(this.addToBuffer(key, message), key);
        if (requestOptional.isPresent()) {
            this.removePart(key);
        }
        return requestOptional;
    }

    private Optional<RbelElement> tryToConvertMessage(RbelContent messageContent, SenderReceiverPair connectionKey) {
        RbelElement messageElement = new RbelElement(messageContent);
        RbelElement result = this.rbelConverter.parseMessage(new RbelElementConvertionPair(messageElement), this.toRbelHostname(connectionKey.sender()), this.toRbelHostname(connectionKey.receiver()), Optional.empty(), RbelConverter.FinishProcessing.NO);
        if (this.proxyConfiguration.isActivateRbelParsing() && result.getFacets().stream().noneMatch(f -> f instanceof RbelRootFacet || f instanceof RbelResponseFacet || f instanceof RbelRequestFacet || f instanceof UnparsedChunkFacet)) {
            this.rbelConverter.removeMessage(result);
            RbelConverter.setMessageFullyProcessed((RbelElement)result);
            return Optional.empty();
        }
        this.bundledServerNamesAdder.addBundledServerNameToHostnameFacet(result);
        if (!this.proxyConfiguration.isActivateRbelParsing()) {
            result.addOrReplaceFacet((RbelFacet)new UnparsedChunkFacet());
        }
        return Optional.of(result);
    }

    private RbelHostname toRbelHostname(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return RbelHostname.builder().hostname(inetSocketAddress.getHostName()).port(inetSocketAddress.getPort()).build();
        }
        log.warn("Incompatible socketAddress encountered: " + socketAddress.getClass().getSimpleName());
        return null;
    }
}

