/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.exceptions;

import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelMapFacet;
import de.gematik.rbellogger.data.facet.RbelMessageInfoFacet;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRoutingException;
import de.gematik.test.tiger.proxy.exceptions.TigerRoutingErrorFacet;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo
public class RbelTigerProxyExceptionConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelTigerProxyExceptionConverter.class);

    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        if (!rbelElement.hasFacet(TigerRoutingErrorFacet.class)) {
            return;
        }
        TigerProxyRoutingException routingException = ((TigerRoutingErrorFacet)rbelElement.getFacetOrFail(TigerRoutingErrorFacet.class)).getException();
        RbelElement childElement = new RbelElement(new byte[0], rbelElement);
        ((TigerRoutingErrorFacet)rbelElement.getFacetOrFail(TigerRoutingErrorFacet.class)).setErrorElement(childElement);
        RbelMultiMap childNodes = new RbelMultiMap();
        childElement.addFacet((RbelFacet)new RbelMapFacet(childNodes));
        childNodes.put("message", (Object)RbelElement.wrap((RbelElement)childElement, (Object)routingException.getMessage()));
        childNodes.put("timestamp", (Object)RbelElement.wrap((RbelElement)childElement, (Object)routingException.getTimestamp()));
        if (routingException.getSenderAddress() != null) {
            childNodes.put("sender", (Object)RbelElement.wrap((RbelElement)childElement, (Object)routingException.getSenderAddress()));
        }
        if (routingException.getReceiverAddress() != null) {
            childNodes.put("receiver", (Object)RbelElement.wrap((RbelElement)childElement, (Object)routingException.getReceiverAddress()));
        }
        String errorMessage = Optional.ofNullable(routingException.getCause()).map(Throwable::getMessage).orElseGet(() -> routingException.getMessage());
        rbelElement.addFacet(RbelMessageInfoFacet.newErrorSymbol((String)errorMessage));
    }
}

