/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.controller;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.data.util.RbelElementTreePrinter;
import de.gematik.rbellogger.exceptions.RbelPathException;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.rbellogger.renderer.MessageMetaDataDto;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.RbelJexlExecutor;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.exceptions.TigerJexlException;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.GetMessagesFilterScrollableDto;
import de.gematik.test.tiger.proxy.data.GetMessagesWithHtmlScrollableDto;
import de.gematik.test.tiger.proxy.data.GetMessagesWithMetaScrollableDto;
import de.gematik.test.tiger.proxy.data.HtmlMessageScrollableDto;
import de.gematik.test.tiger.proxy.data.JexlQueryResponseScrollableDto;
import de.gematik.test.tiger.proxy.data.MetaMessageScrollableDto;
import de.gematik.test.tiger.proxy.data.RbelTreeResponseScrollableDto;
import de.gematik.test.tiger.proxy.data.ResetMessagesDto;
import de.gematik.test.tiger.proxy.data.SearchMessagesScrollableDto;
import de.gematik.test.tiger.server.TigerBuildPropertiesService;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.jexl3.JexlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"webui", "/"})
@Validated
public class TigerWebUiController
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerWebUiController.class);
    private static final int MAX_MESSAGES_PER_FILTER_REQUEST = 100;
    private static final int MAX_MESSAGES_PER_SEARCH_REQUEST = 10;
    private static final String RBEL_KEY_CONTENT = ".content";
    public static final String REGEX_STATUSCODE_TOKEN = ".*:\\d* ";
    private TigerProxy tigerProxy;
    private final RbelHtmlRenderer renderer;
    private final TigerProxyConfiguration proxyConfiguration;
    private ApplicationContext applicationContext;
    public final SimpMessagingTemplate template;
    private final TigerBuildPropertiesService buildProperties;

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.applicationContext = appContext;
    }

    @GetMapping(value={""})
    public ResponseEntity<Resource> getIndex() {
        ClassPathResource resource = new ClassPathResource("/static/webui/index.html");
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"text/html")).body((Object)resource);
    }

    @GetMapping(value={"/assets/{asset}"})
    public ResponseEntity<Resource> getAsset(@PathVariable(value="asset") String assetFile) {
        ClassPathResource resource = new ClassPathResource("/static/webui/assets/" + assetFile);
        if (!resource.exists()) {
            return ResponseEntity.notFound().build();
        }
        String fileExt = StringUtils.getFilenameExtension((String)assetFile);
        if (fileExt == null) {
            return ResponseEntity.notFound().build();
        }
        String contentType = switch (fileExt) {
            case "css" -> "text/css";
            case "js" -> "application/javascript";
            case "html", "htm" -> "text/html";
            case "png" -> "image/png";
            case "jpg", "jpeg" -> "image/jpeg";
            case "gif" -> "image/gif";
            case "svg" -> "image/svg+xml";
            case "woff" -> "font/woff";
            case "woff2" -> "font/woff2";
            case "ttf" -> "font/ttf";
            default -> "application/octet-stream";
        };
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).body((Object)resource);
    }

    @GetMapping(value={"/testJexlQuery"}, produces={"application/json"})
    public JexlQueryResponseScrollableDto testJexlQuery(@RequestParam(name="messageUuid") String messageUuid, @RequestParam(name="query") String query) {
        JexlQueryResponseScrollableDto.JexlQueryResponseScrollableDtoBuilder response = JexlQueryResponseScrollableDto.builder().messageUuid(messageUuid).query(query);
        RbelElement targetMessage = this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> msg.getUuid().equals(messageUuid)).findFirst().orElseThrow();
        TigerJexlContext messageContext = TigerJexlExecutor.buildJexlMapContext((Object)targetMessage, Optional.empty());
        response = response.messageContext((Map<String, Object>)messageContext);
        try {
            return response.matchSuccessful(TigerJexlExecutor.matchesAsJexlExpression((Object)targetMessage, (String)query)).build();
        }
        catch (TigerJexlException | JexlException jexlException) {
            log.warn("Failed to perform JEXL query '" + query + "'", jexlException);
            String msg2 = jexlException.getMessage();
            msg2 = msg2.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return response.errorMessage(msg2).build();
        }
        catch (RuntimeException rte) {
            log.warn("Runtime failure while performing JEXL query '" + query + "'", (Throwable)rte);
            String msg3 = rte.getMessage();
            msg3 = msg3.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return response.errorMessage(msg3).build();
        }
    }

    @GetMapping(value={"/testRbelExpression"}, produces={"application/json"})
    public RbelTreeResponseScrollableDto testRbelExpression(@RequestParam(name="messageUuid") String msgUuid, @RequestParam(name="query") String query) {
        List targetElements;
        RbelTreeResponseScrollableDto.RbelTreeResponseScrollableDtoBuilder response = RbelTreeResponseScrollableDto.builder().messageUuid(msgUuid).query(query);
        try {
            targetElements = this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> msg.getUuid().equals(msgUuid)).map(msg -> msg.findRbelPathMembers(query)).flatMap(Collection::stream).toList();
            if (targetElements.isEmpty()) {
                return response.build();
            }
        }
        catch (RbelPathException rbelPathException) {
            log.warn("Failed to perform RBelPath query '{}'", (Object)query, (Object)rbelPathException);
            String msg2 = rbelPathException.getMessage();
            msg2 = msg2.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return response.errorMessage(msg2).build();
        }
        try {
            return response.elementsWithTree(targetElements.stream().map(rbelElement -> {
                String html = this.createRbelTreeForElement((RbelElement)rbelElement, query);
                String key = rbelElement.findNodePath();
                String el = key.endsWith(RBEL_KEY_CONTENT) && !query.endsWith(RBEL_KEY_CONTENT) ? "$." + key.substring(0, key.length() - RBEL_KEY_CONTENT.length()) : "$." + key;
                return new AbstractMap.SimpleEntry<CallSite, String>((CallSite)((Object)el), html);
            }).collect(Collectors.toList())).build();
        }
        catch (TigerJexlException | JexlException jexlException) {
            log.warn("Failed to perform RBelPath query '{}'", (Object)query, (Object)jexlException);
            String msg3 = jexlException.getMessage();
            msg3 = msg3.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return response.errorMessage(msg3).build();
        }
        catch (RuntimeException rte) {
            log.warn("Runtime failure while performing RbelPath query '{}'", (Object)query, (Object)rte);
            String msg4 = rte.getMessage();
            msg4 = msg4.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return response.errorMessage(msg4).build();
        }
    }

    private String createRbelTreeForElement(RbelElement targetElement, String rbelPath) {
        RbelElement rootElement = targetElement.getKey().filter(key -> key.endsWith("content") && !rbelPath.endsWith("content")).map(key -> targetElement.getParentNode()).orElse(targetElement);
        return RbelElementTreePrinter.builder().rootElement(rootElement).printFacets(true).htmlEscaping(true).addJexlResponseLinkCssClass(true).build().execute();
    }

    private String messageHash() {
        Deque<RbelElement> messages = this.getTigerProxy().getRbelMessages();
        return messages.isEmpty() ? new UUID(this.getTigerProxy().hashCode(), 1234L).toString() : messages.getFirst().getUuid();
    }

    private <T> void addOffsetToMessages(long startOffset, List<T> messages, ObjLongConsumer<T> offsetSetter) {
        for (int i = 0; i < messages.size(); ++i) {
            offsetSetter.accept(messages.get(i), (long)i + startOffset);
        }
    }

    @GetMapping(value={"/getMessagesWithHtml"}, produces={"application/json"})
    public GetMessagesWithHtmlScrollableDto getMessagesWithHtml(@RequestParam(name="fromOffset") int fromOffset, @RequestParam(name="toOffsetExcluding") int toOffsetExcluding, @RequestParam(name="filterRbelPath", required=false) String filterRbelPath) {
        if (toOffsetExcluding < fromOffset) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "`toOffsetExcluding` must be greater or equal than `fromOffset`");
        }
        LinkedList messages = new LinkedList(this.getTigerProxy().getRbelLogger().getMessageHistory());
        int total = messages.size();
        GetMessagesWithHtmlScrollableDto result = new GetMessagesWithHtmlScrollableDto();
        result.setFromOffset(fromOffset);
        result.setToOffsetExcluding(toOffsetExcluding);
        result.setFilter(GetMessagesFilterScrollableDto.builder().rbelPath(filterRbelPath).build());
        result.setTotal(total);
        result.setHash(this.messageHash());
        Stream<RbelElement> messageStream = messages.stream();
        messageStream = this.filterMessages(messageStream, filterRbelPath);
        result.setMessages(messageStream.skip(fromOffset).limit((long)toOffsetExcluding - (long)fromOffset).map(msg -> HtmlMessageScrollableDto.builder().content(new RbelHtmlRenderingToolkit(this.renderer).convertMessage(msg).render()).uuid(msg.getUuid()).sequenceNumber(MessageMetaDataDto.getElementSequenceNumber((RbelElement)msg)).build()).toList());
        this.addOffsetToMessages(fromOffset, result.getMessages(), HtmlMessageScrollableDto::setOffset);
        result.setTotalFiltered(result.getMessages().size());
        return result;
    }

    @GetMapping(value={"/getMessagesWithMeta"}, produces={"application/json"})
    public GetMessagesWithMetaScrollableDto getMessagesWithMeta(@RequestParam(name="filterRbelPath", required=false) String filterRbelPath) {
        LinkedList messages = new LinkedList(this.getTigerProxy().getRbelLogger().getMessageHistory());
        int total = messages.size();
        GetMessagesWithMetaScrollableDto result = new GetMessagesWithMetaScrollableDto();
        result.setTotal(total);
        result.setHash(this.messageHash());
        result.setFilter(GetMessagesFilterScrollableDto.builder().rbelPath(filterRbelPath).build());
        Stream<RbelElement> messageStream = messages.stream();
        messageStream = this.filterMessages(messageStream, filterRbelPath);
        result.setMessages(messageStream.map(MetaMessageScrollableDto::createFrom).toList());
        this.addOffsetToMessages(0L, result.getMessages(), MetaMessageScrollableDto::setOffset);
        result.setTotalFiltered(result.getMessages().size());
        return result;
    }

    @GetMapping(value={"/testFilterMessages"}, produces={"application/json"})
    public SearchMessagesScrollableDto testFilterMessages(@RequestParam(name="filterRbelPath", required=false) String filterRbelPath) {
        LinkedList messages = new LinkedList(this.getTigerProxy().getRbelLogger().getMessageHistory());
        int total = messages.size();
        SearchMessagesScrollableDto result = new SearchMessagesScrollableDto();
        result.setTotal(total);
        result.setHash(this.messageHash());
        result.setFilter(GetMessagesFilterScrollableDto.builder().rbelPath(filterRbelPath).build());
        Stream<RbelElement> messageStream = messages.stream();
        try {
            messageStream = this.filterMessages(messageStream, filterRbelPath).limit(101L);
            long totalFilteredMessages = messageStream.count();
            if (totalFilteredMessages > 100L) {
                result.setTotalFiltered("100+");
            } else {
                result.setTotalFiltered(String.valueOf(totalFilteredMessages));
            }
        }
        catch (TigerJexlException | JexlException e) {
            log.info(e.getMessage(), e);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }

    @GetMapping(value={"/searchMessages"}, produces={"application/json"})
    public SearchMessagesScrollableDto searchMessages(@RequestParam(name="filterRbelPath") String filterRbelPath, @RequestParam(name="searchRbelPath") String searchRbelPath) {
        RbelLogger rbelLogger = this.tigerProxy.getRbelLogger();
        int total = rbelLogger.getMessageHistory().size();
        Deque messages = this.getTigerProxy().getRbelLogger().getMessageHistory();
        SearchMessagesScrollableDto result = new SearchMessagesScrollableDto();
        result.setTotal(total);
        result.setHash(this.messageHash());
        result.setFilter(GetMessagesFilterScrollableDto.builder().rbelPath(filterRbelPath).build());
        result.setSearchFilter(GetMessagesFilterScrollableDto.builder().rbelPath(searchRbelPath).build());
        Stream<RbelElement> messageStream = messages.stream();
        try {
            messageStream = this.filterMessages(messageStream, filterRbelPath);
            messageStream = this.filterMessages(messageStream, searchRbelPath);
            result.setMessages(messageStream.limit(11L).map(MetaMessageScrollableDto::createFrom).toList());
            int totalFilteredMessages = result.getMessages().size();
            if (totalFilteredMessages > 10) {
                result.setMessages(result.getMessages().subList(0, 10));
                result.setTotalFiltered("10+");
            } else {
                result.setTotalFiltered(String.valueOf(totalFilteredMessages));
            }
        }
        catch (TigerJexlException | JexlException e) {
            log.info(e.getMessage(), e);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }

    private Stream<RbelElement> filterMessages(Stream<RbelElement> stream, String filterRbelPath) {
        String actualFilterRbelPath = filterRbelPath != null && filterRbelPath.isBlank() ? null : filterRbelPath;
        return actualFilterRbelPath != null ? stream.filter(msg -> TigerJexlExecutor.matchesAsJexlExpression((Object)msg, (String)actualFilterRbelPath, Optional.empty()) || TigerJexlExecutor.matchesAsJexlExpression((Object)this.findPartner((RbelElement)msg), (String)actualFilterRbelPath, Optional.empty())) : stream;
    }

    private RbelElement findPartner(RbelElement msg) {
        return msg.getFacet(TracingMessagePairFacet.class).map(pairFacet -> {
            if (pairFacet.getRequest() == msg) {
                return pairFacet.getResponse();
            }
            return pairFacet.getRequest();
        }).orElse(null);
    }

    @GetMapping(value={"/trafficLog*.tgr"}, produces={"application/octet-stream"})
    public String downloadTraffic(@RequestParam(name="lastMsgUuid", required=false) String lastMsgUuid, @RequestParam(name="filterRbelPath", required=false) String filterCriterion, @RequestParam(name="pageSize", required=false) Optional<Integer> pageSize, HttpServletResponse response) {
        int actualPageSize = pageSize.orElse(this.getProxyConfiguration().getMaximumTrafficDownloadPageSize());
        List<RbelElement> filteredMessages = this.loadMessagesMatchingFilter(lastMsgUuid, filterCriterion);
        int returnedMessages = Math.min(filteredMessages.size(), actualPageSize);
        response.addHeader("available-messages", String.valueOf(filteredMessages.size()));
        response.addHeader("returned-messages", String.valueOf(returnedMessages));
        String result = filteredMessages.stream().limit(actualPageSize).map(arg_0 -> ((RbelFileWriter)this.tigerProxy.getRbelFileWriter()).convertToRbelFileString(arg_0)).collect(Collectors.joining("\n\n"));
        if (!result.isEmpty()) {
            response.addHeader("last-uuid", filteredMessages.get(returnedMessages - 1).getUuid());
        }
        return result;
    }

    private List<RbelElement> loadMessagesMatchingFilter(String lastMsgUuid, String filterCriterion) {
        return this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> {
            if (!StringUtils.hasText((String)filterCriterion)) {
                return true;
            }
            if (filterCriterion.startsWith("\"") && filterCriterion.endsWith("\"")) {
                String textFilter = filterCriterion.substring(1, filterCriterion.length() - 1);
                return RbelJexlExecutor.matchAsTextExpression((Object)msg, (String)textFilter) || RbelJexlExecutor.matchAsTextExpression((Object)this.findPartner((RbelElement)msg), (String)textFilter);
            }
            return TigerJexlExecutor.matchesAsJexlExpression((Object)msg, (String)filterCriterion, Optional.empty()) || TigerJexlExecutor.matchesAsJexlExpression((Object)this.findPartner((RbelElement)msg), (String)filterCriterion, Optional.empty());
        }).dropWhile(TigerWebUiController.messageIsBefore(lastMsgUuid)).filter(msg -> !msg.getUuid().equals(lastMsgUuid)).toList();
    }

    private static Predicate<RbelElement> messageIsBefore(String lastMsgUuid) {
        return msg -> {
            if (StringUtils.hasText((String)lastMsgUuid)) {
                return !msg.getUuid().equals(lastMsgUuid);
            }
            return false;
        };
    }

    @GetMapping(value={"/resetMessages"}, produces={"application/json"})
    public ResetMessagesDto resetMessages() {
        log.info("Resetting currently recorded messages on rbel logger..");
        int size = this.getTigerProxy().getRbelLogger().getMessageHistory().size();
        ResetMessagesDto result = new ResetMessagesDto();
        result.setNumMsgs(size);
        this.getTigerProxy().getRbelLogger().clearAllMessages();
        return result;
    }

    @GetMapping(value={"/quit"}, produces={"application/json"})
    public void quitProxy(@RequestParam(name="noSystemExit", required=false) String noSystemExit) {
        log.info("Shutting down tiger standalone proxy at port " + this.tigerProxy.getProxyPort() + "...");
        this.tigerProxy.close();
        log.info("Shutting down tiger standalone proxy ui...");
        int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        if (exitCode != 0) {
            log.warn("Exit of tiger proxy ui not successful - exit code: " + exitCode);
        }
        if (!StringUtils.hasText((String)noSystemExit)) {
            System.exit(0);
        }
    }

    @PostMapping(value={"/importTraffic"})
    public void importTraffic(@RequestBody String rawTraffic) {
        this.tigerProxy.readTrafficFromString(rawTraffic);
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public RbelHtmlRenderer getRenderer() {
        return this.renderer;
    }

    @Generated
    public TigerProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public SimpMessagingTemplate getTemplate() {
        return this.template;
    }

    @Generated
    public TigerBuildPropertiesService getBuildProperties() {
        return this.buildProperties;
    }

    @Generated
    public void setTigerProxy(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerWebUiController)) {
            return false;
        }
        TigerWebUiController other = (TigerWebUiController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        RbelHtmlRenderer this$renderer = this.getRenderer();
        RbelHtmlRenderer other$renderer = other.getRenderer();
        if (this$renderer == null ? other$renderer != null : !this$renderer.equals(other$renderer)) {
            return false;
        }
        TigerProxyConfiguration this$proxyConfiguration = this.getProxyConfiguration();
        TigerProxyConfiguration other$proxyConfiguration = other.getProxyConfiguration();
        if (this$proxyConfiguration == null ? other$proxyConfiguration != null : !this$proxyConfiguration.equals(other$proxyConfiguration)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        SimpMessagingTemplate this$template = this.getTemplate();
        SimpMessagingTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        TigerBuildPropertiesService this$buildProperties = this.getBuildProperties();
        TigerBuildPropertiesService other$buildProperties = other.getBuildProperties();
        return !(this$buildProperties == null ? other$buildProperties != null : !this$buildProperties.equals(other$buildProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerWebUiController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        RbelHtmlRenderer $renderer = this.getRenderer();
        result = result * 59 + ($renderer == null ? 43 : $renderer.hashCode());
        TigerProxyConfiguration $proxyConfiguration = this.getProxyConfiguration();
        result = result * 59 + ($proxyConfiguration == null ? 43 : $proxyConfiguration.hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        SimpMessagingTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        TigerBuildPropertiesService $buildProperties = this.getBuildProperties();
        result = result * 59 + ($buildProperties == null ? 43 : $buildProperties.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerWebUiController(tigerProxy=" + String.valueOf(this.getTigerProxy()) + ", renderer=" + String.valueOf(this.getRenderer()) + ", proxyConfiguration=" + String.valueOf(this.getProxyConfiguration()) + ", applicationContext=" + String.valueOf(this.getApplicationContext()) + ", template=" + String.valueOf(this.getTemplate()) + ", buildProperties=" + String.valueOf(this.getBuildProperties()) + ")";
    }

    @ConstructorProperties(value={"renderer", "proxyConfiguration", "template", "buildProperties"})
    @Generated
    public TigerWebUiController(RbelHtmlRenderer renderer, TigerProxyConfiguration proxyConfiguration, SimpMessagingTemplate template, TigerBuildPropertiesService buildProperties) {
        this.renderer = renderer;
        this.proxyConfiguration = proxyConfiguration;
        this.template = template;
        this.buildProperties = buildProperties;
    }
}

