/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.configuration;

import de.gematik.test.tiger.common.data.config.tigerproxy.ForwardProxyInfo;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyType;
import de.gematik.test.tiger.common.exceptions.TigerProxyToForwardProxyException;
import de.gematik.test.tiger.common.exceptions.TigerUnknownProtocolException;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ProxyConfigurationConverter {
    private ProxyConfigurationConverter() {
    }

    public static Optional<ProxyConfiguration> convertForwardProxyConfigurationToMockServerConfiguration(TigerProxyConfiguration tpConfig) {
        return Optional.ofNullable(tpConfig.getForwardToProxy()).flatMap(ProxyConfigurationConverter::createMockServerProxyConfiguration);
    }

    public static ProxyConfiguration.Type toMockServerType(TigerProxyType type) throws TigerUnknownProtocolException {
        if (type == TigerProxyType.HTTP) {
            return ProxyConfiguration.Type.HTTP;
        }
        if (type == TigerProxyType.HTTPS) {
            return ProxyConfiguration.Type.HTTPS;
        }
        throw new TigerUnknownProtocolException("Protocol of type " + type.toString() + " not specified for proxies");
    }

    public static Optional<ProxyConfiguration> createMockServerProxyConfiguration(ForwardProxyInfo forwardProxyInfo) {
        if (StringUtils.isEmpty((CharSequence)forwardProxyInfo.getHostname())) {
            return Optional.empty();
        }
        if (StringUtils.equals((CharSequence)forwardProxyInfo.getHostname(), (CharSequence)"$SYSTEM")) {
            return ProxyConfigurationConverter.convertSystemProxyConfig(forwardProxyInfo);
        }
        ProxyConfiguration result = ProxyConfiguration.proxyConfiguration(Optional.ofNullable(forwardProxyInfo.getType()).map(ProxyConfigurationConverter::toMockServerType).orElse(ProxyConfiguration.Type.HTTP), forwardProxyInfo.getHostname() + ":" + forwardProxyInfo.calculateProxyPort(), forwardProxyInfo.getUsername(), forwardProxyInfo.getPassword());
        if (forwardProxyInfo.getNoProxyHosts() != null) {
            result.getNoProxyHosts().addAll(forwardProxyInfo.getNoProxyHosts());
        }
        return Optional.of(result);
    }

    public static Optional<ProxyConfiguration> useProxyWithSystemProperties(String proxyProtocol, ForwardProxyInfo forwardProxyInfo) {
        ProxyConfiguration.Type proxyType = ProxyConfigurationConverter.toMockServerType(forwardProxyInfo.getProxyProtocol(proxyProtocol));
        String proxyHost = System.getProperty(proxyProtocol + ".proxyHost");
        String proxyPort = System.getProperty(proxyProtocol + ".proxyPort");
        String proxyUser = System.getProperty(proxyProtocol + ".proxyUser");
        String proxyPassword = System.getProperty(proxyProtocol + ".proxyPassword");
        if (StringUtils.isEmpty((CharSequence)proxyHost)) {
            return Optional.empty();
        }
        if (proxyUser != null || proxyPassword != null) {
            if (proxyUser == null) {
                throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: proxyUser == null, proxyPassword != null");
            }
            if (proxyPassword == null) {
                throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: proxyUser != null, proxyPassword == null");
            }
            return Optional.of(ProxyConfiguration.proxyConfiguration(proxyType, proxyHost + ":" + ForwardProxyInfo.mapProxyPort((String)proxyPort, (TigerProxyType)forwardProxyInfo.getProxyProtocol(proxyProtocol)), proxyUser, proxyPassword));
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration(proxyType, proxyHost + ":" + ForwardProxyInfo.mapProxyPort((String)proxyPort, (TigerProxyType)forwardProxyInfo.getProxyProtocol(proxyProtocol))));
    }

    public static Optional<ProxyConfiguration> useProxyAsEnvVar(ForwardProxyInfo forwardProxyInfo, String envProxyType) {
        String httpProxyHostFromEnv = System.getenv(envProxyType);
        if (StringUtils.isEmpty((CharSequence)httpProxyHostFromEnv)) {
            return Optional.empty();
        }
        URI proxyAsUri = URI.create(httpProxyHostFromEnv);
        if (proxyAsUri.getHost() == null) {
            throw new TigerProxyToForwardProxyException("No proxy host specified.");
        }
        ProxyConfiguration.Type proxyType = ProxyConfigurationConverter.toMockServerType(forwardProxyInfo.getProxyProtocol(proxyAsUri.getScheme()));
        String proxyUsernamePassword = proxyAsUri.getUserInfo();
        String proxyPort = ForwardProxyInfo.mapProxyPort((String)String.valueOf(proxyAsUri.getPort()), (TigerProxyType)forwardProxyInfo.getProxyProtocol(proxyAsUri.getScheme()));
        if (proxyUsernamePassword == null) {
            return Optional.of(ProxyConfiguration.proxyConfiguration(proxyType, proxyAsUri.getHost() + ":" + proxyPort)).map(ProxyConfigurationConverter::addNoProxyHostsFromEnv);
        }
        if (!proxyUsernamePassword.contains(":")) {
            throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: either username or password are not present in the env variable");
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration(proxyType, proxyAsUri.getHost() + ":" + proxyPort, proxyUsernamePassword.split(":")[0], proxyUsernamePassword.split(":")[1])).map(ProxyConfigurationConverter::addNoProxyHostsFromEnv);
    }

    private static ProxyConfiguration addNoProxyHostsFromEnv(ProxyConfiguration proxyConfiguration) {
        String noProxyHosts = System.getenv("no_proxy");
        if (noProxyHosts != null) {
            proxyConfiguration.getNoProxyHosts().addAll(List.of(noProxyHosts.split(",")));
        }
        return proxyConfiguration;
    }

    public static Optional<ProxyConfiguration> convertSystemProxyConfig(ForwardProxyInfo forwardProxyInfo) {
        return ProxyConfigurationConverter.useProxyWithSystemProperties("http", forwardProxyInfo).or(() -> ProxyConfigurationConverter.useProxyWithSystemProperties("https", forwardProxyInfo)).or(() -> ProxyConfigurationConverter.useProxyAsEnvVar(forwardProxyInfo, "http_proxy")).or(() -> ProxyConfigurationConverter.useProxyAsEnvVar(forwardProxyInfo, "https_proxy"));
    }
}

