/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TracingMessageFrame;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingMessagePair
implements TracingMessageFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingMessagePair.class);
    private PartialTracingMessage request;
    private PartialTracingMessage response;
    private final TigerRemoteProxyClient remoteProxyClient;

    @Override
    public void checkForCompletePairAndPropagateIfComplete() {
        if (this.request != null && this.response != null && this.request.isComplete() && this.response.isComplete()) {
            this.parseAndPropagate();
        }
    }

    private synchronized void parseAndPropagate() {
        if (this.remoteProxyClient.messageUuidKnown(this.request.getTracingDto().getRequestUuid()) || this.remoteProxyClient.messageUuidKnown(this.request.getTracingDto().getResponseUuid())) {
            log.trace("{}Skipping parsing of pair with UUIDs ({} and {}) (received from PUSH): UUID already known", new Object[]{this.remoteProxyClient.proxyName(), this.request.getTracingDto().getRequestUuid(), this.request.getTracingDto().getResponseUuid()});
            return;
        }
        Optional<CompletableFuture<RbelElement>> requestParsed = this.remoteProxyClient.buildNewRbelMessage(this.request.getSender(), this.request.getReceiver(), this.request.buildCompleteContent(), Optional.ofNullable(this.request.getTransmissionTime()), this.request.getTracingDto().getRequestUuid());
        Optional<CompletableFuture<RbelElement>> responseParsed = this.remoteProxyClient.buildNewRbelResponse(this.response.getSender(), this.response.getReceiver(), this.response.buildCompleteContent(), requestParsed, Optional.ofNullable(this.response.getTransmissionTime()), this.response.getTracingDto().getResponseUuid());
        if (requestParsed.isEmpty() || responseParsed.isEmpty()) {
            return;
        }
        ((CompletableFuture)((CompletableFuture)requestParsed.get().thenCombineAsync(responseParsed.get(), (req, res) -> {
            try {
                this.performPostConversion((RbelElement)req, (RbelElement)res);
                Object var3_3 = null;
                return var3_3;
            }
            catch (RuntimeException e) {
                log.info("{} - Error while processing pair with UUIDs {} and {}", new Object[]{this.remoteProxyClient.proxyName(), this.request.getTracingDto().getRequestUuid(), this.request.getTracingDto().getResponseUuid(), e});
                throw e;
            }
            finally {
                RbelConverter.setMessageFullyProcessed((RbelElement)req);
                RbelConverter.setMessageFullyProcessed((RbelElement)res);
            }
        })).exceptionally(e -> {
            log.error("{} - Error while processing pair with UUIDs {} and {}", new Object[]{this.remoteProxyClient.proxyName(), this.request.getTracingDto().getRequestUuid(), this.request.getTracingDto().getResponseUuid(), e});
            return null;
        })).join();
    }

    private void performPostConversion(RbelElement req, RbelElement res) {
        if (this.request.getTracingDto().getSequenceNumberRequest() != null && this.response.getTracingDto().getSequenceNumberResponse() != null) {
            req.addOrReplaceFacet((RbelFacet)((RbelTcpIpMessageFacet)req.getFacetOrFail(RbelTcpIpMessageFacet.class)).toBuilder().receivedFromRemoteWithUrl(this.remoteProxyClient.getRemoteProxyUrl()).build());
            req.addFacet((RbelFacet)this.request.getTracingDto().getProxyTransmissionHistoryRequest());
            res.addOrReplaceFacet((RbelFacet)((RbelTcpIpMessageFacet)res.getFacetOrFail(RbelTcpIpMessageFacet.class)).toBuilder().receivedFromRemoteWithUrl(this.remoteProxyClient.getRemoteProxyUrl()).build());
            res.addFacet((RbelFacet)this.response.getTracingDto().getProxyTransmissionHistoryResponse());
        }
        this.tigerPostConversionListener(req, res);
        TracingMessagePairFacet pairFacet = TracingMessagePairFacet.builder().response(res).request(req).build();
        res.addFacet((RbelFacet)pairFacet);
        if (log.isTraceEnabled()) {
            log.trace("{}Received pair to {} (UUIDs {} and {})", new Object[]{this.remoteProxyClient.proxyName(), req.printHttpDescription(), req.getUuid(), res.getUuid()});
        }
        this.remoteProxyClient.getLastMessageUuid().set(res.getUuid());
        if (this.remoteProxyClient.messageMatchesFilterCriterion(req) || this.remoteProxyClient.messageMatchesFilterCriterion(res)) {
            this.remoteProxyClient.propagateMessage(req);
            this.remoteProxyClient.propagateMessage(res);
        } else {
            this.remoteProxyClient.removeMessage(req);
            this.remoteProxyClient.removeMessage(res);
        }
    }

    private void tigerPostConversionListener(RbelElement req, RbelElement res) {
        RbelFileWriter.DEFAULT_POST_CONVERSION_LISTENER.forEach(listener -> {
            listener.performMessagePostConversionProcessing(req, this.remoteProxyClient.getRbelLogger().getRbelConverter(), new JSONObject(this.request.getAdditionalInformation()));
            listener.performMessagePostConversionProcessing(res, this.remoteProxyClient.getRbelLogger().getRbelConverter(), new JSONObject(this.response.getAdditionalInformation()));
        });
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TracingMessagePair(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }

    @Generated
    public PartialTracingMessage getRequest() {
        return this.request;
    }

    @Generated
    public PartialTracingMessage getResponse() {
        return this.response;
    }

    @Generated
    public TigerRemoteProxyClient getRemoteProxyClient() {
        return this.remoteProxyClient;
    }

    @Generated
    public void setRequest(PartialTracingMessage request) {
        this.request = request;
    }

    @Generated
    public void setResponse(PartialTracingMessage response) {
        this.response = response;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TracingMessagePair)) {
            return false;
        }
        TracingMessagePair other = (TracingMessagePair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PartialTracingMessage this$request = this.getRequest();
        PartialTracingMessage other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        PartialTracingMessage this$response = this.getResponse();
        PartialTracingMessage other$response = other.getResponse();
        if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
            return false;
        }
        TigerRemoteProxyClient this$remoteProxyClient = this.getRemoteProxyClient();
        TigerRemoteProxyClient other$remoteProxyClient = other.getRemoteProxyClient();
        return !(this$remoteProxyClient == null ? other$remoteProxyClient != null : !((Object)this$remoteProxyClient).equals(other$remoteProxyClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TracingMessagePair;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartialTracingMessage $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        PartialTracingMessage $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        TigerRemoteProxyClient $remoteProxyClient = this.getRemoteProxyClient();
        result = result * 59 + ($remoteProxyClient == null ? 43 : ((Object)$remoteProxyClient).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TracingMessagePair(request=" + String.valueOf(this.getRequest()) + ", response=" + String.valueOf(this.getResponse()) + ")";
    }
}

