/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessageFrame;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PartialTracingMessage {
    private final TigerTracingDto tracingDto;
    private final RbelHostname sender;
    private final RbelHostname receiver;
    private final TracingMessageFrame messageFrame;
    private final ZonedDateTime transmissionTime;
    private final ZonedDateTime receivedTime = ZonedDateTime.now();
    private final List<TracingMessagePart> messageParts = new ArrayList<TracingMessagePart>();
    private final Map<String, String> additionalInformation;
    private final boolean unparsedChunk;

    public boolean isComplete() {
        return !this.messageParts.isEmpty() && this.messageParts.get(0).getNumberOfMessages() == this.messageParts.size() && this.tracingDto != null;
    }

    public RbelContent buildCompleteContent() {
        if (this.messageParts.isEmpty()) {
            return RbelContent.builder().build();
        }
        return RbelContent.builder().chunkSize(Integer.valueOf(Math.max(this.messageParts.get(0).getData().length, 1024))).content(this.messageParts.stream().map(TracingMessagePart::getData).toList()).build();
    }

    @Generated
    private static Map<String, String> $default$additionalInformation() {
        return Map.of();
    }

    @Generated
    private static boolean $default$unparsedChunk() {
        return false;
    }

    @ConstructorProperties(value={"tracingDto", "sender", "receiver", "messageFrame", "transmissionTime", "additionalInformation", "unparsedChunk"})
    @Generated
    PartialTracingMessage(TigerTracingDto tracingDto, RbelHostname sender, RbelHostname receiver, TracingMessageFrame messageFrame, ZonedDateTime transmissionTime, Map<String, String> additionalInformation, boolean unparsedChunk) {
        this.tracingDto = tracingDto;
        this.sender = sender;
        this.receiver = receiver;
        this.messageFrame = messageFrame;
        this.transmissionTime = transmissionTime;
        this.additionalInformation = additionalInformation;
        this.unparsedChunk = unparsedChunk;
    }

    @Generated
    public static PartialTracingMessageBuilder builder() {
        return new PartialTracingMessageBuilder();
    }

    @Generated
    public PartialTracingMessageBuilder toBuilder() {
        return new PartialTracingMessageBuilder().tracingDto(this.tracingDto).sender(this.sender).receiver(this.receiver).messageFrame(this.messageFrame).transmissionTime(this.transmissionTime).additionalInformation(this.additionalInformation).unparsedChunk(this.unparsedChunk);
    }

    @Generated
    public TigerTracingDto getTracingDto() {
        return this.tracingDto;
    }

    @Generated
    public RbelHostname getSender() {
        return this.sender;
    }

    @Generated
    public RbelHostname getReceiver() {
        return this.receiver;
    }

    @Generated
    public TracingMessageFrame getMessageFrame() {
        return this.messageFrame;
    }

    @Generated
    public ZonedDateTime getTransmissionTime() {
        return this.transmissionTime;
    }

    @Generated
    public ZonedDateTime getReceivedTime() {
        return this.receivedTime;
    }

    @Generated
    public List<TracingMessagePart> getMessageParts() {
        return this.messageParts;
    }

    @Generated
    public Map<String, String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Generated
    public boolean isUnparsedChunk() {
        return this.unparsedChunk;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartialTracingMessage)) {
            return false;
        }
        PartialTracingMessage other = (PartialTracingMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUnparsedChunk() != other.isUnparsedChunk()) {
            return false;
        }
        TigerTracingDto this$tracingDto = this.getTracingDto();
        TigerTracingDto other$tracingDto = other.getTracingDto();
        if (this$tracingDto == null ? other$tracingDto != null : !((Object)this$tracingDto).equals(other$tracingDto)) {
            return false;
        }
        RbelHostname this$sender = this.getSender();
        RbelHostname other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        RbelHostname this$receiver = this.getReceiver();
        RbelHostname other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        TracingMessageFrame this$messageFrame = this.getMessageFrame();
        TracingMessageFrame other$messageFrame = other.getMessageFrame();
        if (this$messageFrame == null ? other$messageFrame != null : !this$messageFrame.equals(other$messageFrame)) {
            return false;
        }
        ZonedDateTime this$transmissionTime = this.getTransmissionTime();
        ZonedDateTime other$transmissionTime = other.getTransmissionTime();
        if (this$transmissionTime == null ? other$transmissionTime != null : !((Object)this$transmissionTime).equals(other$transmissionTime)) {
            return false;
        }
        ZonedDateTime this$receivedTime = this.getReceivedTime();
        ZonedDateTime other$receivedTime = other.getReceivedTime();
        if (this$receivedTime == null ? other$receivedTime != null : !((Object)this$receivedTime).equals(other$receivedTime)) {
            return false;
        }
        List<TracingMessagePart> this$messageParts = this.getMessageParts();
        List<TracingMessagePart> other$messageParts = other.getMessageParts();
        if (this$messageParts == null ? other$messageParts != null : !((Object)this$messageParts).equals(other$messageParts)) {
            return false;
        }
        Map<String, String> this$additionalInformation = this.getAdditionalInformation();
        Map<String, String> other$additionalInformation = other.getAdditionalInformation();
        return !(this$additionalInformation == null ? other$additionalInformation != null : !((Object)this$additionalInformation).equals(other$additionalInformation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PartialTracingMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUnparsedChunk() ? 79 : 97);
        TigerTracingDto $tracingDto = this.getTracingDto();
        result = result * 59 + ($tracingDto == null ? 43 : ((Object)$tracingDto).hashCode());
        RbelHostname $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        RbelHostname $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        TracingMessageFrame $messageFrame = this.getMessageFrame();
        result = result * 59 + ($messageFrame == null ? 43 : $messageFrame.hashCode());
        ZonedDateTime $transmissionTime = this.getTransmissionTime();
        result = result * 59 + ($transmissionTime == null ? 43 : ((Object)$transmissionTime).hashCode());
        ZonedDateTime $receivedTime = this.getReceivedTime();
        result = result * 59 + ($receivedTime == null ? 43 : ((Object)$receivedTime).hashCode());
        List<TracingMessagePart> $messageParts = this.getMessageParts();
        result = result * 59 + ($messageParts == null ? 43 : ((Object)$messageParts).hashCode());
        Map<String, String> $additionalInformation = this.getAdditionalInformation();
        result = result * 59 + ($additionalInformation == null ? 43 : ((Object)$additionalInformation).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PartialTracingMessage(sender=" + String.valueOf(this.getSender()) + ", receiver=" + String.valueOf(this.getReceiver()) + ", transmissionTime=" + String.valueOf(this.getTransmissionTime()) + ", receivedTime=" + String.valueOf(this.getReceivedTime()) + ", messageParts=" + String.valueOf(this.getMessageParts()) + ", additionalInformation=" + String.valueOf(this.getAdditionalInformation()) + ", unparsedChunk=" + this.isUnparsedChunk() + ")";
    }

    @Generated
    public static class PartialTracingMessageBuilder {
        @Generated
        private TigerTracingDto tracingDto;
        @Generated
        private RbelHostname sender;
        @Generated
        private RbelHostname receiver;
        @Generated
        private TracingMessageFrame messageFrame;
        @Generated
        private ZonedDateTime transmissionTime;
        @Generated
        private boolean additionalInformation$set;
        @Generated
        private Map<String, String> additionalInformation$value;
        @Generated
        private boolean unparsedChunk$set;
        @Generated
        private boolean unparsedChunk$value;

        @Generated
        PartialTracingMessageBuilder() {
        }

        @Generated
        public PartialTracingMessageBuilder tracingDto(TigerTracingDto tracingDto) {
            this.tracingDto = tracingDto;
            return this;
        }

        @Generated
        public PartialTracingMessageBuilder sender(RbelHostname sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public PartialTracingMessageBuilder receiver(RbelHostname receiver) {
            this.receiver = receiver;
            return this;
        }

        @Generated
        public PartialTracingMessageBuilder messageFrame(TracingMessageFrame messageFrame) {
            this.messageFrame = messageFrame;
            return this;
        }

        @Generated
        public PartialTracingMessageBuilder transmissionTime(ZonedDateTime transmissionTime) {
            this.transmissionTime = transmissionTime;
            return this;
        }

        @Generated
        public PartialTracingMessageBuilder additionalInformation(Map<String, String> additionalInformation) {
            this.additionalInformation$value = additionalInformation;
            this.additionalInformation$set = true;
            return this;
        }

        @Generated
        public PartialTracingMessageBuilder unparsedChunk(boolean unparsedChunk) {
            this.unparsedChunk$value = unparsedChunk;
            this.unparsedChunk$set = true;
            return this;
        }

        @Generated
        public PartialTracingMessage build() {
            Map<String, String> additionalInformation$value = this.additionalInformation$value;
            if (!this.additionalInformation$set) {
                additionalInformation$value = PartialTracingMessage.$default$additionalInformation();
            }
            boolean unparsedChunk$value = this.unparsedChunk$value;
            if (!this.unparsedChunk$set) {
                unparsedChunk$value = PartialTracingMessage.$default$unparsedChunk();
            }
            return new PartialTracingMessage(this.tracingDto, this.sender, this.receiver, this.messageFrame, this.transmissionTime, additionalInformation$value, unparsedChunk$value);
        }

        @Generated
        public String toString() {
            return "PartialTracingMessage.PartialTracingMessageBuilder(tracingDto=" + String.valueOf(this.tracingDto) + ", sender=" + String.valueOf(this.sender) + ", receiver=" + String.valueOf(this.receiver) + ", messageFrame=" + String.valueOf(this.messageFrame) + ", transmissionTime=" + String.valueOf(this.transmissionTime) + ", additionalInformation$value=" + String.valueOf(this.additionalInformation$value) + ", unparsedChunk$value=" + this.unparsedChunk$value + ")";
        }
    }
}

