/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.certificate;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.file.RbelFileWriter;
import lombok.Generated;

public final class TlsFacet
implements RbelFacet {
    private static final String TLS_VERSION = "tlsVersion";
    private static final String CIPHER_SUITE = "cipherSuite";
    private static final String CLIENT_TLS_CERTIFICATE_CHAIN = "clientTlsCertificateChain";
    private final RbelElement tlsVersion;
    private final RbelElement cipherSuite;
    private final RbelElement clientCertificateChain;
    private final RbelMultiMap<RbelElement> childElements;

    public static void init() {
        RbelFileWriter.DEFAULT_PRE_SAVE_LISTENER.add((el, json) -> {
            el.getFacet(TlsFacet.class).flatMap(facet -> facet.getTlsVersion().seekValue(String.class)).ifPresent(tlsVersion -> json.put(TLS_VERSION, tlsVersion));
            el.getFacet(TlsFacet.class).flatMap(facet -> facet.getCipherSuite().seekValue(String.class)).ifPresent(tlsVersion -> json.put(CIPHER_SUITE, tlsVersion));
        });
        RbelFileWriter.DEFAULT_POST_CONVERSION_LISTENER.add((msg, converter, json) -> {
            if (json.has(TLS_VERSION) && json.has(CIPHER_SUITE)) {
                msg.addOrReplaceFacet((RbelFacet)new TlsFacet(RbelElement.wrap((RbelElement)msg, (Object)json.getString(TLS_VERSION)), RbelElement.wrap((RbelElement)msg, (Object)json.getString(CIPHER_SUITE)), null));
                msg.getFacet(TracingMessagePairFacet.class).filter(pair -> pair.getResponse() == msg).map(TracingMessagePairFacet::getRequest).ifPresent(req -> req.addOrReplaceFacet((RbelFacet)new TlsFacet(RbelElement.wrap((RbelElement)req, (Object)json.getString(TLS_VERSION)), RbelElement.wrap((RbelElement)req, (Object)json.getString(CIPHER_SUITE)), null)));
            }
        });
    }

    public TlsFacet(RbelElement tlsVersion, RbelElement cipherSuite, RbelElement clientCertificateChain) {
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.clientCertificateChain = clientCertificateChain;
        this.childElements = new RbelMultiMap().with(TLS_VERSION, (Object)tlsVersion).with(CIPHER_SUITE, (Object)cipherSuite).withSkipIfNull(CLIENT_TLS_CERTIFICATE_CHAIN, (Object)clientCertificateChain);
    }

    @Generated
    public RbelElement getTlsVersion() {
        return this.tlsVersion;
    }

    @Generated
    public RbelElement getCipherSuite() {
        return this.cipherSuite;
    }

    @Generated
    public RbelElement getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    @Generated
    public RbelMultiMap<RbelElement> getChildElements() {
        return this.childElements;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TlsFacet)) {
            return false;
        }
        TlsFacet other = (TlsFacet)o;
        RbelElement this$tlsVersion = this.getTlsVersion();
        RbelElement other$tlsVersion = other.getTlsVersion();
        if (this$tlsVersion == null ? other$tlsVersion != null : !this$tlsVersion.equals(other$tlsVersion)) {
            return false;
        }
        RbelElement this$cipherSuite = this.getCipherSuite();
        RbelElement other$cipherSuite = other.getCipherSuite();
        if (this$cipherSuite == null ? other$cipherSuite != null : !this$cipherSuite.equals(other$cipherSuite)) {
            return false;
        }
        RbelElement this$clientCertificateChain = this.getClientCertificateChain();
        RbelElement other$clientCertificateChain = other.getClientCertificateChain();
        if (this$clientCertificateChain == null ? other$clientCertificateChain != null : !this$clientCertificateChain.equals(other$clientCertificateChain)) {
            return false;
        }
        RbelMultiMap<RbelElement> this$childElements = this.getChildElements();
        RbelMultiMap<RbelElement> other$childElements = other.getChildElements();
        return !(this$childElements == null ? other$childElements != null : !this$childElements.equals(other$childElements));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $tlsVersion = this.getTlsVersion();
        result = result * 59 + ($tlsVersion == null ? 43 : $tlsVersion.hashCode());
        RbelElement $cipherSuite = this.getCipherSuite();
        result = result * 59 + ($cipherSuite == null ? 43 : $cipherSuite.hashCode());
        RbelElement $clientCertificateChain = this.getClientCertificateChain();
        result = result * 59 + ($clientCertificateChain == null ? 43 : $clientCertificateChain.hashCode());
        RbelMultiMap<RbelElement> $childElements = this.getChildElements();
        result = result * 59 + ($childElements == null ? 43 : $childElements.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TlsFacet(tlsVersion=" + String.valueOf(this.getTlsVersion()) + ", cipherSuite=" + String.valueOf(this.getCipherSuite()) + ", clientCertificateChain=" + String.valueOf(this.getClientCertificateChain()) + ", childElements=" + String.valueOf(this.getChildElements()) + ")";
    }
}

