/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.common.data.config.tigerproxy.ForwardProxyInfo;
import de.gematik.test.tiger.common.web.InsecureTrustAllManager;
import de.gematik.test.tiger.util.NoProxyUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import lombok.Generated;

public class TigerRouteSelector {
    private final List<String> routeDestinations;
    private final ForwardProxyInfo forwardProxyInfo;

    public String selectFirstReachableDestination() {
        if (this.routeDestinations.isEmpty()) {
            throw new IllegalStateException("No route destinations provided");
        }
        if (this.routeDestinations.size() == 1) {
            return this.routeDestinations.get(0);
        }
        return this.routeDestinations.parallelStream().filter(this::isReachable).findAny().orElseThrow(() -> new IllegalStateException("No reachable destination found among " + String.valueOf(this.routeDestinations)));
    }

    private boolean isReachable(String destination) {
        try {
            InetAddress targetHost;
            HttpURLConnection connection = (HttpURLConnection)new URL(destination).openConnection();
            if (this.forwardProxyInfo != null && NoProxyUtils.shouldUseProxyForHost(targetHost = InetAddress.getByName(this.forwardProxyInfo.getHostname()), this.forwardProxyInfo.getNoProxyHosts())) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(targetHost, (int)this.forwardProxyInfo.getPort());
                connection = (HttpURLConnection)new URL(destination).openConnection(new Proxy(Proxy.Type.HTTP, inetSocketAddress));
            }
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("HEAD");
            InsecureTrustAllManager.allowAllSsl((URLConnection)connection);
            connection.connect();
            int responseCode = connection.getResponseCode();
            return responseCode != -1;
        }
        catch (IOException e) {
            return false;
        }
    }

    @ConstructorProperties(value={"routeDestinations", "forwardProxyInfo"})
    @Generated
    public TigerRouteSelector(List<String> routeDestinations, ForwardProxyInfo forwardProxyInfo) {
        this.routeDestinations = routeDestinations;
        this.forwardProxyInfo = forwardProxyInfo;
    }
}

