/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.TigerMasterSecretListeners;
import java.beans.ConstructorProperties;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HexFormat;
import lombok.Generated;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerProxyMasterSecretListener
implements TigerMasterSecretListeners {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxyMasterSecretListener.class);
    private final String masterSecretsFile;

    public void onMasterSecret(Object session) {
        if (session instanceof TlsContext) {
            TlsContext ctx = (TlsContext)session;
            SecurityParameters securityParametersConnection = ctx.getSecurityParametersConnection();
            log.info("Intercepted master secret, writing to file {}", (Object)this.masterSecretsFile);
            this.dumpToMasterSecretsFile("CLIENT_RANDOM " + HexFormat.of().formatHex(securityParametersConnection.getClientRandom()) + " " + HexFormat.of().formatHex(securityParametersConnection.getMasterSecret().extract()) + "\n");
        }
    }

    private void dumpToMasterSecretsFile(String line) {
        try {
            Files.write(Path.of(this.masterSecretsFile, new String[0]), line.getBytes(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            log.error("Failed to write master secret to file {}", (Object)this.masterSecretsFile, (Object)e);
        }
    }

    @ConstructorProperties(value={"masterSecretsFile"})
    @Generated
    public TigerProxyMasterSecretListener(String masterSecretsFile) {
        this.masterSecretsFile = masterSecretsFile;
    }
}

