/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.socket.tls;

import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import java.security.cert.Certificate;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SniHandler.class);
    public static final AttributeKey<SSLEngine> UPSTREAM_SSL_ENGINE = AttributeKey.valueOf((String)"UPSTREAM_SSL_ENGINE");
    public static final AttributeKey<SslHandler> UPSTREAM_SSL_HANDLER = AttributeKey.valueOf((String)"UPSTREAM_SSL_HANDLER");
    public static final AttributeKey<Certificate[]> UPSTREAM_CLIENT_CERTIFICATES = AttributeKey.valueOf((String)"UPSTREAM_CLIENT_CERTIFICATES");
    public static final AttributeKey<SSLSession> SSL_SESSION = AttributeKey.valueOf((String)"SSL_SESSION");
    public static final AttributeKey<HttpProtocol> NEGOTIATED_APPLICATION_PROTOCOL = AttributeKey.valueOf((String)"NEGOTIATED_APPLICATION_PROTOCOL");
    public static final AttributeKey<TigerPkiIdentity> SERVER_IDENTITY = AttributeKey.valueOf((String)"SERVER_IDENTITY");
    private final MockServerConfiguration configuration;
    private final NettySslContextFactory nettySslContextFactory;

    public SniHandler(MockServerConfiguration configuration, NettySslContextFactory nettySslContextFactory) {
        this.configuration = configuration;
        this.nettySslContextFactory = nettySslContextFactory;
    }

    protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) {
        if (StringUtils.isNotBlank((CharSequence)hostname)) {
            this.configuration.addSubjectAlternativeName(hostname);
        }
        Pair<SslContext, TigerPkiIdentity> serverContextAndIdentity = this.nettySslContextFactory.createServerSslContext(hostname);
        ctx.channel().attr(SERVER_IDENTITY).set((Object)((TigerPkiIdentity)serverContextAndIdentity.getValue()));
        return ctx.executor().newSucceededFuture((Object)((SslContext)serverContextAndIdentity.getKey()));
    }

    protected void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslContext> sslContextFuture) {
        if (!sslContextFuture.isSuccess()) {
            Throwable cause = sslContextFuture.cause();
            if (cause instanceof Error) {
                Error error = (Error)cause;
                throw error;
            }
            throw new DecoderException("Failed to get the SslContext for " + hostname, cause);
        }
        try {
            this.replaceHandler(ctx, sslContextFuture);
        }
        catch (RuntimeException cause) {
            PlatformDependent.throwException((Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceHandler(ChannelHandlerContext ctx, Future<SslContext> sslContextFuture) {
        SslHandler sslHandler = null;
        try {
            SslContext sslContext = (SslContext)sslContextFuture.getNow();
            sslHandler = sslContext.newHandler(ctx.alloc());
            SSLEngine sSLEngine = sslHandler.engine();
            if (sSLEngine instanceof OpenSslEngine) {
                OpenSslEngine openSslEngine = (OpenSslEngine)sSLEngine;
                if (this.configuration.ocspResponseSupplier() != null) {
                    try {
                        TigerPkiIdentity serverIdentity = (TigerPkiIdentity)ctx.channel().attr(SERVER_IDENTITY).get();
                        openSslEngine.setOcspResponse(this.configuration.ocspResponseSupplier().apply(serverIdentity.getCertificate()));
                    }
                    catch (Exception e) {
                        log.warn("Failed to set OCSP response", (Throwable)e);
                    }
                }
            }
            ctx.channel().attr(UPSTREAM_SSL_ENGINE).set((Object)sslHandler.engine());
            ctx.channel().attr(UPSTREAM_SSL_HANDLER).set((Object)sslHandler);
            ctx.pipeline().replace((ChannelHandler)this, "SslHandler#0", (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease((Object)sslHandler.engine());
            }
        }
    }

    public static Certificate[] retrieveClientCertificates(ChannelHandlerContext ctx) {
        SSLSession sslSession;
        SSLEngine sslEngine;
        Certificate[] clientCertificates = null;
        if (ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).get() != null) {
            clientCertificates = (Certificate[])ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).get();
        } else if (ctx.channel().attr(UPSTREAM_SSL_ENGINE).get() != null && (sslEngine = (SSLEngine)ctx.channel().attr(UPSTREAM_SSL_ENGINE).get()) != null && (sslSession = sslEngine.getSession()) != null) {
            try {
                ctx.channel().attr(SSL_SESSION).set((Object)sslSession);
                Certificate[] peerCertificates = sslSession.getPeerCertificates();
                ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).set((Object)peerCertificates);
                return peerCertificates;
            }
            catch (SSLPeerUnverifiedException ignore) {
                log.trace("no client certificate chain as client did not complete mTLS");
            }
        }
        return clientCertificates;
    }

    public static Optional<HttpProtocol> getAlpnProtocol(ChannelHandlerContext ctx) {
        try {
            if (ctx == null || ctx.channel() == null) {
                return Optional.empty();
            }
            if (ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).get() != null) {
                return Optional.ofNullable((HttpProtocol)((Object)ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).get()));
            }
            if (ctx.channel().attr(UPSTREAM_SSL_HANDLER).get() == null) {
                return Optional.empty();
            }
            HttpProtocol protocol = null;
            SslHandler sslHandler = (SslHandler)ctx.channel().attr(UPSTREAM_SSL_HANDLER).get();
            String negotiatedApplicationProtocol = sslHandler.applicationProtocol();
            if (StringUtils.isNotBlank((CharSequence)negotiatedApplicationProtocol)) {
                if (negotiatedApplicationProtocol.equalsIgnoreCase("h2")) {
                    protocol = HttpProtocol.HTTP_2;
                } else if (negotiatedApplicationProtocol.equalsIgnoreCase("http/1.1")) {
                    protocol = HttpProtocol.HTTP_1_1;
                }
                ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).set((Object)protocol);
                log.trace("found ALPN protocol:{}", (Object)negotiatedApplicationProtocol);
            }
            return Optional.ofNullable(protocol);
        }
        catch (RuntimeException throwable) {
            log.warn("exception reading ALPN protocol", (Throwable)throwable);
            return Optional.empty();
        }
    }
}

