/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.proxyconfiguration;

import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ProxyConfiguration
extends ObjectWithJsonToString {
    private final Type type;
    private final InetSocketAddress proxyAddress;
    private final String username;
    private final String password;
    private final List<String> noProxyHosts = new ArrayList<String>();

    private ProxyConfiguration(Type type, InetSocketAddress proxyAddress, String username, String password) {
        this.type = type;
        this.proxyAddress = proxyAddress;
        this.username = username;
        this.password = password;
    }

    public static ProxyConfiguration proxyConfiguration(Type type, String address) {
        return ProxyConfiguration.proxyConfiguration(type, address, null, null);
    }

    public static ProxyConfiguration proxyConfiguration(Type type, InetSocketAddress address) {
        return ProxyConfiguration.proxyConfiguration(type, address, null, null);
    }

    public static ProxyConfiguration proxyConfiguration(Type type, String address, String username, String password) {
        String[] addressParts = address.split(":");
        if (addressParts.length != 2) {
            throw new IllegalArgumentException("Proxy address must be in the format <host>:<ip>, for example 127.0.0.1:9090 or localhost:9090");
        }
        try {
            return ProxyConfiguration.proxyConfiguration(type, new InetSocketAddress(addressParts[0], Integer.parseInt(addressParts[1])), username, password);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Proxy address port \"" + addressParts[1] + "\" into an integer");
        }
    }

    public static ProxyConfiguration proxyConfiguration(Type type, InetSocketAddress address, String username, String password) {
        return new ProxyConfiguration(type, address, username, password);
    }

    public ProxyConfiguration addProxyAuthenticationHeader(HttpRequest httpRequest) {
        if (StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password)) {
            httpRequest.withHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), "Basic " + Base64.encode((ByteBuf)Unpooled.copiedBuffer((CharSequence)(this.username + ":" + this.password), (Charset)StandardCharsets.UTF_8), (boolean)false).toString(StandardCharsets.US_ASCII));
        }
        return this;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<String> getNoProxyHosts() {
        return this.noProxyHosts;
    }

    public static enum Type {
        HTTP,
        HTTPS,
        SOCKS5;

    }
}

