/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.mock.HttpState;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.netty.MockServer;
import de.gematik.test.tiger.mockserver.netty.proxy.connect.HttpConnectHandler;
import de.gematik.test.tiger.mockserver.netty.responsewriter.NettyResponseWriter;
import de.gematik.test.tiger.mockserver.netty.unification.PortUnificationHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpRequestHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHandler.class);
    public static final AttributeKey<Boolean> PROXYING = AttributeKey.valueOf((String)"PROXYING");
    public static final AttributeKey<Set<String>> LOCAL_HOST_HEADERS = AttributeKey.valueOf((String)"LOCAL_HOST_HEADERS");
    private HttpState httpState;
    private final MockServerConfiguration configuration;
    private MockServer server;
    private HttpActionHandler httpActionHandler;

    public HttpRequestHandler(MockServerConfiguration configuration, MockServer server, HttpState httpState, HttpActionHandler httpActionHandler) {
        super(false);
        this.configuration = configuration;
        this.server = server;
        this.httpState = httpState;
        this.httpActionHandler = httpActionHandler;
    }

    private static boolean isProxyingRequest(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(PROXYING).get() != null) {
            return (Boolean)ctx.channel().attr(PROXYING).get();
        }
        return false;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        NettyResponseWriter responseWriter = new NettyResponseWriter(this.configuration, ctx);
        try {
            this.configuration.addSubjectAlternativeName(request.getFirstHeader(HttpHeaderNames.HOST.toString()));
            if (!this.httpState.handle(request)) {
                if (request.getMethod().equals("CONNECT")) {
                    this.openProxyChannel(ctx, request);
                } else {
                    this.httpActionHandler.processAction(request, responseWriter, ctx, HttpRequestHandler.isProxyingRequest(ctx), false);
                }
            }
        }
        catch (Exception ex) {
            log.error("exception processing {}", (Object)request, (Object)ex);
            responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(HttpResponseStatus.BAD_REQUEST.code()).withBody(Optional.ofNullable(ex.getMessage()).map(e -> e.getBytes(StandardCharsets.UTF_8)).orElse("<null>".getBytes())));
        }
    }

    private void openProxyChannel(ChannelHandlerContext ctx, HttpRequest request) {
        ctx.channel().attr(PROXYING).set((Object)Boolean.TRUE);
        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
        log.info("Opening Proxy Channel, enabling SSL for {}", (Object)request.getPath());
        if (StringUtils.isNotBlank((CharSequence)request.getPath())) {
            this.server.getScheduler().submit(() -> this.configuration.addSubjectAlternativeName(request.getPath()));
        }
        String[] hostParts = request.getPath().split(":");
        int port = HttpRequestHandler.determinePort(ctx, hostParts);
        ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler(this.configuration, this.server, hostParts[0], port)});
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)request);
    }

    private static int determinePort(ChannelHandlerContext ctx, String[] hostParts) {
        int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : (PortUnificationHandler.isSslEnabledUpstream(ctx.channel()) ? 443 : 80);
        return port;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            log.error("exception caught by {} handler -> closing pipeline {}", new Object[]{this.server.getClass(), ctx.channel(), cause});
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

