/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Multimap;
import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpMessage;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpStatusCode;
import de.gematik.test.tiger.mockserver.netty.responsewriter.NettyResponseWriter;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class HttpResponse
extends HttpMessage<HttpResponse>
implements Action {
    private int hashCode;
    private Integer statusCode;
    private String reasonPhrase;
    private Headers headers;
    private Integer streamId = null;
    private String expectationId;

    public static HttpResponse response() {
        return new HttpResponse();
    }

    public static HttpResponse notFoundResponse() {
        return new HttpResponse().withStatusCode(HttpStatusCode.NOT_FOUND_404.code()).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase());
    }

    public HttpResponse withStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        this.hashCode = 0;
        return this;
    }

    public HttpResponse withReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        this.hashCode = 0;
        return this;
    }

    private Headers getOrCreateHeaders() {
        if (this.headers == null) {
            this.headers = new Headers(new Header[0]);
            this.hashCode = 0;
        }
        return this.headers;
    }

    @Override
    public HttpResponse withBody(byte[] body) {
        this.setBody(body);
        return this;
    }

    @Override
    public HttpResponse withHeaders(Headers headers) {
        this.headers = headers == null || headers.isEmpty() ? null : headers;
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withHeader(Header header) {
        this.getOrCreateHeaders().withEntry(header);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withHeader(String name, String ... values) {
        if (values.length == 0) {
            values = new String[]{".*"};
        }
        this.getOrCreateHeaders().withEntry(name, values);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse replaceHeader(Header header) {
        this.getOrCreateHeaders().replaceEntry(header);
        this.hashCode = 0;
        return this;
    }

    @Override
    public List<Header> getHeaderList() {
        if (this.headers != null) {
            return this.headers.getEntries();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getHeader(String name) {
        if (this.headers != null) {
            return this.headers.getValues(name);
        }
        return Collections.emptyList();
    }

    @Override
    public String getFirstHeader(String name) {
        if (this.headers != null) {
            return this.headers.getFirstValue(name);
        }
        return "";
    }

    @Override
    public HttpResponse removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
            this.hashCode = 0;
        }
        return this;
    }

    public boolean containsHeader(String name, String value) {
        if (this.headers != null) {
            return this.headers.containsEntry(name, value);
        }
        return false;
    }

    public HttpResponse withStreamId(Integer streamId) {
        this.streamId = streamId;
        this.hashCode = 0;
        return this;
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.RESPONSE;
    }

    @Override
    public void write(NettyResponseWriter nettyResponseWriter, HttpRequest request) {
        nettyResponseWriter.writeHttpResponse(request, this);
    }

    public Multimap<String, String> getHeaderMultimap() {
        return this.headers.getMultimap();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHashCode() != other.getHashCode()) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        Integer this$streamId = this.getStreamId();
        Integer other$streamId = other.getStreamId();
        if (this$streamId == null ? other$streamId != null : !((Object)this$streamId).equals(other$streamId)) {
            return false;
        }
        String this$reasonPhrase = this.getReasonPhrase();
        String other$reasonPhrase = other.getReasonPhrase();
        if (this$reasonPhrase == null ? other$reasonPhrase != null : !this$reasonPhrase.equals(other$reasonPhrase)) {
            return false;
        }
        Headers this$headers = this.getHeaders();
        Headers other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$expectationId = this.getExpectationId();
        String other$expectationId = other.getExpectationId();
        return !(this$expectationId == null ? other$expectationId != null : !this$expectationId.equals(other$expectationId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHashCode();
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        Integer $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : ((Object)$streamId).hashCode());
        String $reasonPhrase = this.getReasonPhrase();
        result = result * 59 + ($reasonPhrase == null ? 43 : $reasonPhrase.hashCode());
        Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $expectationId = this.getExpectationId();
        result = result * 59 + ($expectationId == null ? 43 : $expectationId.hashCode());
        return result;
    }

    @Generated
    public HttpResponse() {
    }

    @Generated
    public int getHashCode() {
        return this.hashCode;
    }

    @Generated
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    @Generated
    public Headers getHeaders() {
        return this.headers;
    }

    @Generated
    public Integer getStreamId() {
        return this.streamId;
    }

    @Override
    @Generated
    public String getExpectationId() {
        return this.expectationId;
    }

    @Generated
    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    @Generated
    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    @Generated
    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    @Generated
    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    @Generated
    public void setStreamId(Integer streamId) {
        this.streamId = streamId;
    }

    @Generated
    public void setExpectationId(String expectationId) {
        this.expectationId = expectationId;
    }

    @Override
    @Generated
    public String toString() {
        return "HttpResponse(hashCode=" + this.getHashCode() + ", statusCode=" + this.getStatusCode() + ", reasonPhrase=" + this.getReasonPhrase() + ", headers=" + String.valueOf(this.getHeaders()) + ", streamId=" + this.getStreamId() + ", expectationId=" + this.getExpectationId() + ")";
    }
}

