/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import de.gematik.test.tiger.mockserver.mock.HttpAction;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationCallback;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.TigerProxyRoute;
import de.gematik.test.tiger.proxy.handler.ForwardProxyCallback;
import de.gematik.test.tiger.proxy.handler.ReverseProxyCallback;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expectation
extends ObjectWithJsonToString
implements Comparable<Expectation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Expectation.class);
    private static final int BASE_PRIORITY_FORWARD_ROUTE = 1000000;
    private final String id;
    private TigerProxyRoute tigerRoute;
    private final int priority;
    private final HttpRequest requestPattern;
    private final HttpAction httpAction;
    private final List<String> hostRegexes;
    private final boolean ignorePortsInHostHeader;
    private final ExpectationCallback expectationCallback;

    public Expectation(HttpRequest requestPattern, String id, int priority, List<String> hostRegexes, ExpectationCallback expectationCallback) {
        this.requestPattern = requestPattern;
        this.priority = priority;
        this.id = id == null ? UUID.randomUUID().toString() : id;
        if (hostRegexes == null) {
            this.hostRegexes = List.of();
            this.ignorePortsInHostHeader = true;
        } else {
            this.hostRegexes = hostRegexes.stream().map(String::trim).toList();
            this.ignorePortsInHostHeader = hostRegexes.stream().noneMatch(h -> h.contains(":"));
        }
        this.expectationCallback = expectationCallback;
        this.httpAction = HttpAction.of(new HttpOverrideForwardedRequest()).setExpectationForwardAndResponseCallback(expectationCallback);
    }

    public static Expectation buildReverseProxyRoute(TigerProxyRoute tigerRoute, TigerProxy tigerProxy) {
        return Expectation.builder().requestPattern(HttpRequest.request().setPath(Expectation.addTrailingSlashIfMissing(tigerRoute.getFrom())).setForwardProxyRequest(false)).priority(0).hostRegexes(tigerRoute.getHosts()).id(tigerRoute.getId()).expectationCallback(new ReverseProxyCallback(tigerProxy, tigerRoute)).build();
    }

    public static Expectation buildForwardProxyRoute(TigerProxyRoute tigerRoute, TigerProxy tigerProxy) {
        URL url = tigerRoute.retrieveFromUrl();
        return Expectation.builder().requestPattern(HttpRequest.request().withHeader("Host", url.getAuthority()).setForwardProxyRequest(true).setSecure(url.getProtocol().equals("https")).setPath(Expectation.addTrailingSlashIfMissing(Expectation.extractPath(tigerRoute.getFrom())))).priority(1000000).hostRegexes(tigerRoute.getHosts()).id(tigerRoute.getId()).expectationCallback(new ForwardProxyCallback(tigerProxy, tigerRoute)).build();
    }

    private static String extractPath(String url) {
        return new URI(url).getPath();
    }

    public boolean matches(HttpRequest request) {
        return this.protocolMatches(this.requestPattern.getProtocol(), request.getProtocol()) && this.proxyingMatches(request) && this.secureMatches(request) && this.hostMatches(request) && this.pathMatches(this.requestPattern.getPath(), Expectation.addTrailingSlashIfMissing(request.getPath())) && (this.expectationCallback == null || this.expectationCallback.matches(request));
    }

    private boolean proxyingMatches(HttpRequest request) {
        boolean proxyingMatches;
        if (this.tigerRoute != null && !this.tigerRoute.isMatchForProxyType()) {
            return true;
        }
        boolean bl = proxyingMatches = request.isForwardProxyRequest() == this.requestPattern.isForwardProxyRequest();
        if (!proxyingMatches) {
            log.atTrace().addArgument(request::getForwardProxyRequest).addArgument(() -> Optional.ofNullable(this.tigerRoute).map(TigerProxyRoute::createShortDescription).orElse("<>")).addArgument(this.requestPattern::getForwardProxyRequest).log("Proxying technique doesnt match: Request is forward? ({}), while route {} is forward? ({})");
        }
        return proxyingMatches;
    }

    private boolean secureMatches(HttpRequest request) {
        if (this.requestPattern.isSecure() == null || request.isSecure() == null) {
            return true;
        }
        boolean equals = Objects.equals(this.requestPattern.isSecure(), request.isSecure());
        if (!equals) {
            log.atTrace().addArgument(request::isSecure).addArgument(() -> {
                if (this.tigerRoute == null) {
                    return null;
                }
                return this.tigerRoute.createShortDescription();
            }).log("secure [{}] is not matching for route {}");
        }
        return equals;
    }

    private boolean hostMatches(HttpRequest request) {
        String cleanedPatternHostHeader;
        if (!this.requestPattern.getHeaders().containsEntry("Host") && (this.hostRegexes == null || this.hostRegexes.isEmpty())) {
            return true;
        }
        String cleanedHostHeader = this.ignorePortsInHostHeader ? request.getFirstHeader("Host").trim().split(":")[0] : request.getFirstHeader("Host").trim();
        String string = cleanedPatternHostHeader = this.ignorePortsInHostHeader ? this.requestPattern.getFirstHeader("Host").split(":")[0] : this.requestPattern.getFirstHeader("Host");
        if (StringUtils.equals((CharSequence)cleanedPatternHostHeader, (CharSequence)cleanedHostHeader)) {
            return true;
        }
        boolean anyHostHeaderMatch = this.hostRegexes.stream().anyMatch(hostMatchCriterion -> cleanedHostHeader.equalsIgnoreCase((String)hostMatchCriterion) || cleanedHostHeader.toLowerCase().matches(hostMatchCriterion.toLowerCase()));
        if (!anyHostHeaderMatch) {
            log.atTrace().addArgument(() -> cleanedHostHeader).addArgument(this.tigerRoute::createShortDescription).addArgument((Object)this.ignorePortsInHostHeader).log("host [{}] is not matching for route {} ({})");
        }
        return anyHostHeaderMatch;
    }

    private boolean protocolMatches(HttpProtocol protocol, HttpProtocol otherProtocol) {
        if (protocol == null) {
            return true;
        }
        if (protocol.equals((Object)otherProtocol)) {
            return true;
        }
        log.atTrace().addArgument((Object)protocol).addArgument((Object)otherProtocol).addArgument(this.tigerRoute::createShortDescription).log("protocol [{}] is not matching [{}] for route {}");
        return false;
    }

    public boolean pathMatches(String blueprint, String actualValue) {
        if (blueprint == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)blueprint)) {
            return true;
        }
        if (actualValue.startsWith(blueprint)) {
            return true;
        }
        log.atTrace().addArgument((Object)actualValue).addArgument(() -> {
            if (this.tigerRoute == null) {
                return "<null>";
            }
            return this.tigerRoute.createShortDescription();
        }).log("path [{}] is not matching for route {}");
        return false;
    }

    @Override
    public int compareTo(Expectation o) {
        String otherPath;
        if (o == null) {
            return 1;
        }
        if (this.priority != o.priority) {
            return Integer.compare(o.priority, this.priority);
        }
        if (this.requestPattern == null || o.requestPattern == null || this.requestPattern.getPath() == null || o.requestPattern.getPath() == null) {
            return 0;
        }
        String thisPath = this.requestPattern.getPath();
        if (Expectation.uriTwoIsBelowUriOne(thisPath, otherPath = o.requestPattern.getPath())) {
            return -1;
        }
        if (Expectation.uriTwoIsBelowUriOne(otherPath, thisPath)) {
            return 1;
        }
        Integer otherHostSize = Optional.ofNullable(o.hostRegexes).map(List::size).orElse(0);
        Integer thisHostSize = Optional.ofNullable(this.hostRegexes).map(List::size).orElse(0);
        return Integer.compare(otherHostSize, thisHostSize);
    }

    public static boolean uriTwoIsBelowUriOne(String uri1, String uri2) {
        try {
            URIBuilder base = new URIBuilder(uri2);
            URIBuilder sub = new URIBuilder(uri1);
            URI baseUri = base.build().normalize();
            URI subUri = sub.build().normalize();
            return subUri.getPath().startsWith(baseUri.getPath()) && !baseUri.equals(subUri);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private static String addTrailingSlashIfMissing(String from) {
        if (from.endsWith("/")) {
            return from;
        }
        return from + "/";
    }

    public String createShortDescription() {
        if (this.tigerRoute != null) {
            return this.tigerRoute.createShortDescription();
        }
        return this.requestPattern.printLogLineDescription();
    }

    @Generated
    public static ExpectationBuilder builder() {
        return new ExpectationBuilder();
    }

    @Generated
    public ExpectationBuilder toBuilder() {
        return new ExpectationBuilder().requestPattern(this.requestPattern).id(this.id).priority(this.priority).hostRegexes(this.hostRegexes).expectationCallback(this.expectationCallback);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expectation)) {
            return false;
        }
        Expectation other = (Expectation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.isIgnorePortsInHostHeader() != other.isIgnorePortsInHostHeader()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TigerProxyRoute this$tigerRoute = this.getTigerRoute();
        TigerProxyRoute other$tigerRoute = other.getTigerRoute();
        if (this$tigerRoute == null ? other$tigerRoute != null : !((Object)this$tigerRoute).equals(other$tigerRoute)) {
            return false;
        }
        HttpRequest this$requestPattern = this.getRequestPattern();
        HttpRequest other$requestPattern = other.getRequestPattern();
        if (this$requestPattern == null ? other$requestPattern != null : !((Object)this$requestPattern).equals(other$requestPattern)) {
            return false;
        }
        HttpAction this$httpAction = this.getHttpAction();
        HttpAction other$httpAction = other.getHttpAction();
        if (this$httpAction == null ? other$httpAction != null : !((Object)this$httpAction).equals(other$httpAction)) {
            return false;
        }
        List<String> this$hostRegexes = this.getHostRegexes();
        List<String> other$hostRegexes = other.getHostRegexes();
        if (this$hostRegexes == null ? other$hostRegexes != null : !((Object)this$hostRegexes).equals(other$hostRegexes)) {
            return false;
        }
        ExpectationCallback this$expectationCallback = this.getExpectationCallback();
        ExpectationCallback other$expectationCallback = other.getExpectationCallback();
        return !(this$expectationCallback == null ? other$expectationCallback != null : !this$expectationCallback.equals(other$expectationCallback));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Expectation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        result = result * 59 + (this.isIgnorePortsInHostHeader() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TigerProxyRoute $tigerRoute = this.getTigerRoute();
        result = result * 59 + ($tigerRoute == null ? 43 : ((Object)$tigerRoute).hashCode());
        HttpRequest $requestPattern = this.getRequestPattern();
        result = result * 59 + ($requestPattern == null ? 43 : ((Object)$requestPattern).hashCode());
        HttpAction $httpAction = this.getHttpAction();
        result = result * 59 + ($httpAction == null ? 43 : ((Object)$httpAction).hashCode());
        List<String> $hostRegexes = this.getHostRegexes();
        result = result * 59 + ($hostRegexes == null ? 43 : ((Object)$hostRegexes).hashCode());
        ExpectationCallback $expectationCallback = this.getExpectationCallback();
        result = result * 59 + ($expectationCallback == null ? 43 : $expectationCallback.hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public TigerProxyRoute getTigerRoute() {
        return this.tigerRoute;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public HttpRequest getRequestPattern() {
        return this.requestPattern;
    }

    @Generated
    public HttpAction getHttpAction() {
        return this.httpAction;
    }

    @Generated
    public List<String> getHostRegexes() {
        return this.hostRegexes;
    }

    @Generated
    public boolean isIgnorePortsInHostHeader() {
        return this.ignorePortsInHostHeader;
    }

    @Generated
    public ExpectationCallback getExpectationCallback() {
        return this.expectationCallback;
    }

    @Generated
    public Expectation setTigerRoute(TigerProxyRoute tigerRoute) {
        this.tigerRoute = tigerRoute;
        return this;
    }

    @Generated
    public static class ExpectationBuilder {
        @Generated
        private HttpRequest requestPattern;
        @Generated
        private String id;
        @Generated
        private int priority;
        @Generated
        private List<String> hostRegexes;
        @Generated
        private ExpectationCallback expectationCallback;

        @Generated
        ExpectationBuilder() {
        }

        @Generated
        public ExpectationBuilder requestPattern(HttpRequest requestPattern) {
            this.requestPattern = requestPattern;
            return this;
        }

        @Generated
        public ExpectationBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ExpectationBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public ExpectationBuilder hostRegexes(List<String> hostRegexes) {
            this.hostRegexes = hostRegexes;
            return this;
        }

        @Generated
        public ExpectationBuilder expectationCallback(ExpectationCallback expectationCallback) {
            this.expectationCallback = expectationCallback;
            return this;
        }

        @Generated
        public Expectation build() {
            return new Expectation(this.requestPattern, this.id, this.priority, this.hostRegexes, this.expectationCallback);
        }

        @Generated
        public String toString() {
            return "Expectation.ExpectationBuilder(requestPattern=" + String.valueOf(this.requestPattern) + ", id=" + this.id + ", priority=" + this.priority + ", hostRegexes=" + String.valueOf(this.hostRegexes) + ", expectationCallback=" + String.valueOf(this.expectationCallback) + ")";
        }
    }
}

