/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mappers;

import de.gematik.test.tiger.mockserver.codec.BodyDecoderEncoder;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.Parameter;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerHttpRequestToFullHttpRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServerHttpRequestToFullHttpRequest.class);
    private final ProxyConfiguration proxyConfiguration;
    private final BodyDecoderEncoder bodyDecoderEncoder;

    public MockServerHttpRequestToFullHttpRequest(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        this.bodyDecoderEncoder = new BodyDecoderEncoder();
    }

    public FullHttpRequest mapMockServerRequestToNettyRequest(HttpRequest httpRequest) {
        HttpMethod httpMethod = HttpMethod.valueOf((String)httpRequest.getMethodOrDefault("GET"));
        try {
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, this.getURI(httpRequest, this.proxyConfiguration), this.getBody(httpRequest));
            this.setHeader(httpRequest, (FullHttpRequest)request);
            return request;
        }
        catch (RuntimeException throwable) {
            log.error("exception encoding request {}", (Object)httpRequest, (Object)throwable);
            return new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, this.getURI(httpRequest, this.proxyConfiguration));
        }
    }

    public String getURI(HttpRequest httpRequest, ProxyConfiguration proxyConfiguration) {
        Object uri = "";
        if (httpRequest.getPath() != null) {
            if (httpRequest.getQueryStringParameters() != null && StringUtils.isNotBlank((CharSequence)httpRequest.getQueryStringParameters().getRawParameterString())) {
                uri = httpRequest.getPath() + "?" + httpRequest.getQueryStringParameters().getRawParameterString();
            } else {
                QueryStringEncoder queryStringEncoder = new QueryStringEncoder(httpRequest.getPath());
                for (Parameter parameter : httpRequest.getQueryStringParameterList()) {
                    for (String value : parameter.getValues()) {
                        queryStringEncoder.addParam(parameter.getName(), value);
                    }
                }
                uri = queryStringEncoder.toString();
            }
        }
        if (proxyConfiguration != null && proxyConfiguration.getType() == ProxyConfiguration.Type.HTTP && !Boolean.TRUE.equals(httpRequest.isSecure())) {
            if (StringUtils.isNotBlank((CharSequence)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
                uri = "http://" + httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()) + (String)uri;
            } else if (httpRequest.getReceiverAddress() != null) {
                uri = "http://" + String.valueOf(httpRequest.getReceiverAddress()) + (String)uri;
            }
        }
        return uri;
    }

    private ByteBuf getBody(HttpRequest httpRequest) {
        return this.bodyDecoderEncoder.bodyToByteBuf(httpRequest.getBody());
    }

    private void setHeader(HttpRequest httpRequest, FullHttpRequest request) {
        for (Header header : httpRequest.getHeaderList()) {
            String headerName = header.getName();
            if (headerName.equalsIgnoreCase(HttpHeaderNames.CONTENT_LENGTH.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.TRANSFER_ENCODING.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.HOST.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.ACCEPT_ENCODING.toString())) continue;
            if (!header.getValues().isEmpty()) {
                for (String headerValue : header.getValues()) {
                    request.headers().add(headerName, (Object)headerValue);
                }
                continue;
            }
            request.headers().add(headerName, (Object)"");
        }
        if (StringUtils.isNotBlank((CharSequence)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()));
        }
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)(String.valueOf(HttpHeaderValues.GZIP) + "," + String.valueOf(HttpHeaderValues.DEFLATE)));
        if (HttpProtocol.HTTP_2.equals((Object)httpRequest.getProtocol())) {
            HttpScheme scheme = Boolean.TRUE.equals(httpRequest.isSecure()) ? HttpScheme.HTTPS : HttpScheme.HTTP;
            request.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme.name());
            Integer streamId = httpRequest.getStreamId();
            if (streamId != null) {
                request.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
            }
        }
        if (request.content().readableBytes() > 0) {
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)request.content().readableBytes());
        }
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        }
    }
}

