/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.httpclient.BinaryRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.ClientBootstrapFactory;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientInitializer;
import de.gematik.test.tiger.mockserver.httpclient.HttpRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.SocketConnectionException;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.Message;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import de.gematik.test.tiger.util.NoProxyUtils;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyHttpClient.class);
    static final AttributeKey<Boolean> SECURE = AttributeKey.valueOf((String)"SECURE");
    static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf((String)"REMOTE_SOCKET");
    public static final AttributeKey<CompletableFuture<Message>> RESPONSE_FUTURE = AttributeKey.valueOf((String)"RESPONSE_FUTURE");
    public static final AttributeKey<Boolean> ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE = AttributeKey.valueOf((String)"ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE");
    private final MockServerConfiguration configuration;
    private final EventLoopGroup eventLoopGroup;
    private final ProxyConfiguration proxyConfiguration;
    private final NettySslContextFactory nettySslContextFactory;
    private final ClientBootstrapFactory clientBootstrapFactory;

    public NettyHttpClient(MockServerConfiguration configuration, EventLoopGroup eventLoopGroup, NettySslContextFactory nettySslContextFactory) {
        this.configuration = configuration;
        this.eventLoopGroup = eventLoopGroup;
        this.proxyConfiguration = configuration.proxyConfiguration();
        this.nettySslContextFactory = nettySslContextFactory;
        this.clientBootstrapFactory = new ClientBootstrapFactory(configuration, eventLoopGroup);
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequestInfo requestInfo, Long customTimeout) {
        if (requestInfo.getRemoteServerAddress() == null) {
            requestInfo.setRemoteServerAddress(((HttpRequest)requestInfo.getDataToSend()).socketAddressFromHostHeader());
        }
        if (this.eventLoopGroup.isShuttingDown()) {
            throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
        }
        if (this.shouldUseProxy(requestInfo.getRemoteServerAddress())) {
            this.modifyProxyInformation(requestInfo);
        }
        if (HttpProtocol.HTTP_2.equals((Object)((HttpRequest)requestInfo.getDataToSend()).getProtocol()) && Boolean.FALSE.equals(((HttpRequest)requestInfo.getDataToSend()).isSecure())) {
            log.warn("HTTP2 requires ALPN but request is not secure (i.e. TLS) so protocol changed to HTTP1");
            ((HttpRequest)requestInfo.getDataToSend()).setProtocol(HttpProtocol.HTTP_1_1);
        }
        CompletableFuture<HttpResponse> httpResponseFuture = new CompletableFuture<HttpResponse>();
        CompletableFuture<Message> responseFuture = new CompletableFuture<Message>();
        HttpProtocol httpProtocol = ((HttpRequest)requestInfo.getDataToSend()).getProtocol() != null ? ((HttpRequest)requestInfo.getDataToSend()).getProtocol() : HttpProtocol.HTTP_1_1;
        HttpClientInitializer clientInitializer = this.createClientInitializer(httpProtocol);
        Boolean isSecure = Optional.ofNullable(((HttpRequest)requestInfo.getDataToSend()).isSecure()).orElse(false);
        ChannelFutureListener onCreationListener = future -> {
            if (future.isSuccess()) {
                clientInitializer.whenComplete((protocol, throwable) -> {
                    if (throwable != null) {
                        httpResponseFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        log.trace("sending request: {}", (Object)((HttpRequest)requestInfo.getDataToSend()).printLogLineDescription());
                        future.channel().writeAndFlush(requestInfo.getDataToSend());
                    }
                });
            } else {
                httpResponseFuture.completeExceptionally(future.cause());
            }
        };
        ChannelFutureListener onReuseListener = future -> {
            if (future.isSuccess()) {
                log.trace("sending request: {}", (Object)((HttpRequest)requestInfo.getDataToSend()).printLogLineDescription());
                future.channel().writeAndFlush(requestInfo.getDataToSend());
            } else {
                httpResponseFuture.completeExceptionally(future.cause());
            }
        };
        this.clientBootstrapFactory.configureChannel().isSecure(isSecure).requestInfo(requestInfo).clientInitializer(clientInitializer).errorIfChannelClosedWithoutResponse(true).responseFuture(responseFuture).timeoutInMilliseconds(customTimeout).onCreationListener(onCreationListener).onReuseListener(onReuseListener).connectToChannel();
        responseFuture.whenComplete((message, throwable) -> {
            if (throwable == null) {
                if (message != null) {
                    httpResponseFuture.complete((HttpResponse)message);
                } else {
                    httpResponseFuture.complete(HttpResponse.response());
                }
            } else {
                httpResponseFuture.completeExceptionally((Throwable)throwable);
            }
        });
        return httpResponseFuture;
    }

    private void modifyProxyInformation(HttpRequestInfo requestInfo) {
        if (this.proxyConfiguration != null && Boolean.FALSE.equals(((HttpRequest)requestInfo.getDataToSend()).isSecure())) {
            requestInfo.setRemoteServerAddress(this.proxyConfiguration.getProxyAddress());
            String remoteAddress = requestInfo.getRemoteServerAddress().getHostString() + ":" + requestInfo.getRemoteServerAddress().getPort();
            ((HttpRequest)requestInfo.getDataToSend()).setSenderAddress(remoteAddress);
            this.proxyConfiguration.addProxyAuthenticationHeader((HttpRequest)requestInfo.getDataToSend());
        } else if (requestInfo.getRemoteServerAddress() == null) {
            log.info("Setting remote server address to {}", (Object)((HttpRequest)requestInfo.getDataToSend()).socketAddressFromHostHeader());
            requestInfo.setRemoteServerAddress(((HttpRequest)requestInfo.getDataToSend()).socketAddressFromHostHeader());
        }
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequestInfo requestInfo) throws SocketConnectionException {
        return this.sendRequest(requestInfo, this.configuration.socketConnectionTimeoutInMillis());
    }

    public HttpClientInitializer createClientInitializer(HttpProtocol httpProtocol) {
        return new HttpClientInitializer(this.configuration, this.nettySslContextFactory, httpProtocol);
    }

    public CompletableFuture<BinaryMessage> sendRequest(BinaryRequestInfo binaryRequestInfo, boolean isSecure) throws SocketConnectionException {
        if (!this.eventLoopGroup.isShuttingDown()) {
            CompletableFuture<BinaryMessage> binaryResponseFuture = new CompletableFuture<BinaryMessage>();
            CompletableFuture<Message> responseFuture = new CompletableFuture<Message>();
            HttpClientInitializer httpClientInitializer = this.createClientInitializer(null);
            ChannelFutureListener onCreateAndReuseListener = future -> {
                if (future.isSuccess()) {
                    log.atDebug().log(() -> "sending bytes hex %s to %s".formatted(ByteBufUtil.hexDump((byte[])binaryRequestInfo.getBytes()), future.channel().attr(REMOTE_SOCKET).get()));
                    future.channel().writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryRequestInfo.getBytes()));
                } else {
                    binaryResponseFuture.completeExceptionally(future.cause());
                }
            };
            this.clientBootstrapFactory.configureChannel().isSecure(isSecure).requestInfo(binaryRequestInfo).responseFuture(responseFuture).clientInitializer(httpClientInitializer).errorIfChannelClosedWithoutResponse(false).responseFuture(responseFuture).onReuseListener(onCreateAndReuseListener).onCreationListener(onCreateAndReuseListener).connectToChannel();
            responseFuture.whenComplete((message, throwable) -> {
                if (throwable == null) {
                    binaryResponseFuture.complete((BinaryMessage)message);
                } else {
                    throwable.printStackTrace();
                    binaryResponseFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return binaryResponseFuture;
        }
        throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
    }

    private boolean shouldUseProxy(InetSocketAddress remoteAddress) {
        if (remoteAddress == null || this.proxyConfiguration == null) {
            return true;
        }
        return NoProxyUtils.shouldUseProxyForHost(remoteAddress.getAddress(), this.proxyConfiguration.getNoProxyHosts());
    }

    public int queryClientPort(int port) {
        return this.clientBootstrapFactory.getLoopCounterForOpenConnectionFromPort(port);
    }

    @Generated
    public ClientBootstrapFactory getClientBootstrapFactory() {
        return this.clientBootstrapFactory;
    }
}

