/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryBridgeHandler
extends SimpleChannelInboundHandler<BinaryMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryBridgeHandler.class);
    public static final AttributeKey<Channel> OUTGOING_CHANNEL = AttributeKey.valueOf((String)"OUTGOING_CHANNEL");
    public static final AttributeKey<Channel> INCOMING_CHANNEL = AttributeKey.valueOf((String)"INCOMING_CHANNEL");
    private final BinaryExchangeHandler binaryProxyListener;

    public BinaryBridgeHandler(MockServerConfiguration configuration) {
        this.binaryProxyListener = configuration.binaryProxyListener();
    }

    protected void channelRead0(ChannelHandlerContext ctx, BinaryMessage msg) {
        Optional.ofNullable((Channel)ctx.channel().attr(INCOMING_CHANNEL).get()).orElseThrow(() -> new IllegalStateException("Incoming channel is not set.")).writeAndFlush((Object)Unpooled.copiedBuffer((byte[])msg.getBytes()));
        this.binaryProxyListener.onProxy(msg, Optional.empty(), ((Channel)ctx.channel().attr(INCOMING_CHANNEL).get()).remoteAddress(), ctx.channel().remoteAddress());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.binaryProxyListener.propagateExceptionMessageSafe(cause, RbelHostname.create((SocketAddress)ctx.channel().remoteAddress()), RbelHostname.create((SocketAddress)((Channel)ctx.channel().attr(INCOMING_CHANNEL).get()).remoteAddress()));
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

