/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.configuration;

import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactory;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRoutingException;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;

public class MockServerConfiguration {
    private String mockServerName = null;
    private Integer nioEventLoopThreadCount = 5;
    private Integer actionHandlerThreadCount = Math.max(5, Runtime.getRuntime().availableProcessors());
    private Integer clientNioEventLoopThreadCount = 5;
    private Integer webSocketClientEventLoopThreadCount = 5;
    private Long maxFutureTimeoutInMillis = TimeUnit.SECONDS.toMillis(90L);
    private Long maxSocketTimeoutInMillis = TimeUnit.SECONDS.toMillis(20L);
    private Long socketConnectionTimeoutInMillis = TimeUnit.SECONDS.toMillis(20L);
    private boolean alwaysCloseSocketConnections = false;
    private Integer maxInitialLineLength = Integer.MAX_VALUE;
    private Integer maxHeaderSize = Integer.MAX_VALUE;
    private Integer maxChunkSize = Integer.MAX_VALUE;
    private BinaryExchangeHandler binaryProxyListener = null;
    private boolean enableTlsTermination = true;
    private BiConsumer<TigerProxyRoutingException, ChannelHandlerContext> exceptionHandlingCallback = (x, y) -> {};
    private ProxyConfiguration proxyConfiguration = null;
    private InetSocketAddress directForwarding = null;
    private boolean rebuildServerTlsContext = false;
    private String tlsProtocols = "TLSv1,TLSv1.1,TLSv1.2";
    private KeyAndCertificateFactory serverKeyAndCertificateFactory = null;
    private KeyAndCertificateFactory clientKeyAndCertificateFactory = null;
    private Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction = null;
    private Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer = factory -> {};
    private UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer = UnaryOperator.identity();
    private UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer = UnaryOperator.identity();
    private Function<X509Certificate, byte[]> ocspResponseSupplier = null;
    private String masterSecretFile = null;
    private String sslCertificateDomainName = "localhost";
    private Set<String> sslSubjectAlternativeNameDomains = new ConcurrentSkipListSet<String>(Set.of("localhost"));
    private Set<String> sslSubjectAlternativeNameIps = new ConcurrentSkipListSet<String>(Set.of("127.0.0.1", "0.0.0.0"));

    public static MockServerConfiguration configuration() {
        return new MockServerConfiguration();
    }

    public void addSubjectAlternativeName(String newSubjectAlternativeName) {
        this.sslSubjectAlternativeNameDomains.add(newSubjectAlternativeName);
        this.rebuildServerTlsContext = true;
    }

    @Generated
    public MockServerConfiguration() {
    }

    @Generated
    public String mockServerName() {
        return this.mockServerName;
    }

    @Generated
    public Integer nioEventLoopThreadCount() {
        return this.nioEventLoopThreadCount;
    }

    @Generated
    public Integer actionHandlerThreadCount() {
        return this.actionHandlerThreadCount;
    }

    @Generated
    public Integer clientNioEventLoopThreadCount() {
        return this.clientNioEventLoopThreadCount;
    }

    @Generated
    public Integer webSocketClientEventLoopThreadCount() {
        return this.webSocketClientEventLoopThreadCount;
    }

    @Generated
    public Long maxFutureTimeoutInMillis() {
        return this.maxFutureTimeoutInMillis;
    }

    @Generated
    public Long maxSocketTimeoutInMillis() {
        return this.maxSocketTimeoutInMillis;
    }

    @Generated
    public Long socketConnectionTimeoutInMillis() {
        return this.socketConnectionTimeoutInMillis;
    }

    @Generated
    public boolean alwaysCloseSocketConnections() {
        return this.alwaysCloseSocketConnections;
    }

    @Generated
    public Integer maxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    @Generated
    public Integer maxHeaderSize() {
        return this.maxHeaderSize;
    }

    @Generated
    public Integer maxChunkSize() {
        return this.maxChunkSize;
    }

    @Generated
    public BinaryExchangeHandler binaryProxyListener() {
        return this.binaryProxyListener;
    }

    @Generated
    public boolean enableTlsTermination() {
        return this.enableTlsTermination;
    }

    @Generated
    public BiConsumer<TigerProxyRoutingException, ChannelHandlerContext> exceptionHandlingCallback() {
        return this.exceptionHandlingCallback;
    }

    @Generated
    public ProxyConfiguration proxyConfiguration() {
        return this.proxyConfiguration;
    }

    @Generated
    public InetSocketAddress directForwarding() {
        return this.directForwarding;
    }

    @Generated
    public boolean rebuildServerTlsContext() {
        return this.rebuildServerTlsContext;
    }

    @Generated
    public String tlsProtocols() {
        return this.tlsProtocols;
    }

    @Generated
    public KeyAndCertificateFactory serverKeyAndCertificateFactory() {
        return this.serverKeyAndCertificateFactory;
    }

    @Generated
    public KeyAndCertificateFactory clientKeyAndCertificateFactory() {
        return this.clientKeyAndCertificateFactory;
    }

    @Generated
    public Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction() {
        return this.clientSslContextBuilderFunction;
    }

    @Generated
    public Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer() {
        return this.nettySslContextFactoryCustomizer;
    }

    @Generated
    public UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer() {
        return this.sslServerContextBuilderCustomizer;
    }

    @Generated
    public UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer() {
        return this.sslClientContextBuilderCustomizer;
    }

    @Generated
    public Function<X509Certificate, byte[]> ocspResponseSupplier() {
        return this.ocspResponseSupplier;
    }

    @Generated
    public String masterSecretFile() {
        return this.masterSecretFile;
    }

    @Generated
    public String sslCertificateDomainName() {
        return this.sslCertificateDomainName;
    }

    @Generated
    public Set<String> sslSubjectAlternativeNameDomains() {
        return this.sslSubjectAlternativeNameDomains;
    }

    @Generated
    public Set<String> sslSubjectAlternativeNameIps() {
        return this.sslSubjectAlternativeNameIps;
    }

    @Generated
    public MockServerConfiguration mockServerName(String mockServerName) {
        this.mockServerName = mockServerName;
        return this;
    }

    @Generated
    public MockServerConfiguration nioEventLoopThreadCount(Integer nioEventLoopThreadCount) {
        this.nioEventLoopThreadCount = nioEventLoopThreadCount;
        return this;
    }

    @Generated
    public MockServerConfiguration actionHandlerThreadCount(Integer actionHandlerThreadCount) {
        this.actionHandlerThreadCount = actionHandlerThreadCount;
        return this;
    }

    @Generated
    public MockServerConfiguration clientNioEventLoopThreadCount(Integer clientNioEventLoopThreadCount) {
        this.clientNioEventLoopThreadCount = clientNioEventLoopThreadCount;
        return this;
    }

    @Generated
    public MockServerConfiguration webSocketClientEventLoopThreadCount(Integer webSocketClientEventLoopThreadCount) {
        this.webSocketClientEventLoopThreadCount = webSocketClientEventLoopThreadCount;
        return this;
    }

    @Generated
    public MockServerConfiguration maxFutureTimeoutInMillis(Long maxFutureTimeoutInMillis) {
        this.maxFutureTimeoutInMillis = maxFutureTimeoutInMillis;
        return this;
    }

    @Generated
    public MockServerConfiguration maxSocketTimeoutInMillis(Long maxSocketTimeoutInMillis) {
        this.maxSocketTimeoutInMillis = maxSocketTimeoutInMillis;
        return this;
    }

    @Generated
    public MockServerConfiguration socketConnectionTimeoutInMillis(Long socketConnectionTimeoutInMillis) {
        this.socketConnectionTimeoutInMillis = socketConnectionTimeoutInMillis;
        return this;
    }

    @Generated
    public MockServerConfiguration alwaysCloseSocketConnections(boolean alwaysCloseSocketConnections) {
        this.alwaysCloseSocketConnections = alwaysCloseSocketConnections;
        return this;
    }

    @Generated
    public MockServerConfiguration maxInitialLineLength(Integer maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    @Generated
    public MockServerConfiguration maxHeaderSize(Integer maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    @Generated
    public MockServerConfiguration maxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    @Generated
    public MockServerConfiguration binaryProxyListener(BinaryExchangeHandler binaryProxyListener) {
        this.binaryProxyListener = binaryProxyListener;
        return this;
    }

    @Generated
    public MockServerConfiguration enableTlsTermination(boolean enableTlsTermination) {
        this.enableTlsTermination = enableTlsTermination;
        return this;
    }

    @Generated
    public MockServerConfiguration exceptionHandlingCallback(BiConsumer<TigerProxyRoutingException, ChannelHandlerContext> exceptionHandlingCallback) {
        this.exceptionHandlingCallback = exceptionHandlingCallback;
        return this;
    }

    @Generated
    public MockServerConfiguration proxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this;
    }

    @Generated
    public MockServerConfiguration directForwarding(InetSocketAddress directForwarding) {
        this.directForwarding = directForwarding;
        return this;
    }

    @Generated
    public MockServerConfiguration rebuildServerTlsContext(boolean rebuildServerTlsContext) {
        this.rebuildServerTlsContext = rebuildServerTlsContext;
        return this;
    }

    @Generated
    public MockServerConfiguration tlsProtocols(String tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
        return this;
    }

    @Generated
    public MockServerConfiguration serverKeyAndCertificateFactory(KeyAndCertificateFactory serverKeyAndCertificateFactory) {
        this.serverKeyAndCertificateFactory = serverKeyAndCertificateFactory;
        return this;
    }

    @Generated
    public MockServerConfiguration clientKeyAndCertificateFactory(KeyAndCertificateFactory clientKeyAndCertificateFactory) {
        this.clientKeyAndCertificateFactory = clientKeyAndCertificateFactory;
        return this;
    }

    @Generated
    public MockServerConfiguration clientSslContextBuilderFunction(Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction) {
        this.clientSslContextBuilderFunction = clientSslContextBuilderFunction;
        return this;
    }

    @Generated
    public MockServerConfiguration nettySslContextFactoryCustomizer(Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer) {
        this.nettySslContextFactoryCustomizer = nettySslContextFactoryCustomizer;
        return this;
    }

    @Generated
    public MockServerConfiguration sslServerContextBuilderCustomizer(UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer) {
        this.sslServerContextBuilderCustomizer = sslServerContextBuilderCustomizer;
        return this;
    }

    @Generated
    public MockServerConfiguration sslClientContextBuilderCustomizer(UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer) {
        this.sslClientContextBuilderCustomizer = sslClientContextBuilderCustomizer;
        return this;
    }

    @Generated
    public MockServerConfiguration ocspResponseSupplier(Function<X509Certificate, byte[]> ocspResponseSupplier) {
        this.ocspResponseSupplier = ocspResponseSupplier;
        return this;
    }

    @Generated
    public MockServerConfiguration masterSecretFile(String masterSecretFile) {
        this.masterSecretFile = masterSecretFile;
        return this;
    }

    @Generated
    public MockServerConfiguration sslCertificateDomainName(String sslCertificateDomainName) {
        this.sslCertificateDomainName = sslCertificateDomainName;
        return this;
    }

    @Generated
    public MockServerConfiguration sslSubjectAlternativeNameDomains(Set<String> sslSubjectAlternativeNameDomains) {
        this.sslSubjectAlternativeNameDomains = sslSubjectAlternativeNameDomains;
        return this;
    }

    @Generated
    public MockServerConfiguration sslSubjectAlternativeNameIps(Set<String> sslSubjectAlternativeNameIps) {
        this.sslSubjectAlternativeNameIps = sslSubjectAlternativeNameIps;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockServerConfiguration)) {
            return false;
        }
        MockServerConfiguration other = (MockServerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.alwaysCloseSocketConnections() != other.alwaysCloseSocketConnections()) {
            return false;
        }
        if (this.enableTlsTermination() != other.enableTlsTermination()) {
            return false;
        }
        if (this.rebuildServerTlsContext() != other.rebuildServerTlsContext()) {
            return false;
        }
        Integer this$nioEventLoopThreadCount = this.nioEventLoopThreadCount();
        Integer other$nioEventLoopThreadCount = other.nioEventLoopThreadCount();
        if (this$nioEventLoopThreadCount == null ? other$nioEventLoopThreadCount != null : !((Object)this$nioEventLoopThreadCount).equals(other$nioEventLoopThreadCount)) {
            return false;
        }
        Integer this$actionHandlerThreadCount = this.actionHandlerThreadCount();
        Integer other$actionHandlerThreadCount = other.actionHandlerThreadCount();
        if (this$actionHandlerThreadCount == null ? other$actionHandlerThreadCount != null : !((Object)this$actionHandlerThreadCount).equals(other$actionHandlerThreadCount)) {
            return false;
        }
        Integer this$clientNioEventLoopThreadCount = this.clientNioEventLoopThreadCount();
        Integer other$clientNioEventLoopThreadCount = other.clientNioEventLoopThreadCount();
        if (this$clientNioEventLoopThreadCount == null ? other$clientNioEventLoopThreadCount != null : !((Object)this$clientNioEventLoopThreadCount).equals(other$clientNioEventLoopThreadCount)) {
            return false;
        }
        Integer this$webSocketClientEventLoopThreadCount = this.webSocketClientEventLoopThreadCount();
        Integer other$webSocketClientEventLoopThreadCount = other.webSocketClientEventLoopThreadCount();
        if (this$webSocketClientEventLoopThreadCount == null ? other$webSocketClientEventLoopThreadCount != null : !((Object)this$webSocketClientEventLoopThreadCount).equals(other$webSocketClientEventLoopThreadCount)) {
            return false;
        }
        Long this$maxFutureTimeoutInMillis = this.maxFutureTimeoutInMillis();
        Long other$maxFutureTimeoutInMillis = other.maxFutureTimeoutInMillis();
        if (this$maxFutureTimeoutInMillis == null ? other$maxFutureTimeoutInMillis != null : !((Object)this$maxFutureTimeoutInMillis).equals(other$maxFutureTimeoutInMillis)) {
            return false;
        }
        Long this$maxSocketTimeoutInMillis = this.maxSocketTimeoutInMillis();
        Long other$maxSocketTimeoutInMillis = other.maxSocketTimeoutInMillis();
        if (this$maxSocketTimeoutInMillis == null ? other$maxSocketTimeoutInMillis != null : !((Object)this$maxSocketTimeoutInMillis).equals(other$maxSocketTimeoutInMillis)) {
            return false;
        }
        Long this$socketConnectionTimeoutInMillis = this.socketConnectionTimeoutInMillis();
        Long other$socketConnectionTimeoutInMillis = other.socketConnectionTimeoutInMillis();
        if (this$socketConnectionTimeoutInMillis == null ? other$socketConnectionTimeoutInMillis != null : !((Object)this$socketConnectionTimeoutInMillis).equals(other$socketConnectionTimeoutInMillis)) {
            return false;
        }
        Integer this$maxInitialLineLength = this.maxInitialLineLength();
        Integer other$maxInitialLineLength = other.maxInitialLineLength();
        if (this$maxInitialLineLength == null ? other$maxInitialLineLength != null : !((Object)this$maxInitialLineLength).equals(other$maxInitialLineLength)) {
            return false;
        }
        Integer this$maxHeaderSize = this.maxHeaderSize();
        Integer other$maxHeaderSize = other.maxHeaderSize();
        if (this$maxHeaderSize == null ? other$maxHeaderSize != null : !((Object)this$maxHeaderSize).equals(other$maxHeaderSize)) {
            return false;
        }
        Integer this$maxChunkSize = this.maxChunkSize();
        Integer other$maxChunkSize = other.maxChunkSize();
        if (this$maxChunkSize == null ? other$maxChunkSize != null : !((Object)this$maxChunkSize).equals(other$maxChunkSize)) {
            return false;
        }
        String this$mockServerName = this.mockServerName();
        String other$mockServerName = other.mockServerName();
        if (this$mockServerName == null ? other$mockServerName != null : !this$mockServerName.equals(other$mockServerName)) {
            return false;
        }
        BinaryExchangeHandler this$binaryProxyListener = this.binaryProxyListener();
        BinaryExchangeHandler other$binaryProxyListener = other.binaryProxyListener();
        if (this$binaryProxyListener == null ? other$binaryProxyListener != null : !((Object)this$binaryProxyListener).equals(other$binaryProxyListener)) {
            return false;
        }
        BiConsumer<TigerProxyRoutingException, ChannelHandlerContext> this$exceptionHandlingCallback = this.exceptionHandlingCallback();
        BiConsumer<TigerProxyRoutingException, ChannelHandlerContext> other$exceptionHandlingCallback = other.exceptionHandlingCallback();
        if (this$exceptionHandlingCallback == null ? other$exceptionHandlingCallback != null : !this$exceptionHandlingCallback.equals(other$exceptionHandlingCallback)) {
            return false;
        }
        ProxyConfiguration this$proxyConfiguration = this.proxyConfiguration();
        ProxyConfiguration other$proxyConfiguration = other.proxyConfiguration();
        if (this$proxyConfiguration == null ? other$proxyConfiguration != null : !((Object)this$proxyConfiguration).equals(other$proxyConfiguration)) {
            return false;
        }
        InetSocketAddress this$directForwarding = this.directForwarding();
        InetSocketAddress other$directForwarding = other.directForwarding();
        if (this$directForwarding == null ? other$directForwarding != null : !((Object)this$directForwarding).equals(other$directForwarding)) {
            return false;
        }
        String this$tlsProtocols = this.tlsProtocols();
        String other$tlsProtocols = other.tlsProtocols();
        if (this$tlsProtocols == null ? other$tlsProtocols != null : !this$tlsProtocols.equals(other$tlsProtocols)) {
            return false;
        }
        KeyAndCertificateFactory this$serverKeyAndCertificateFactory = this.serverKeyAndCertificateFactory();
        KeyAndCertificateFactory other$serverKeyAndCertificateFactory = other.serverKeyAndCertificateFactory();
        if (this$serverKeyAndCertificateFactory == null ? other$serverKeyAndCertificateFactory != null : !this$serverKeyAndCertificateFactory.equals(other$serverKeyAndCertificateFactory)) {
            return false;
        }
        KeyAndCertificateFactory this$clientKeyAndCertificateFactory = this.clientKeyAndCertificateFactory();
        KeyAndCertificateFactory other$clientKeyAndCertificateFactory = other.clientKeyAndCertificateFactory();
        if (this$clientKeyAndCertificateFactory == null ? other$clientKeyAndCertificateFactory != null : !this$clientKeyAndCertificateFactory.equals(other$clientKeyAndCertificateFactory)) {
            return false;
        }
        Function<SslContextBuilder, SslContext> this$clientSslContextBuilderFunction = this.clientSslContextBuilderFunction();
        Function<SslContextBuilder, SslContext> other$clientSslContextBuilderFunction = other.clientSslContextBuilderFunction();
        if (this$clientSslContextBuilderFunction == null ? other$clientSslContextBuilderFunction != null : !this$clientSslContextBuilderFunction.equals(other$clientSslContextBuilderFunction)) {
            return false;
        }
        Consumer<NettySslContextFactory> this$nettySslContextFactoryCustomizer = this.nettySslContextFactoryCustomizer();
        Consumer<NettySslContextFactory> other$nettySslContextFactoryCustomizer = other.nettySslContextFactoryCustomizer();
        if (this$nettySslContextFactoryCustomizer == null ? other$nettySslContextFactoryCustomizer != null : !this$nettySslContextFactoryCustomizer.equals(other$nettySslContextFactoryCustomizer)) {
            return false;
        }
        UnaryOperator<SslContextBuilder> this$sslServerContextBuilderCustomizer = this.sslServerContextBuilderCustomizer();
        UnaryOperator<SslContextBuilder> other$sslServerContextBuilderCustomizer = other.sslServerContextBuilderCustomizer();
        if (this$sslServerContextBuilderCustomizer == null ? other$sslServerContextBuilderCustomizer != null : !this$sslServerContextBuilderCustomizer.equals(other$sslServerContextBuilderCustomizer)) {
            return false;
        }
        UnaryOperator<SslContextBuilder> this$sslClientContextBuilderCustomizer = this.sslClientContextBuilderCustomizer();
        UnaryOperator<SslContextBuilder> other$sslClientContextBuilderCustomizer = other.sslClientContextBuilderCustomizer();
        if (this$sslClientContextBuilderCustomizer == null ? other$sslClientContextBuilderCustomizer != null : !this$sslClientContextBuilderCustomizer.equals(other$sslClientContextBuilderCustomizer)) {
            return false;
        }
        Function<X509Certificate, byte[]> this$ocspResponseSupplier = this.ocspResponseSupplier();
        Function<X509Certificate, byte[]> other$ocspResponseSupplier = other.ocspResponseSupplier();
        if (this$ocspResponseSupplier == null ? other$ocspResponseSupplier != null : !this$ocspResponseSupplier.equals(other$ocspResponseSupplier)) {
            return false;
        }
        String this$masterSecretFile = this.masterSecretFile();
        String other$masterSecretFile = other.masterSecretFile();
        if (this$masterSecretFile == null ? other$masterSecretFile != null : !this$masterSecretFile.equals(other$masterSecretFile)) {
            return false;
        }
        String this$sslCertificateDomainName = this.sslCertificateDomainName();
        String other$sslCertificateDomainName = other.sslCertificateDomainName();
        if (this$sslCertificateDomainName == null ? other$sslCertificateDomainName != null : !this$sslCertificateDomainName.equals(other$sslCertificateDomainName)) {
            return false;
        }
        Set<String> this$sslSubjectAlternativeNameDomains = this.sslSubjectAlternativeNameDomains();
        Set<String> other$sslSubjectAlternativeNameDomains = other.sslSubjectAlternativeNameDomains();
        if (this$sslSubjectAlternativeNameDomains == null ? other$sslSubjectAlternativeNameDomains != null : !((Object)this$sslSubjectAlternativeNameDomains).equals(other$sslSubjectAlternativeNameDomains)) {
            return false;
        }
        Set<String> this$sslSubjectAlternativeNameIps = this.sslSubjectAlternativeNameIps();
        Set<String> other$sslSubjectAlternativeNameIps = other.sslSubjectAlternativeNameIps();
        return !(this$sslSubjectAlternativeNameIps == null ? other$sslSubjectAlternativeNameIps != null : !((Object)this$sslSubjectAlternativeNameIps).equals(other$sslSubjectAlternativeNameIps));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MockServerConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.alwaysCloseSocketConnections() ? 79 : 97);
        result = result * 59 + (this.enableTlsTermination() ? 79 : 97);
        result = result * 59 + (this.rebuildServerTlsContext() ? 79 : 97);
        Integer $nioEventLoopThreadCount = this.nioEventLoopThreadCount();
        result = result * 59 + ($nioEventLoopThreadCount == null ? 43 : ((Object)$nioEventLoopThreadCount).hashCode());
        Integer $actionHandlerThreadCount = this.actionHandlerThreadCount();
        result = result * 59 + ($actionHandlerThreadCount == null ? 43 : ((Object)$actionHandlerThreadCount).hashCode());
        Integer $clientNioEventLoopThreadCount = this.clientNioEventLoopThreadCount();
        result = result * 59 + ($clientNioEventLoopThreadCount == null ? 43 : ((Object)$clientNioEventLoopThreadCount).hashCode());
        Integer $webSocketClientEventLoopThreadCount = this.webSocketClientEventLoopThreadCount();
        result = result * 59 + ($webSocketClientEventLoopThreadCount == null ? 43 : ((Object)$webSocketClientEventLoopThreadCount).hashCode());
        Long $maxFutureTimeoutInMillis = this.maxFutureTimeoutInMillis();
        result = result * 59 + ($maxFutureTimeoutInMillis == null ? 43 : ((Object)$maxFutureTimeoutInMillis).hashCode());
        Long $maxSocketTimeoutInMillis = this.maxSocketTimeoutInMillis();
        result = result * 59 + ($maxSocketTimeoutInMillis == null ? 43 : ((Object)$maxSocketTimeoutInMillis).hashCode());
        Long $socketConnectionTimeoutInMillis = this.socketConnectionTimeoutInMillis();
        result = result * 59 + ($socketConnectionTimeoutInMillis == null ? 43 : ((Object)$socketConnectionTimeoutInMillis).hashCode());
        Integer $maxInitialLineLength = this.maxInitialLineLength();
        result = result * 59 + ($maxInitialLineLength == null ? 43 : ((Object)$maxInitialLineLength).hashCode());
        Integer $maxHeaderSize = this.maxHeaderSize();
        result = result * 59 + ($maxHeaderSize == null ? 43 : ((Object)$maxHeaderSize).hashCode());
        Integer $maxChunkSize = this.maxChunkSize();
        result = result * 59 + ($maxChunkSize == null ? 43 : ((Object)$maxChunkSize).hashCode());
        String $mockServerName = this.mockServerName();
        result = result * 59 + ($mockServerName == null ? 43 : $mockServerName.hashCode());
        BinaryExchangeHandler $binaryProxyListener = this.binaryProxyListener();
        result = result * 59 + ($binaryProxyListener == null ? 43 : ((Object)$binaryProxyListener).hashCode());
        BiConsumer<TigerProxyRoutingException, ChannelHandlerContext> $exceptionHandlingCallback = this.exceptionHandlingCallback();
        result = result * 59 + ($exceptionHandlingCallback == null ? 43 : $exceptionHandlingCallback.hashCode());
        ProxyConfiguration $proxyConfiguration = this.proxyConfiguration();
        result = result * 59 + ($proxyConfiguration == null ? 43 : ((Object)$proxyConfiguration).hashCode());
        InetSocketAddress $directForwarding = this.directForwarding();
        result = result * 59 + ($directForwarding == null ? 43 : ((Object)$directForwarding).hashCode());
        String $tlsProtocols = this.tlsProtocols();
        result = result * 59 + ($tlsProtocols == null ? 43 : $tlsProtocols.hashCode());
        KeyAndCertificateFactory $serverKeyAndCertificateFactory = this.serverKeyAndCertificateFactory();
        result = result * 59 + ($serverKeyAndCertificateFactory == null ? 43 : $serverKeyAndCertificateFactory.hashCode());
        KeyAndCertificateFactory $clientKeyAndCertificateFactory = this.clientKeyAndCertificateFactory();
        result = result * 59 + ($clientKeyAndCertificateFactory == null ? 43 : $clientKeyAndCertificateFactory.hashCode());
        Function<SslContextBuilder, SslContext> $clientSslContextBuilderFunction = this.clientSslContextBuilderFunction();
        result = result * 59 + ($clientSslContextBuilderFunction == null ? 43 : $clientSslContextBuilderFunction.hashCode());
        Consumer<NettySslContextFactory> $nettySslContextFactoryCustomizer = this.nettySslContextFactoryCustomizer();
        result = result * 59 + ($nettySslContextFactoryCustomizer == null ? 43 : $nettySslContextFactoryCustomizer.hashCode());
        UnaryOperator<SslContextBuilder> $sslServerContextBuilderCustomizer = this.sslServerContextBuilderCustomizer();
        result = result * 59 + ($sslServerContextBuilderCustomizer == null ? 43 : $sslServerContextBuilderCustomizer.hashCode());
        UnaryOperator<SslContextBuilder> $sslClientContextBuilderCustomizer = this.sslClientContextBuilderCustomizer();
        result = result * 59 + ($sslClientContextBuilderCustomizer == null ? 43 : $sslClientContextBuilderCustomizer.hashCode());
        Function<X509Certificate, byte[]> $ocspResponseSupplier = this.ocspResponseSupplier();
        result = result * 59 + ($ocspResponseSupplier == null ? 43 : $ocspResponseSupplier.hashCode());
        String $masterSecretFile = this.masterSecretFile();
        result = result * 59 + ($masterSecretFile == null ? 43 : $masterSecretFile.hashCode());
        String $sslCertificateDomainName = this.sslCertificateDomainName();
        result = result * 59 + ($sslCertificateDomainName == null ? 43 : $sslCertificateDomainName.hashCode());
        Set<String> $sslSubjectAlternativeNameDomains = this.sslSubjectAlternativeNameDomains();
        result = result * 59 + ($sslSubjectAlternativeNameDomains == null ? 43 : ((Object)$sslSubjectAlternativeNameDomains).hashCode());
        Set<String> $sslSubjectAlternativeNameIps = this.sslSubjectAlternativeNameIps();
        result = result * 59 + ($sslSubjectAlternativeNameIps == null ? 43 : ((Object)$sslSubjectAlternativeNameIps).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MockServerConfiguration(mockServerName=" + this.mockServerName() + ", nioEventLoopThreadCount=" + this.nioEventLoopThreadCount() + ", actionHandlerThreadCount=" + this.actionHandlerThreadCount() + ", clientNioEventLoopThreadCount=" + this.clientNioEventLoopThreadCount() + ", webSocketClientEventLoopThreadCount=" + this.webSocketClientEventLoopThreadCount() + ", maxFutureTimeoutInMillis=" + this.maxFutureTimeoutInMillis() + ", maxSocketTimeoutInMillis=" + this.maxSocketTimeoutInMillis() + ", socketConnectionTimeoutInMillis=" + this.socketConnectionTimeoutInMillis() + ", alwaysCloseSocketConnections=" + this.alwaysCloseSocketConnections() + ", maxInitialLineLength=" + this.maxInitialLineLength() + ", maxHeaderSize=" + this.maxHeaderSize() + ", maxChunkSize=" + this.maxChunkSize() + ", binaryProxyListener=" + String.valueOf(this.binaryProxyListener()) + ", enableTlsTermination=" + this.enableTlsTermination() + ", exceptionHandlingCallback=" + String.valueOf(this.exceptionHandlingCallback()) + ", proxyConfiguration=" + String.valueOf(this.proxyConfiguration()) + ", directForwarding=" + String.valueOf(this.directForwarding()) + ", rebuildServerTlsContext=" + this.rebuildServerTlsContext() + ", tlsProtocols=" + this.tlsProtocols() + ", serverKeyAndCertificateFactory=" + String.valueOf(this.serverKeyAndCertificateFactory()) + ", clientKeyAndCertificateFactory=" + String.valueOf(this.clientKeyAndCertificateFactory()) + ", clientSslContextBuilderFunction=" + String.valueOf(this.clientSslContextBuilderFunction()) + ", nettySslContextFactoryCustomizer=" + String.valueOf(this.nettySslContextFactoryCustomizer()) + ", sslServerContextBuilderCustomizer=" + String.valueOf(this.sslServerContextBuilderCustomizer()) + ", sslClientContextBuilderCustomizer=" + String.valueOf(this.sslClientContextBuilderCustomizer()) + ", ocspResponseSupplier=" + String.valueOf(this.ocspResponseSupplier()) + ", masterSecretFile=" + this.masterSecretFile() + ", sslCertificateDomainName=" + this.sslCertificateDomainName() + ", sslSubjectAlternativeNameDomains=" + String.valueOf(this.sslSubjectAlternativeNameDomains()) + ", sslSubjectAlternativeNameIps=" + String.valueOf(this.sslSubjectAlternativeNameIps()) + ")";
    }
}

