/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.codec;

import de.gematik.test.tiger.mockserver.codec.PreserveHeadersNettyRemoves;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.mappers.FullHttpRequestToMockServerHttpRequest;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.netty.HttpRequestHandler;
import de.gematik.test.tiger.mockserver.socket.tls.SniHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLSession;

public class NettyHttpToMockServerHttpRequestDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private final FullHttpRequestToMockServerHttpRequest fullHttpRequestToMockServerRequest;

    public NettyHttpToMockServerHttpRequestDecoder(MockServerConfiguration configuration, boolean isSecure, Certificate[] clientCertificates, Integer port) {
        this.fullHttpRequestToMockServerRequest = new FullHttpRequestToMockServerHttpRequest(configuration, isSecure, clientCertificates, port);
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest, List<Object> out) {
        List<Header> preservedHeaders = null;
        SocketAddress senderAddress = null;
        SSLSession sslSession = null;
        boolean isProxying = false;
        if (ctx != null && ctx.channel() != null) {
            preservedHeaders = PreserveHeadersNettyRemoves.preservedHeaders(ctx.channel());
            senderAddress = ctx.channel().remoteAddress();
            sslSession = (SSLSession)ctx.channel().attr(SniHandler.SSL_SESSION).get();
            isProxying = Optional.ofNullable((Boolean)ctx.channel().attr(HttpRequestHandler.PROXYING).get()).orElse(false);
        }
        out.add(this.fullHttpRequestToMockServerRequest.mapFullHttpRequestToMockServerRequest(fullHttpRequest, preservedHeaders, senderAddress, SniHandler.getAlpnProtocol(ctx), sslSession, isProxying));
    }
}

