/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls;

import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.common.util.TigerSecurityProviderInitialiser;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;

public class StaticTigerKeyAndCertificateFactory
implements KeyAndCertificateFactory {
    private final List<TigerPkiIdentity> availableIdentities;

    public StaticTigerKeyAndCertificateFactory(TigerPkiIdentity eeIdentity) {
        this.availableIdentities = List.of(eeIdentity);
    }

    public StaticTigerKeyAndCertificateFactory(List<TigerPkiIdentity> eeIdentities) {
        this.availableIdentities = eeIdentities;
    }

    @Override
    public TigerPkiIdentity buildAndSavePrivateKeyAndX509Certificate(String hostname) {
        return this.availableIdentities.stream().filter(id -> this.matchesHostname(id.getCertificate(), hostname)).findAny().orElseGet(() -> this.availableIdentities.get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesHostname(X509Certificate certificate, String hostname) {
        try {
            if (this.subjectMatches(certificate.getSubjectX500Principal(), hostname)) {
                return true;
            }
            Collection<List<?>> alternativeNames = certificate.getSubjectAlternativeNames();
            if (alternativeNames == null) return false;
            if (hostname == null) return false;
            if (!alternativeNames.stream().map(Object::toString).anyMatch(hostname::equalsIgnoreCase)) return false;
            return true;
        }
        catch (CertificateParsingException e) {
            return false;
        }
    }

    private boolean subjectMatches(X500Principal subjectX500Principal, String hostname) {
        String dn = subjectX500Principal.getName();
        for (String part : dn.split(",")) {
            if (!part.startsWith("CN=")) continue;
            return part.substring(3).equalsIgnoreCase(hostname);
        }
        return false;
    }

    @Generated
    public static StaticTigerKeyAndCertificateFactoryBuilder builder() {
        return new StaticTigerKeyAndCertificateFactoryBuilder();
    }

    static {
        TigerSecurityProviderInitialiser.initialize();
    }

    @Generated
    public static class StaticTigerKeyAndCertificateFactoryBuilder {
        @Generated
        private TigerPkiIdentity eeIdentity;

        @Generated
        StaticTigerKeyAndCertificateFactoryBuilder() {
        }

        @Generated
        public StaticTigerKeyAndCertificateFactoryBuilder eeIdentity(TigerPkiIdentity eeIdentity) {
            this.eeIdentity = eeIdentity;
            return this;
        }

        @Generated
        public StaticTigerKeyAndCertificateFactory build() {
            return new StaticTigerKeyAndCertificateFactory(this.eeIdentity);
        }

        @Generated
        public String toString() {
            return "StaticTigerKeyAndCertificateFactory.StaticTigerKeyAndCertificateFactoryBuilder(eeIdentity=" + this.eeIdentity + ")";
        }
    }
}

