/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.CloseChannel;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.AbstractTigerRouteCallback;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardAllCallback
extends AbstractTigerRouteCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForwardAllCallback.class);

    public ForwardAllCallback(TigerProxy tigerProxy) {
        super(tigerProxy, null);
    }

    @Override
    protected HttpRequest handleRequest(HttpRequest req) {
        return HttpOverrideForwardedRequest.forwardOverriddenRequest(req.setSocketAddress(req.isSecure(), req.socketAddressFromHostHeader().getHostName(), req.socketAddressFromHostHeader().getPort())).getRequestOverride();
    }

    @Override
    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        if (request.getSocketAddress() == null) {
            return null;
        }
        return request.getSocketAddress().getScheme() + "://" + request.getSocketAddress().getHost() + ":" + request.getSocketAddress().getPort();
    }

    @Override
    protected String printTrafficTarget(HttpRequest req) {
        return req.socketAddressFromHostHeader().getHostString() + ":" + req.socketAddressFromHostHeader().getPort();
    }

    @Override
    boolean shouldLogTraffic() {
        return true;
    }

    @Override
    public Optional<Action> cannedResponse(HttpRequest httpRequest) {
        if (this.targetsSelf(httpRequest)) {
            return Optional.of(new CloseChannel());
        }
        return Optional.empty();
    }

    private boolean targetsSelf(HttpRequest req) {
        int requestPort = req.socketAddressFromHostHeader().getPort();
        String requestHostName = req.socketAddressFromHostHeader().getHostName();
        return requestPort == this.getTigerProxy().getProxyPort() && (requestHostName.equalsIgnoreCase("127.0.0.1") || requestHostName.equalsIgnoreCase("localhost"));
    }
}

