/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelListFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelUriFacet;
import de.gematik.rbellogger.data.facet.RbelUriParameterFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.CloseChannel;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.MockserverX509CertificateWrapper;
import de.gematik.test.tiger.mockserver.model.Parameters;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.certificate.TlsFacet;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyModificationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyParsingException;
import de.gematik.test.tiger.proxy.handler.BundledServerNamesAdder;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerRouteCallback
implements ExpectationForwardAndResponseCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTigerRouteCallback.class);
    public static final String LOCATION_HEADER_KEY = "Location";
    private final TigerProxy tigerProxy;
    private final TigerRoute tigerRoute;
    private BundledServerNamesAdder bundledServerNamesAdder = new BundledServerNamesAdder();
    private Map<String, CompletableFuture<RbelElement>> requestLogIdToParsingFuture = new ConcurrentHashMap<String, CompletableFuture<RbelElement>>();

    protected AbstractTigerRouteCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        this.tigerProxy = tigerProxy;
        this.tigerRoute = tigerRoute;
    }

    public void applyModifications(HttpRequest request) {
        if (!this.tigerProxy.getModifications().isEmpty()) {
            this.parseMessageAndApplyModifications(request);
        }
    }

    public void parseMessageAndApplyModifications(HttpRequest request) {
        RbelElement requestElement = this.tigerProxy.getRbelLogger().getRbelConverter().convertElement(this.tigerProxy.getMockServerToRbelConverter().requestToRbelMessage(request));
        RbelElement modifiedRequest = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(requestElement);
        if (modifiedRequest == requestElement) {
            return;
        }
        request.withBody(this.extractSafe(modifiedRequest, "$.body").getRawContent());
        for (RbelElement modifiedHeader : modifiedRequest.findRbelPathMembers("$.header.*")) {
            request = request.replaceHeader(Header.header((String)modifiedHeader.getKey().orElseThrow(), modifiedHeader.getRawStringContent()));
        }
        RbelUriFacet uriFacet = (RbelUriFacet)this.extractSafe(modifiedRequest, "$.path").getFacetOrFail(RbelUriFacet.class);
        request.setPath(uriFacet.getBasicPathString());
        this.clearExistingQueryParameters(request);
        this.addAllQueryParametersFromRbelMessage(request, uriFacet);
        request.setMethod(this.extractSafe(modifiedRequest, "$.method").getRawStringContent());
    }

    private RbelElement extractSafe(RbelElement targetElement, String rbelPath) {
        return (RbelElement)targetElement.findElement(rbelPath).orElseThrow(() -> new TigerProxyModificationException("Unexpected structure: Could not find '" + rbelPath + "'!"));
    }

    private void addAllQueryParametersFromRbelMessage(HttpRequest request, RbelUriFacet uriFacet) {
        for (RbelElement queryElement : uriFacet.getQueryParameters()) {
            RbelUriParameterFacet parameterFacet = (RbelUriParameterFacet)queryElement.getFacetOrFail(RbelUriParameterFacet.class);
            request.withQueryStringParameter(parameterFacet.getKeyAsString(), parameterFacet.getValue().getRawStringContent());
        }
    }

    private void clearExistingQueryParameters(HttpRequest request) {
        Parameters queryStringParameters = request.getQueryStringParameters();
        if (queryStringParameters == null) {
            return;
        }
        queryStringParameters.getEntries().forEach(parameter -> queryStringParameters.remove(parameter.getName()));
    }

    public void applyModifications(HttpResponse response) {
        if (!this.tigerProxy.getModifications().isEmpty()) {
            this.parseMessageAndApplyModifications(response);
        }
    }

    public void parseMessageAndApplyModifications(HttpResponse response) {
        RbelElement responseElement = this.tigerProxy.getRbelLogger().getRbelConverter().convertElement(this.tigerProxy.getMockServerToRbelConverter().responseToRbelMessage(response));
        RbelElement modifiedResponse = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(responseElement);
        if (modifiedResponse == responseElement) {
            return;
        }
        response.withBody(this.extractSafe(modifiedResponse, "$.body").getRawContent());
        response.getHeaderMultimap().clear();
        for (RbelElement modifiedHeader : modifiedResponse.findRbelPathMembers("$.header.*")) {
            response = response.withHeader(Header.header((String)modifiedHeader.getKey().orElseThrow(), modifiedHeader.getRawStringContent()));
        }
        response.withStatusCode(Integer.parseInt(this.extractSafe(modifiedResponse, "$.responseCode").getRawStringContent()));
        String reasonPhrase = this.extractSafe(modifiedResponse, "$.reasonPhrase").getRawStringContent();
        if (!StringUtils.isEmpty((CharSequence)reasonPhrase)) {
            response.withReasonPhrase(reasonPhrase);
        } else {
            response.withReasonPhrase(" ");
        }
    }

    @Override
    public final HttpRequest handle(HttpRequest req) {
        try {
            this.doIncomingRequestLogging(req);
            HttpRequest modifiedRequest = this.handleRequest(req);
            if (this.shouldLogTraffic()) {
                this.parseMessage(req);
            }
            return modifiedRequest;
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of request", (Throwable)e);
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    public void propagateExceptionMessageSafe(Exception exception) {
        try {
            this.tigerProxy.propagateException(exception);
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occurred (ignoring):", (Throwable)handlingException);
        }
    }

    protected abstract HttpRequest handleRequest(HttpRequest var1);

    @Override
    public final HttpResponse handle(HttpRequest req, HttpResponse resp) {
        try {
            this.doOutgoingResponseLogging(resp);
            return this.handleResponse(req, resp);
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of response", (Throwable)e);
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    private HttpResponse handleResponse(HttpRequest req, HttpResponse resp) {
        this.rewriteLocationHeaderIfApplicable(resp);
        this.applyModifications(resp);
        if (this.shouldLogTraffic()) {
            this.parseMessages(req, resp);
        }
        return resp.withBody(resp.getBody());
    }

    private void rewriteLocationHeaderIfApplicable(HttpResponse resp) {
        if (this.tigerProxy.getTigerProxyConfiguration().isRewriteLocationHeader() && resp.getStatusCode() / 100 == 3 && !resp.getHeader(LOCATION_HEADER_KEY).isEmpty()) {
            List<String> locations = resp.getHeader(LOCATION_HEADER_KEY);
            resp.removeHeader(LOCATION_HEADER_KEY);
            locations.stream().map(this::rewriteConcreteLocation).map(l -> new Header(LOCATION_HEADER_KEY, (String)l)).forEach(resp::withHeader);
            log.info("Rewriting from {} to {}", locations, resp.getHeader(LOCATION_HEADER_KEY));
        }
    }

    protected String rewriteConcreteLocation(String originalLocation) {
        return originalLocation;
    }

    public void parseMessage(HttpRequest mockServerRequest) {
        this.executeHttpRequestParsing(mockServerRequest);
    }

    private void parseMessages(HttpRequest req, HttpResponse resp) {
        CompletableFuture<Void> messageParsingCompleteFuture = this.executeHttpTrafficPairParsing(req, resp);
        if (this.tigerProxy.getTigerProxyConfiguration().isParsingShouldBlockCommunication()) {
            try {
                messageParsingCompleteFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TigerProxyParsingException("Interruption while parsing traffic", e);
            }
            catch (ExecutionException e) {
                throw new TigerProxyParsingException("Error while parsing traffic", e);
            }
        }
    }

    public CompletableFuture<RbelElement> executeHttpRequestParsing(HttpRequest mockServerRequest) {
        if (this.isHealthEndpointRequest(mockServerRequest)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<RbelElement> toBeConvertedRequest = this.getTigerProxy().getMockServerToRbelConverter().convertRequest(mockServerRequest, this.extractProtocolAndHostForRequest(mockServerRequest), Optional.of(ZonedDateTime.now()));
        this.requestLogIdToParsingFuture.put(mockServerRequest.getLogCorrelationId(), toBeConvertedRequest);
        log.trace("Added request to pairingMap with id {}", (Object)mockServerRequest.getLogCorrelationId());
        return ((CompletableFuture)toBeConvertedRequest.thenApply(request -> {
            this.parseCertificateChainIfPresent(mockServerRequest, (RbelElement)request).ifPresent(arg_0 -> ((RbelElement)request).addFacet(arg_0));
            this.addBundledServerNameToHostnameFacet((RbelElement)request);
            this.getTigerProxy().triggerListener((RbelElement)request);
            return request;
        })).exceptionally(e -> {
            log.error("Error while parsing request", e);
            return null;
        });
    }

    private CompletableFuture<Void> executeHttpTrafficPairParsing(HttpRequest req, HttpResponse resp) {
        if (this.isHealthEndpointRequest(req)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<RbelElement> futureParsedRequest = this.retrieveParsedRequest(req);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getTigerProxy().getMockServerToRbelConverter().convertResponse(resp, this.extractProtocolAndHostForRequest(req), req.getRemoteAddress(), futureParsedRequest, Optional.of(ZonedDateTime.now())).thenCombine(futureParsedRequest, (parsedResponse, parsedRequest) -> {
            this.postProcessingAfterBothMessageParsed((RbelElement)parsedResponse, (RbelElement)parsedRequest);
            return null;
        })).thenAccept(ignore -> {})).exceptionally(e -> {
            log.error("Error while both processing message pair", e);
            this.getTigerProxy().propagateException((Throwable)e);
            return null;
        })).exceptionally(e -> {
            log.error("Error while parsing response", e);
            this.getTigerProxy().propagateException((Throwable)e);
            return null;
        });
    }

    private void postProcessingAfterBothMessageParsed(RbelElement response, RbelElement request) {
        TracingMessagePairFacet pairFacet = TracingMessagePairFacet.builder().response(response).request(request).build();
        request.addFacet((RbelFacet)pairFacet);
        response.addFacet((RbelFacet)pairFacet);
        response.addOrReplaceFacet((RbelFacet)response.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::toBuilder).orElse(RbelHttpResponseFacet.builder()).request(request).build());
        request.getFacet(TlsFacet.class).ifPresent(tlsFacet -> {
            TlsFacet respTlsFacet = new TlsFacet(tlsFacet.getTlsVersion().seekValue(String.class).map(value -> RbelElement.wrap((RbelElement)response, (Object)value)).orElse(null), tlsFacet.getCipherSuite().seekValue(String.class).map(value -> RbelElement.wrap((RbelElement)response, (Object)value)).orElse(null), null);
            response.addFacet((RbelFacet)respTlsFacet);
        });
        this.addBundledServerNameToHostnameFacet(response);
        this.getTigerProxy().triggerListener(response);
    }

    private CompletableFuture<RbelElement> retrieveParsedRequest(HttpRequest req) {
        CompletableFuture<RbelElement> requestParsingFuture = this.requestLogIdToParsingFuture.remove(req.getLogCorrelationId());
        if (requestParsingFuture == null) {
            log.error("Could not find request for response with id {}! Skipping response parsing!", (Object)req.getLogCorrelationId());
            this.tigerProxy.getRbelMessages().forEach(msg -> log.info("Message: {} : {}", (Object)msg.getUuid(), msg));
            throw new TigerProxyParsingException("Not able to find parsed request for uuid " + req.getLogCorrelationId() + "!");
        }
        return requestParsingFuture;
    }

    private void addBundledServerNameToHostnameFacet(RbelElement element) {
        this.bundledServerNamesAdder.addBundledServerNameToHostnameFacet(element);
    }

    private boolean isHealthEndpointRequest(HttpRequest request) {
        return request.getQueryStringParameters() != null && request.getQueryStringParameters().containsEntry("healthEndPointUuid", this.getTigerProxy().getHealthEndpointRequestUuid().toString());
    }

    private Optional<RbelFacet> parseCertificateChainIfPresent(HttpRequest httpRequest, RbelElement message) {
        if (StringUtils.isBlank((CharSequence)httpRequest.getTlsVersion())) {
            return Optional.empty();
        }
        if (httpRequest.getClientCertificateChain() == null || httpRequest.getClientCertificateChain().isEmpty()) {
            return Optional.of(new TlsFacet(RbelElement.wrap((RbelElement)message, (Object)httpRequest.getTlsVersion()), RbelElement.wrap((RbelElement)message, (Object)httpRequest.getCipherSuite()), null));
        }
        RbelElement certificateChainElement = new RbelElement(null, message);
        certificateChainElement.addFacet((RbelFacet)RbelListFacet.builder().childNodes(httpRequest.getClientCertificateChain().stream().map(MockserverX509CertificateWrapper::certificate).map(cert -> this.mapToRbelElement((Certificate)cert, message)).toList()).build());
        return Optional.of(new TlsFacet(RbelElement.wrap((RbelElement)message, (Object)httpRequest.getTlsVersion()), RbelElement.wrap((RbelElement)message, (Object)httpRequest.getCipherSuite()), certificateChainElement));
    }

    private RbelElement mapToRbelElement(Certificate certificate, RbelElement parentNode) {
        try {
            RbelElement certificateNode = new RbelElement(certificate.getEncoded(), parentNode);
            this.getTigerProxy().getRbelLogger().getRbelConverter().convertElement(certificateNode);
            return certificateNode;
        }
        catch (CertificateEncodingException e) {
            RbelElement rbelElement = new RbelElement(null, parentNode);
            rbelElement.addFacet((RbelFacet)RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.ERROR).value("Error while trying to get binary representation for certificate: " + e.getMessage()).build());
            return rbelElement;
        }
    }

    boolean shouldLogTraffic() {
        return !this.getTigerRoute().isDisableRbelLogging();
    }

    protected abstract String extractProtocolAndHostForRequest(HttpRequest var1);

    HttpRequest cloneRequest(HttpRequest req) {
        HttpOverrideForwardedRequest clonedRequest = HttpOverrideForwardedRequest.forwardOverriddenRequest(req);
        if (req.getBody() != null) {
            return clonedRequest.getRequestOverride().withBody(req.getBody());
        }
        return clonedRequest.getRequestOverride();
    }

    public void doOutgoingResponseLogging(HttpResponse resp) {
        if (log.isInfoEnabled() && this.tigerProxy.getTigerProxyConfiguration().isActivateTrafficLogging()) {
            log.info("Returning HTTP " + resp.getStatusCode() + " Response-Length: " + AbstractTigerRouteCallback.getMessageSize(resp.getBody()));
        }
    }

    private static String getMessageSize(byte[] body) {
        return FileUtils.byteCountToDisplaySize((long)body.length);
    }

    public void doIncomingRequestLogging(HttpRequest req) {
        if (log.isInfoEnabled() && this.tigerProxy.getTigerProxyConfiguration().isActivateTrafficLogging()) {
            log.info("Received " + req.printLogLineDescription() + " => " + this.printTrafficTarget(req));
        }
    }

    protected abstract String printTrafficTarget(HttpRequest var1);

    @Override
    public boolean matches(HttpRequest request) {
        if (this.tigerRoute == null || this.tigerRoute.getCriterions() == null || this.tigerRoute.getCriterions().isEmpty()) {
            return true;
        }
        RbelElement convertedRequest = this.getTigerProxy().getMockServerToRbelConverter().convertRequest(request, this.extractProtocolAndHostForRequest(request), Optional.of(ZonedDateTime.now())).join();
        request.setParsedRbelMessage(convertedRequest);
        return this.tigerRoute.getCriterions().stream().allMatch(criterion -> {
            boolean matches = TigerJexlExecutor.matchesAsJexlExpression((Object)convertedRequest, (String)criterion);
            log.atTrace().addArgument(criterion).addArgument(() -> ((RbelElement)convertedRequest).printHttpDescription()).addArgument(() -> matches).log("Matching {} for {}: {}");
            return matches;
        });
    }

    @Override
    public Action handleException(Throwable exception, HttpRequest request) {
        log.info("Exception during handling of request", exception);
        RbelElement errorResponse = this.tigerProxy.getMockServerToRbelConverter().convertErrorResponse(request, this.extractProtocolAndHostForRequest(request));
        errorResponse.addFacet((RbelFacet)RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.ERROR).value(exception.getMessage()).build());
        return new CloseChannel();
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public TigerRoute getTigerRoute() {
        return this.tigerRoute;
    }

    @Generated
    public BundledServerNamesAdder getBundledServerNamesAdder() {
        return this.bundledServerNamesAdder;
    }

    @Generated
    public Map<String, CompletableFuture<RbelElement>> getRequestLogIdToParsingFuture() {
        return this.requestLogIdToParsingFuture;
    }

    @Generated
    public void setBundledServerNamesAdder(BundledServerNamesAdder bundledServerNamesAdder) {
        this.bundledServerNamesAdder = bundledServerNamesAdder;
    }

    @Generated
    public void setRequestLogIdToParsingFuture(Map<String, CompletableFuture<RbelElement>> requestLogIdToParsingFuture) {
        this.requestLogIdToParsingFuture = requestLogIdToParsingFuture;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerRouteCallback)) {
            return false;
        }
        AbstractTigerRouteCallback other = (AbstractTigerRouteCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        TigerRoute this$tigerRoute = this.getTigerRoute();
        TigerRoute other$tigerRoute = other.getTigerRoute();
        if (this$tigerRoute == null ? other$tigerRoute != null : !this$tigerRoute.equals(other$tigerRoute)) {
            return false;
        }
        BundledServerNamesAdder this$bundledServerNamesAdder = this.getBundledServerNamesAdder();
        BundledServerNamesAdder other$bundledServerNamesAdder = other.getBundledServerNamesAdder();
        if (this$bundledServerNamesAdder == null ? other$bundledServerNamesAdder != null : !this$bundledServerNamesAdder.equals(other$bundledServerNamesAdder)) {
            return false;
        }
        Map<String, CompletableFuture<RbelElement>> this$requestLogIdToParsingFuture = this.getRequestLogIdToParsingFuture();
        Map<String, CompletableFuture<RbelElement>> other$requestLogIdToParsingFuture = other.getRequestLogIdToParsingFuture();
        return !(this$requestLogIdToParsingFuture == null ? other$requestLogIdToParsingFuture != null : !((Object)this$requestLogIdToParsingFuture).equals(other$requestLogIdToParsingFuture));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerRouteCallback;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        TigerRoute $tigerRoute = this.getTigerRoute();
        result = result * 59 + ($tigerRoute == null ? 43 : $tigerRoute.hashCode());
        BundledServerNamesAdder $bundledServerNamesAdder = this.getBundledServerNamesAdder();
        result = result * 59 + ($bundledServerNamesAdder == null ? 43 : $bundledServerNamesAdder.hashCode());
        Map<String, CompletableFuture<RbelElement>> $requestLogIdToParsingFuture = this.getRequestLogIdToParsingFuture();
        result = result * 59 + ($requestLogIdToParsingFuture == null ? 43 : ((Object)$requestLogIdToParsingFuture).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractTigerRouteCallback(tigerProxy=" + this.getTigerProxy() + ", tigerRoute=" + this.getTigerRoute() + ", bundledServerNamesAdder=" + this.getBundledServerNamesAdder() + ", requestLogIdToParsingFuture=" + this.getRequestLogIdToParsingFuture() + ")";
    }
}

