/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessageIsolani;
import de.gematik.test.tiger.proxy.client.TracingMessagePair;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;

class TracingStompHandler
implements StompFrameHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingStompHandler.class);
    private final TigerRemoteProxyClient remoteProxyClient;

    public Type getPayloadType(StompHeaders stompHeaders) {
        return TigerTracingDto.class;
    }

    public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
        if (log.isTraceEnabled()) {
            log.trace("Received new frame of type {} in proxy {}", (Object)frameContent.getClass().getSimpleName(), (Object)this.remoteProxyClient.getName().orElse("<>"));
        }
        if (frameContent instanceof TigerTracingDto) {
            TigerTracingDto tigerTracingDto = (TigerTracingDto)frameContent;
            if (log.isDebugEnabled()) {
                log.debug("Received TigerTracingDto with request-uuid {} and response-uuid {} (proxy {})", new Object[]{tigerTracingDto.getRequestUuid(), tigerTracingDto.getResponseUuid(), this.remoteProxyClient.getName().orElse("<>")});
            }
            if (StringUtils.isEmpty((CharSequence)tigerTracingDto.getResponseUuid())) {
                this.registerNewIsolaniMessage(tigerTracingDto);
            } else {
                this.registerNewMessagePair(tigerTracingDto);
            }
        }
    }

    private void registerNewIsolaniMessage(TigerTracingDto tigerTracingDto) {
        TracingMessageIsolani isolani = new TracingMessageIsolani(this.remoteProxyClient);
        isolani.setMessage(PartialTracingMessage.builder().tracingDto(tigerTracingDto).receiver(tigerTracingDto.getReceiver()).sender(tigerTracingDto.getSender()).messageFrame(isolani).unparsedChunk(tigerTracingDto.isUnparsedChunk()).transmissionTime(tigerTracingDto.getRequestTransmissionTime()).additionalInformation(tigerTracingDto.getAdditionalInformationRequest()).build());
        this.remoteProxyClient.initOrUpdateMessagePart(tigerTracingDto.getRequestUuid(), isolani.getMessage());
    }

    private void registerNewMessagePair(TigerTracingDto tigerTracingDto) {
        TracingMessagePair messagePair = new TracingMessagePair(this.remoteProxyClient);
        messagePair.setRequest(PartialTracingMessage.builder().tracingDto(tigerTracingDto).receiver(tigerTracingDto.getReceiver()).sender(tigerTracingDto.getSender()).messageFrame(messagePair).transmissionTime(tigerTracingDto.getRequestTransmissionTime()).additionalInformation(tigerTracingDto.getAdditionalInformationRequest()).build());
        messagePair.setResponse(PartialTracingMessage.builder().tracingDto(tigerTracingDto).receiver(tigerTracingDto.getSender()).sender(tigerTracingDto.getReceiver()).messageFrame(messagePair).transmissionTime(tigerTracingDto.getResponseTransmissionTime()).additionalInformation(tigerTracingDto.getAdditionalInformationResponse()).build());
        this.remoteProxyClient.initOrUpdateMessagePart(tigerTracingDto.getRequestUuid(), messagePair.getRequest());
        this.remoteProxyClient.initOrUpdateMessagePart(tigerTracingDto.getResponseUuid(), messagePair.getResponse());
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TracingStompHandler(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }
}

