/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.unification;

import de.gematik.test.tiger.mockserver.character.Character;
import de.gematik.test.tiger.mockserver.codec.MockServerHttpServerCodec;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.httpclient.BinaryBridgeHandler;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.mock.HttpState;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.netty.HttpRequestHandler;
import de.gematik.test.tiger.mockserver.netty.MockServer;
import de.gematik.test.tiger.mockserver.netty.proxy.BinaryHandler;
import de.gematik.test.tiger.mockserver.netty.unification.HttpContentLengthRemover;
import de.gematik.test.tiger.mockserver.netty.unification.PortBinding;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import de.gematik.test.tiger.mockserver.socket.tls.SniHandler;
import de.gematik.test.tiger.proxy.data.TigerConnectionStatus;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.Signal;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortUnificationHandler
extends ReplayingDecoder<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortUnificationHandler.class);
    public static final AttributeKey<Boolean> TLS_ENABLED_UPSTREAM = AttributeKey.valueOf((String)"TLS_ENABLED_UPSTREAM");
    public static final AttributeKey<Boolean> TLS_ENABLED_DOWNSTREAM = AttributeKey.valueOf((String)"TLS_ENABLED_DOWNSTREAM");
    private static final Map<PortBinding, Set<String>> localAddressesCache = new ConcurrentHashMap<PortBinding, Set<String>>();
    private final HttpContentLengthRemover httpContentLengthRemover = new HttpContentLengthRemover();
    private final MockServerConfiguration configuration;
    private final MockServer server;
    private final HttpState httpState;
    private final HttpActionHandler actionHandler;

    public PortUnificationHandler(MockServerConfiguration configuration, MockServer server, HttpState httpState, HttpActionHandler actionHandler) {
        this.configuration = configuration;
        this.server = server;
        this.httpState = httpState;
        this.actionHandler = actionHandler;
    }

    private void performConnectionToRemote(ChannelHandlerContext ctx) {
        Channel incomingChannel = ctx.channel();
        if (incomingChannel.attr(BinaryBridgeHandler.OUTGOING_CHANNEL).get() != null || this.configuration.binaryProxyListener() == null) {
            log.trace("already connected to remote server or no binary proxy listener");
            return;
        }
        log.trace("enabling connection to remote server");
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress(ctx);
        NettyHttpClient httpClient = this.actionHandler.getHttpClient();
        ChannelFuture channelFuture = httpClient.getClientBootstrapFactory().configureChannel().isSecure(PortUnificationHandler.isSslEnabledUpstream(incomingChannel)).incomingChannel(incomingChannel).remoteAddress(remoteAddress).clientInitializer(httpClient.createClientInitializer(null)).eventLoopGroup((EventLoopGroup)incomingChannel.eventLoop()).errorIfChannelClosedWithoutResponse(false).connectToChannel();
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            incomingChannel.attr(BinaryBridgeHandler.OUTGOING_CHANNEL).set((Object)future.channel());
            future.channel().attr(BinaryBridgeHandler.INCOMING_CHANNEL).set((Object)incomingChannel);
            if (!future.isSuccess()) {
                log.error("Failed to connect to {}", (Object)remoteAddress, (Object)future.cause());
            }
        }));
    }

    public NettySslContextFactory nettySslContextFactory(boolean forServer) {
        if (forServer) {
            return this.server.getServerSslContextFactory();
        }
        return this.server.getClientSslContextFactory();
    }

    public static void enableSslUpstreamAndDownstream(Channel channel) {
        channel.attr(TLS_ENABLED_UPSTREAM).set((Object)Boolean.TRUE);
        channel.attr(TLS_ENABLED_DOWNSTREAM).set((Object)Boolean.TRUE);
    }

    public static boolean isSslEnabledUpstream(Channel channel) {
        if (channel.attr(TLS_ENABLED_UPSTREAM).get() != null) {
            return (Boolean)channel.attr(TLS_ENABLED_UPSTREAM).get();
        }
        return false;
    }

    public static boolean isSslEnabledDownstream(Channel channel) {
        if (channel.attr(TLS_ENABLED_DOWNSTREAM).get() != null) {
            return (Boolean)channel.attr(TLS_ENABLED_DOWNSTREAM).get();
        }
        return false;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        if (this.isTls(msg) && this.configuration.enableTlsTermination()) {
            this.logStage(ctx, "adding TLS decoders");
            this.enableTls(ctx, msg);
            this.performConnectionToRemote(ctx);
        } else {
            this.performConnectionToRemote(ctx);
            if (this.configuration.binaryProxyListener() == null) {
                if (this.isHttp(msg)) {
                    this.logStage(ctx, "adding HTTP decoders");
                    this.switchToHttp(ctx, msg);
                } else if (this.isProxyConnected(msg)) {
                    this.logStage(ctx, "setting proxy connected");
                    this.switchToProxyConnected(ctx, msg);
                }
            } else {
                this.logStage(ctx, "adding binary decoder");
                this.switchToBinary(ctx, msg);
            }
        }
    }

    private void logStage(ChannelHandlerContext ctx, String message) {
        if (log.isTraceEnabled()) {
            log.trace(message + " for channel:{}pipeline:{}", (Object)ctx.channel().toString(), (Object)ctx.pipeline().names());
        }
    }

    private boolean isTls(ByteBuf buf) {
        try {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }
        catch (Signal signal) {
            return false;
        }
    }

    private void enableTls(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.server.addConnectionWithStatus(ctx.channel().remoteAddress(), TigerConnectionStatus.OPEN_TLS);
        pipeline.addFirst(new ChannelHandler[]{new SniHandler(this.configuration, this.nettySslContextFactory(true))});
        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
        ctx.pipeline().fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private boolean isHttp(ByteBuf msg) {
        if (msg.writerIndex() < 8) {
            return false;
        }
        String method = msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII);
        return method.startsWith("GET ") || method.startsWith("POST ") || method.startsWith("PUT ") || method.startsWith("HEAD ") || method.startsWith("OPTIONS ") || method.startsWith("PATCH ") || method.startsWith("DELETE ") || method.startsWith("TRACE ") || method.startsWith("CONNECT ");
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpServerCodec(this.configuration.maxInitialLineLength().intValue(), this.configuration.maxHeaderSize().intValue(), this.configuration.maxChunkSize().intValue()));
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpContentDecompressor());
        this.addLastIfNotPresent(pipeline, (ChannelHandler)this.httpContentLengthRemover);
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new MockServerHttpServerCodec(this.configuration, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), SniHandler.retrieveClientCertificates(ctx), ctx.channel().localAddress()));
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpRequestHandler(this.configuration, this.server, this.httpState, this.actionHandler));
        pipeline.remove((ChannelHandler)this);
        ctx.channel().attr(HttpRequestHandler.LOCAL_HOST_HEADERS).set(this.getLocalAddresses(ctx));
        ctx.fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private boolean isProxyConnected(ByteBuf msg) {
        if (msg.writerIndex() < 8) {
            return false;
        }
        return msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII).startsWith("PROXIED_");
    }

    private void switchToProxyConnected(ChannelHandlerContext ctx, ByteBuf msg) {
        String message = this.readMessage(msg);
        if (message.startsWith("PROXIED_SECURE_")) {
            String[] hostParts = StringUtils.substringAfter((String)message, (String)"PROXIED_SECURE_").split(":");
            int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : 443;
            PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
            ctx.channel().attr(HttpRequestHandler.PROXYING).set((Object)Boolean.TRUE);
            ctx.channel().attr(HttpActionHandler.REMOTE_SOCKET).set((Object)new InetSocketAddress(hostParts[0], port));
        } else if (message.startsWith("PROXIED_")) {
            String[] hostParts = StringUtils.substringAfter((String)message, (String)"PROXIED_").split(":");
            int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : 80;
            ctx.channel().attr(HttpRequestHandler.PROXYING).set((Object)Boolean.TRUE);
            ctx.channel().attr(HttpActionHandler.REMOTE_SOCKET).set((Object)new InetSocketAddress(hostParts[0], port));
        }
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])("PROXIED_RESPONSE_" + message).getBytes(StandardCharsets.UTF_8))).awaitUninterruptibly();
    }

    private String readMessage(ByteBuf msg) {
        byte[] bytes = new byte[this.actualReadableBytes()];
        msg.readBytes(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private void switchToBinary(ChannelHandlerContext ctx, ByteBuf msg) {
        this.addLastIfNotPresent(ctx.pipeline(), (ChannelHandler)new BinaryHandler(this.configuration, this.actionHandler.getHttpClient()));
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        String portExtension;
        InetSocketAddress inetSocketAddress;
        PortBinding cacheKey;
        SocketAddress localAddress = ctx.channel().localAddress();
        Set<String> localAddresses = null;
        if (localAddress instanceof InetSocketAddress && (localAddresses = localAddressesCache.get(cacheKey = new PortBinding(inetSocketAddress = (InetSocketAddress)localAddress, portExtension = this.calculatePortExtension(inetSocketAddress, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()))))) == null) {
            localAddresses = this.calculateLocalAddresses(inetSocketAddress, portExtension);
            localAddressesCache.put(cacheKey, localAddresses);
        }
        return localAddresses == null ? Collections.emptySet() : localAddresses;
    }

    private String calculatePortExtension(InetSocketAddress inetSocketAddress, boolean sslEnabledUpstream) {
        Object portExtension = inetSocketAddress.getPort() == 443 && sslEnabledUpstream || inetSocketAddress.getPort() == 80 && !sslEnabledUpstream ? "" : ":" + inetSocketAddress.getPort();
        return portExtension;
    }

    private Set<String> calculateLocalAddresses(InetSocketAddress localAddress, String portExtension) {
        InetAddress socketAddress = localAddress.getAddress();
        HashSet<CallSite> localAddresses = new HashSet<CallSite>();
        localAddresses.add((CallSite)((Object)(socketAddress.getHostAddress() + portExtension)));
        localAddresses.add((CallSite)((Object)(socketAddress.getCanonicalHostName() + portExtension)));
        localAddresses.add((CallSite)((Object)(socketAddress.getHostName() + portExtension)));
        localAddresses.add((CallSite)((Object)("localhost" + portExtension)));
        localAddresses.add((CallSite)((Object)("127.0.0.1" + portExtension)));
        return Collections.unmodifiableSet(localAddresses);
    }

    private void addLastIfNotPresent(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.get(channelHandler.getClass()) == null) {
            pipeline.addLast(new ChannelHandler[]{channelHandler});
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
        if (ExceptionHandling.connectionClosedException(throwable)) {
            log.error("exception caught by port unification handler -> closing pipeline {}", (Object)ctx.channel(), (Object)throwable);
        } else if (ExceptionHandling.sslHandshakeException(throwable)) {
            if (throwable.getMessage().contains("certificate_unknown")) {
                log.warn("TLS handshake failure:" + Character.NEW_LINE + Character.NEW_LINE + " Client does not trust MockServer Certificate Authority for:{}See http://mock-server.com/mock_server/HTTPS_TLS.html to enable the client to trust MocksServer Certificate Authority." + Character.NEW_LINE, (Object)ctx.channel());
            } else if (!throwable.getMessage().contains("close_notify during handshake")) {
                log.error("TLS handshake failure while a client attempted to connect to {}", (Object)ctx.channel(), (Object)throwable);
            }
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

