/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.responsewriter;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.CloseChannel;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.concurrent.GenericFutureListener;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyResponseWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyResponseWriter.class);
    private final ChannelHandlerContext ctx;
    private final MockServerConfiguration configuration;

    public NettyResponseWriter(MockServerConfiguration configuration, ChannelHandlerContext ctx) {
        this.configuration = configuration;
        this.ctx = ctx;
    }

    public void writeResponse(HttpRequest request, Action response) {
        if (response == null) {
            response = new CloseChannel();
        }
        response.write(this, request);
    }

    public void writeHttpResponse(HttpRequest request, HttpResponse response) {
        String contentLengthHeader = response.getFirstHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        if (StringUtils.isNotBlank((CharSequence)contentLengthHeader)) {
            try {
                int contentLength = Integer.parseInt(contentLengthHeader);
                if (response.getBody().length > contentLength) {
                    log.info("returning response with content-length header {} which is smaller then response body length {}, body will likely be truncated by client receiving request", (Object)contentLength, (Object)response.getBody().length);
                }
            }
            catch (NumberFormatException ignore) {
                log.trace("NumberFormatException while parsing content-length header", (Throwable)ignore);
            }
        }
        if (request.getStreamId() != null) {
            response.withStreamId(request.getStreamId());
        }
        this.sendResponse(request, this.addConnectionHeader(request, response));
    }

    protected HttpResponse addConnectionHeader(HttpRequest request, HttpResponse response) {
        if (Boolean.TRUE.equals(request.getKeepAlive())) {
            response.replaceHeader(new Header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString()));
        } else {
            response.replaceHeader(new Header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE.toString()));
        }
        return response;
    }

    public void sendResponse(HttpRequest request, HttpResponse response) {
        this.writeAndCloseSocket(this.ctx, request, response);
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        boolean closeChannel = request.getKeepAlive() == null || request.getKeepAlive() == false;
        ChannelFuture channelFuture = ctx.writeAndFlush((Object)response);
        if (closeChannel || this.configuration.alwaysCloseSocketConnections()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)this::disconnectAndCloseChannel));
        }
    }

    public void disconnectAndCloseChannel(ChannelFuture future) {
        NettyResponseWriter.gracefulClose(future.channel());
    }

    public void closeChannel() {
        NettyResponseWriter.gracefulClose(this.ctx.channel());
    }

    private static ChannelFuture gracefulClose(Channel channel) {
        return channel.disconnect().addListener(disconnectFuture -> {
            if (disconnectFuture.isSuccess()) {
                channel.close().addListener(closeFuture -> {
                    if (disconnectFuture.isSuccess()) {
                        if (log.isTraceEnabled()) {
                            log.trace("disconnected and closed socket {}", (Object)channel.localAddress());
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn("exception closing socket {}", (Object)channel.localAddress(), (Object)disconnectFuture.cause());
                    }
                });
            } else if (log.isWarnEnabled()) {
                log.warn("exception disconnecting socket {}", (Object)channel.localAddress(), (Object)disconnectFuture.cause());
            }
        });
    }
}

