/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.mockserver.character.Character;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpMessage;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.model.MockserverX509CertificateWrapper;
import de.gematik.test.tiger.mockserver.model.Parameter;
import de.gematik.test.tiger.mockserver.model.Parameters;
import de.gematik.test.tiger.mockserver.model.SocketAddress;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpRequest
extends HttpMessage<HttpRequest> {
    private String method = "";
    private String path = "";
    private Parameters pathParameters;
    private Parameters queryStringParameters;
    private Headers headers;
    private Boolean keepAlive = null;
    private Boolean secure = null;
    private HttpProtocol protocol = null;
    private Integer streamId = null;
    private List<MockserverX509CertificateWrapper> clientCertificateChain;
    private String tlsVersion = null;
    private String cipherSuite = null;
    private SocketAddress socketAddress;
    private String localAddress;
    private String remoteAddress;
    private Boolean forwardProxyRequest = false;
    private RbelElement parsedRbelMessage = null;
    private String logCorrelationId;

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public static HttpRequest request(String path) {
        return new HttpRequest().setPath(path);
    }

    public Boolean isSecure() {
        if (this.secure == null) {
            if (this.tlsVersion != null || this.cipherSuite != null) {
                this.setSecure(true);
            } else if (this.socketAddress != null && this.socketAddress.getScheme() != null) {
                this.setSecure(this.socketAddress.getScheme() == SocketAddress.Scheme.HTTPS);
            }
        }
        return this.secure;
    }

    public HttpRequest setSocketAddress(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        if (socketAddress != null && socketAddress.getScheme() != null) {
            this.secure = socketAddress.getScheme() == SocketAddress.Scheme.HTTPS;
        }
        return this;
    }

    public HttpRequest setSocketAddress(String host, Integer port, SocketAddress.Scheme scheme) {
        this.setSocketAddress(new SocketAddress().withHost(host).withPort(port).withScheme(scheme));
        return this;
    }

    public HttpRequest setSocketAddress(Boolean isSecure, String host, Integer port) {
        if (StringUtils.isNotBlank((CharSequence)host)) {
            String[] hostParts = host.split(":");
            boolean secure = Boolean.TRUE.equals(isSecure);
            if (hostParts.length > 1) {
                this.setSocketAddress(hostParts[0], port != null ? port : Integer.parseInt(hostParts[1]), secure ? SocketAddress.Scheme.HTTPS : SocketAddress.Scheme.HTTP);
            } else if (secure) {
                this.setSocketAddress(host, port != null ? port : 443, SocketAddress.Scheme.HTTPS);
            } else {
                this.setSocketAddress(host, port != null ? port : 80, SocketAddress.Scheme.HTTP);
            }
        }
        return this;
    }

    public boolean matches(String method) {
        return this.method.equals(method);
    }

    public boolean matches(String method, String ... paths) {
        boolean matches = false;
        for (String path : paths) {
            boolean bl = matches = this.method.equals(method) && this.path.equals(path);
            if (matches) break;
        }
        return matches;
    }

    public List<Parameter> getQueryStringParameterList() {
        if (this.getQueryStringParameters() == null || this.getQueryStringParameters().isEmpty()) {
            return List.of();
        }
        return this.getQueryStringParameters().getEntries();
    }

    private Parameters getOrCreateQueryStringParameters() {
        if (this.queryStringParameters == null) {
            this.queryStringParameters = new Parameters(new Parameter[0]);
        }
        return this.queryStringParameters;
    }

    public HttpRequest withQueryStringParameter(String name, String ... values) {
        this.getOrCreateQueryStringParameters().withEntry(name, values);
        return this;
    }

    @Override
    public HttpRequest withBody(byte[] body) {
        this.setBody(body);
        return this;
    }

    @Override
    public Headers getHeaders() {
        if (this.headers == null) {
            this.headers = new Headers(new Header[0]);
        }
        return this.headers;
    }

    @Override
    public HttpRequest withHeaders(Headers headers) {
        this.headers = headers == null || headers.isEmpty() ? null : headers;
        return this;
    }

    @Override
    public HttpRequest withHeader(Header header) {
        this.getHeaders().withEntry(header);
        return this;
    }

    @Override
    public HttpRequest withHeader(String name, String ... values) {
        if (values.length == 0) {
            values = new String[]{".*"};
        }
        this.getHeaders().withEntry(Header.header(name, values));
        return this;
    }

    @Override
    public HttpRequest replaceHeader(Header header) {
        this.getHeaders().replaceEntry(header);
        return this;
    }

    @Override
    public List<Header> getHeaderList() {
        if (this.headers != null) {
            return this.headers.getEntries();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getHeader(String name) {
        if (this.headers != null) {
            return this.headers.getValues(name);
        }
        return Collections.emptyList();
    }

    @Override
    public String getFirstHeader(String name) {
        if (this.headers != null) {
            return this.headers.getFirstValue(name);
        }
        return "";
    }

    public boolean containsHeader(String name, String value) {
        if (this.headers != null) {
            return this.headers.containsEntry(name, value);
        }
        return false;
    }

    @Override
    public HttpRequest removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
        return this;
    }

    public InetSocketAddress socketAddressFromHostHeader() {
        if (this.socketAddress != null && this.socketAddress.getHost() != null) {
            boolean isSsl = this.socketAddress.getScheme() != null && this.socketAddress.getScheme().equals((Object)SocketAddress.Scheme.HTTPS);
            return new InetSocketAddress(this.socketAddress.getHost(), this.socketAddress.getPort() != null ? this.socketAddress.getPort() : (isSsl ? 443 : 80));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            boolean isSsl = this.isSecure() != null && this.isSecure() != false;
            String[] hostHeaderParts = this.getFirstHeader(HttpHeaderNames.HOST.toString()).split(":");
            return new InetSocketAddress(hostHeaderParts[0], hostHeaderParts.length > 1 ? Integer.parseInt(hostHeaderParts[1]) : (isSsl ? 443 : 80));
        }
        throw new IllegalArgumentException("Host header must be provided to determine remote socket address, the request does not include the \"Host\" header:" + Character.NEW_LINE + this);
    }

    public String getMethodOrDefault(String fallback) {
        return Optional.ofNullable(this.method).filter(StringUtils::isNotEmpty).orElse(fallback);
    }

    public String printLogLineDescription() {
        return this.createProtocolString() + " " + this.getMethod() + " " + this.getPath() + " " + this.createHostHeaderString() + " " + this.createUserAgentString() + " Request-Length: " + this.createMessageSizeString();
    }

    private String createProtocolString() {
        if (Boolean.TRUE.equals(this.isSecure())) {
            return "HTTPS";
        }
        return "HTTP";
    }

    private String createHostHeaderString() {
        return Optional.ofNullable(this.getFirstHeader("host")).filter(StringUtils::isNotEmpty).map(agent -> "Host: '" + agent + "'").orElse("");
    }

    private String createUserAgentString() {
        return Optional.ofNullable(this.getFirstHeader("User-Agent")).filter(StringUtils::isNotEmpty).map(agent -> "User-Agent: '" + agent + "'").orElse("");
    }

    private String createMessageSizeString() {
        if (this.getBody() == null) {
            return "0 bytes";
        }
        return FileUtils.byteCountToDisplaySize((long)this.getBody().length);
    }

    @Generated
    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    @Generated
    public HttpRequestBuilder toBuilder() {
        return new HttpRequestBuilder().method(this.method).path(this.path).pathParameters(this.pathParameters).queryStringParameters(this.queryStringParameters).headers(this.headers).keepAlive(this.keepAlive).secure(this.secure).protocol(this.protocol).streamId(this.streamId).clientCertificateChain(this.clientCertificateChain).tlsVersion(this.tlsVersion).cipherSuite(this.cipherSuite).socketAddress(this.socketAddress).localAddress(this.localAddress).remoteAddress(this.remoteAddress).forwardProxyRequest(this.forwardProxyRequest).parsedRbelMessage(this.parsedRbelMessage).logCorrelationId(this.logCorrelationId);
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Parameters getPathParameters() {
        return this.pathParameters;
    }

    @Generated
    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    @Generated
    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Generated
    public Boolean getSecure() {
        return this.secure;
    }

    @Generated
    public HttpProtocol getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getStreamId() {
        return this.streamId;
    }

    @Generated
    public List<MockserverX509CertificateWrapper> getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    @Generated
    public String getTlsVersion() {
        return this.tlsVersion;
    }

    @Generated
    public String getCipherSuite() {
        return this.cipherSuite;
    }

    @Generated
    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    @Generated
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Generated
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Generated
    public Boolean getForwardProxyRequest() {
        return this.forwardProxyRequest;
    }

    @Generated
    public RbelElement getParsedRbelMessage() {
        return this.parsedRbelMessage;
    }

    @Generated
    public String getLogCorrelationId() {
        return this.logCorrelationId;
    }

    @Generated
    public HttpRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    @Generated
    public HttpRequest setPath(String path) {
        this.path = path;
        return this;
    }

    @Generated
    public HttpRequest setPathParameters(Parameters pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    @Generated
    public HttpRequest setQueryStringParameters(Parameters queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    @Generated
    public HttpRequest setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    @Generated
    public HttpRequest setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Generated
    public HttpRequest setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    @Generated
    public HttpRequest setProtocol(HttpProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    public HttpRequest setStreamId(Integer streamId) {
        this.streamId = streamId;
        return this;
    }

    @Generated
    public HttpRequest setClientCertificateChain(List<MockserverX509CertificateWrapper> clientCertificateChain) {
        this.clientCertificateChain = clientCertificateChain;
        return this;
    }

    @Generated
    public HttpRequest setTlsVersion(String tlsVersion) {
        this.tlsVersion = tlsVersion;
        return this;
    }

    @Generated
    public HttpRequest setCipherSuite(String cipherSuite) {
        this.cipherSuite = cipherSuite;
        return this;
    }

    @Generated
    public HttpRequest setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    @Generated
    public HttpRequest setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @Generated
    public HttpRequest setForwardProxyRequest(Boolean forwardProxyRequest) {
        this.forwardProxyRequest = forwardProxyRequest;
        return this;
    }

    @Generated
    public HttpRequest setParsedRbelMessage(RbelElement parsedRbelMessage) {
        this.parsedRbelMessage = parsedRbelMessage;
        return this;
    }

    @Generated
    public HttpRequest setLogCorrelationId(String logCorrelationId) {
        this.logCorrelationId = logCorrelationId;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$keepAlive = this.getKeepAlive();
        Boolean other$keepAlive = other.getKeepAlive();
        if (this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive)) {
            return false;
        }
        Boolean this$secure = this.getSecure();
        Boolean other$secure = other.getSecure();
        if (this$secure == null ? other$secure != null : !((Object)this$secure).equals(other$secure)) {
            return false;
        }
        Integer this$streamId = this.getStreamId();
        Integer other$streamId = other.getStreamId();
        if (this$streamId == null ? other$streamId != null : !((Object)this$streamId).equals(other$streamId)) {
            return false;
        }
        Boolean this$forwardProxyRequest = this.getForwardProxyRequest();
        Boolean other$forwardProxyRequest = other.getForwardProxyRequest();
        if (this$forwardProxyRequest == null ? other$forwardProxyRequest != null : !((Object)this$forwardProxyRequest).equals(other$forwardProxyRequest)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Parameters this$pathParameters = this.getPathParameters();
        Parameters other$pathParameters = other.getPathParameters();
        if (this$pathParameters == null ? other$pathParameters != null : !((Object)this$pathParameters).equals(other$pathParameters)) {
            return false;
        }
        Parameters this$queryStringParameters = this.getQueryStringParameters();
        Parameters other$queryStringParameters = other.getQueryStringParameters();
        if (this$queryStringParameters == null ? other$queryStringParameters != null : !((Object)this$queryStringParameters).equals(other$queryStringParameters)) {
            return false;
        }
        Headers this$headers = this.getHeaders();
        Headers other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        HttpProtocol this$protocol = this.getProtocol();
        HttpProtocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
            return false;
        }
        List<MockserverX509CertificateWrapper> this$clientCertificateChain = this.getClientCertificateChain();
        List<MockserverX509CertificateWrapper> other$clientCertificateChain = other.getClientCertificateChain();
        if (this$clientCertificateChain == null ? other$clientCertificateChain != null : !((Object)this$clientCertificateChain).equals(other$clientCertificateChain)) {
            return false;
        }
        String this$tlsVersion = this.getTlsVersion();
        String other$tlsVersion = other.getTlsVersion();
        if (this$tlsVersion == null ? other$tlsVersion != null : !this$tlsVersion.equals(other$tlsVersion)) {
            return false;
        }
        String this$cipherSuite = this.getCipherSuite();
        String other$cipherSuite = other.getCipherSuite();
        if (this$cipherSuite == null ? other$cipherSuite != null : !this$cipherSuite.equals(other$cipherSuite)) {
            return false;
        }
        SocketAddress this$socketAddress = this.getSocketAddress();
        SocketAddress other$socketAddress = other.getSocketAddress();
        if (this$socketAddress == null ? other$socketAddress != null : !((Object)this$socketAddress).equals(other$socketAddress)) {
            return false;
        }
        String this$localAddress = this.getLocalAddress();
        String other$localAddress = other.getLocalAddress();
        if (this$localAddress == null ? other$localAddress != null : !this$localAddress.equals(other$localAddress)) {
            return false;
        }
        String this$remoteAddress = this.getRemoteAddress();
        String other$remoteAddress = other.getRemoteAddress();
        if (this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress)) {
            return false;
        }
        RbelElement this$parsedRbelMessage = this.getParsedRbelMessage();
        RbelElement other$parsedRbelMessage = other.getParsedRbelMessage();
        if (this$parsedRbelMessage == null ? other$parsedRbelMessage != null : !this$parsedRbelMessage.equals(other$parsedRbelMessage)) {
            return false;
        }
        String this$logCorrelationId = this.getLogCorrelationId();
        String other$logCorrelationId = other.getLogCorrelationId();
        return !(this$logCorrelationId == null ? other$logCorrelationId != null : !this$logCorrelationId.equals(other$logCorrelationId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $keepAlive = this.getKeepAlive();
        result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
        Boolean $secure = this.getSecure();
        result = result * 59 + ($secure == null ? 43 : ((Object)$secure).hashCode());
        Integer $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : ((Object)$streamId).hashCode());
        Boolean $forwardProxyRequest = this.getForwardProxyRequest();
        result = result * 59 + ($forwardProxyRequest == null ? 43 : ((Object)$forwardProxyRequest).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Parameters $pathParameters = this.getPathParameters();
        result = result * 59 + ($pathParameters == null ? 43 : ((Object)$pathParameters).hashCode());
        Parameters $queryStringParameters = this.getQueryStringParameters();
        result = result * 59 + ($queryStringParameters == null ? 43 : ((Object)$queryStringParameters).hashCode());
        Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        HttpProtocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        List<MockserverX509CertificateWrapper> $clientCertificateChain = this.getClientCertificateChain();
        result = result * 59 + ($clientCertificateChain == null ? 43 : ((Object)$clientCertificateChain).hashCode());
        String $tlsVersion = this.getTlsVersion();
        result = result * 59 + ($tlsVersion == null ? 43 : $tlsVersion.hashCode());
        String $cipherSuite = this.getCipherSuite();
        result = result * 59 + ($cipherSuite == null ? 43 : $cipherSuite.hashCode());
        SocketAddress $socketAddress = this.getSocketAddress();
        result = result * 59 + ($socketAddress == null ? 43 : ((Object)$socketAddress).hashCode());
        String $localAddress = this.getLocalAddress();
        result = result * 59 + ($localAddress == null ? 43 : $localAddress.hashCode());
        String $remoteAddress = this.getRemoteAddress();
        result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
        RbelElement $parsedRbelMessage = this.getParsedRbelMessage();
        result = result * 59 + ($parsedRbelMessage == null ? 43 : $parsedRbelMessage.hashCode());
        String $logCorrelationId = this.getLogCorrelationId();
        result = result * 59 + ($logCorrelationId == null ? 43 : $logCorrelationId.hashCode());
        return result;
    }

    @Generated
    public HttpRequest() {
    }

    @ConstructorProperties(value={"method", "path", "pathParameters", "queryStringParameters", "headers", "keepAlive", "secure", "protocol", "streamId", "clientCertificateChain", "tlsVersion", "cipherSuite", "socketAddress", "localAddress", "remoteAddress", "forwardProxyRequest", "parsedRbelMessage", "logCorrelationId"})
    @Generated
    public HttpRequest(String method, String path, Parameters pathParameters, Parameters queryStringParameters, Headers headers, Boolean keepAlive, Boolean secure, HttpProtocol protocol, Integer streamId, List<MockserverX509CertificateWrapper> clientCertificateChain, String tlsVersion, String cipherSuite, SocketAddress socketAddress, String localAddress, String remoteAddress, Boolean forwardProxyRequest, RbelElement parsedRbelMessage, String logCorrelationId) {
        this.method = method;
        this.path = path;
        this.pathParameters = pathParameters;
        this.queryStringParameters = queryStringParameters;
        this.headers = headers;
        this.keepAlive = keepAlive;
        this.secure = secure;
        this.protocol = protocol;
        this.streamId = streamId;
        this.clientCertificateChain = clientCertificateChain;
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.socketAddress = socketAddress;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.forwardProxyRequest = forwardProxyRequest;
        this.parsedRbelMessage = parsedRbelMessage;
        this.logCorrelationId = logCorrelationId;
    }

    @Generated
    public static class HttpRequestBuilder {
        @Generated
        private String method;
        @Generated
        private String path;
        @Generated
        private Parameters pathParameters;
        @Generated
        private Parameters queryStringParameters;
        @Generated
        private Headers headers;
        @Generated
        private Boolean keepAlive;
        @Generated
        private Boolean secure;
        @Generated
        private HttpProtocol protocol;
        @Generated
        private Integer streamId;
        @Generated
        private List<MockserverX509CertificateWrapper> clientCertificateChain;
        @Generated
        private String tlsVersion;
        @Generated
        private String cipherSuite;
        @Generated
        private SocketAddress socketAddress;
        @Generated
        private String localAddress;
        @Generated
        private String remoteAddress;
        @Generated
        private Boolean forwardProxyRequest;
        @Generated
        private RbelElement parsedRbelMessage;
        @Generated
        private String logCorrelationId;

        @Generated
        HttpRequestBuilder() {
        }

        @Generated
        public HttpRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        @Generated
        public HttpRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public HttpRequestBuilder pathParameters(Parameters pathParameters) {
            this.pathParameters = pathParameters;
            return this;
        }

        @Generated
        public HttpRequestBuilder queryStringParameters(Parameters queryStringParameters) {
            this.queryStringParameters = queryStringParameters;
            return this;
        }

        @Generated
        public HttpRequestBuilder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public HttpRequestBuilder keepAlive(Boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        @Generated
        public HttpRequestBuilder secure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        @Generated
        public HttpRequestBuilder protocol(HttpProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public HttpRequestBuilder streamId(Integer streamId) {
            this.streamId = streamId;
            return this;
        }

        @Generated
        public HttpRequestBuilder clientCertificateChain(List<MockserverX509CertificateWrapper> clientCertificateChain) {
            this.clientCertificateChain = clientCertificateChain;
            return this;
        }

        @Generated
        public HttpRequestBuilder tlsVersion(String tlsVersion) {
            this.tlsVersion = tlsVersion;
            return this;
        }

        @Generated
        public HttpRequestBuilder cipherSuite(String cipherSuite) {
            this.cipherSuite = cipherSuite;
            return this;
        }

        @Generated
        public HttpRequestBuilder socketAddress(SocketAddress socketAddress) {
            this.socketAddress = socketAddress;
            return this;
        }

        @Generated
        public HttpRequestBuilder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        @Generated
        public HttpRequestBuilder remoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        @Generated
        public HttpRequestBuilder forwardProxyRequest(Boolean forwardProxyRequest) {
            this.forwardProxyRequest = forwardProxyRequest;
            return this;
        }

        @Generated
        public HttpRequestBuilder parsedRbelMessage(RbelElement parsedRbelMessage) {
            this.parsedRbelMessage = parsedRbelMessage;
            return this;
        }

        @Generated
        public HttpRequestBuilder logCorrelationId(String logCorrelationId) {
            this.logCorrelationId = logCorrelationId;
            return this;
        }

        @Generated
        public HttpRequest build() {
            return new HttpRequest(this.method, this.path, this.pathParameters, this.queryStringParameters, this.headers, this.keepAlive, this.secure, this.protocol, this.streamId, this.clientCertificateChain, this.tlsVersion, this.cipherSuite, this.socketAddress, this.localAddress, this.remoteAddress, this.forwardProxyRequest, this.parsedRbelMessage, this.logCorrelationId);
        }

        @Generated
        public String toString() {
            return "HttpRequest.HttpRequestBuilder(method=" + this.method + ", path=" + this.path + ", pathParameters=" + this.pathParameters + ", queryStringParameters=" + this.queryStringParameters + ", headers=" + this.headers + ", keepAlive=" + this.keepAlive + ", secure=" + this.secure + ", protocol=" + this.protocol + ", streamId=" + this.streamId + ", clientCertificateChain=" + this.clientCertificateChain + ", tlsVersion=" + this.tlsVersion + ", cipherSuite=" + this.cipherSuite + ", socketAddress=" + this.socketAddress + ", localAddress=" + this.localAddress + ", remoteAddress=" + this.remoteAddress + ", forwardProxyRequest=" + this.forwardProxyRequest + ", parsedRbelMessage=" + this.parsedRbelMessage + ", logCorrelationId=" + this.logCorrelationId + ")";
        }
    }
}

