/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock.action.http;

import de.gematik.test.tiger.mockserver.character.Character;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.filters.HopByHopHeaderFilter;
import de.gematik.test.tiger.mockserver.httpclient.HttpRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.httpclient.SocketCommunicationException;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.mock.HttpAction;
import de.gematik.test.tiger.mockserver.mock.HttpState;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpForwardActionHandler;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpForwardActionResult;
import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.CloseChannel;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.netty.responsewriter.NettyResponseWriter;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpActionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpActionHandler.class);
    public static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf((String)"REMOTE_SOCKET");
    private final MockServerConfiguration configuration;
    private final HttpState httpStateHandler;
    private final Scheduler scheduler;
    private HttpForwardActionHandler httpForwardActionHandler;
    private NettyHttpClient httpClient;
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    public HttpActionHandler(MockServerConfiguration configuration, EventLoopGroup eventLoopGroup, HttpState httpStateHandler, List<ProxyConfiguration> proxyConfigurations, NettySslContextFactory nettySslContextFactory) {
        this.configuration = configuration;
        this.httpStateHandler = httpStateHandler;
        this.scheduler = httpStateHandler.getScheduler();
        this.httpClient = new NettyHttpClient(configuration, eventLoopGroup, proxyConfigurations, nettySslContextFactory);
    }

    public void processAction(HttpRequest request, NettyResponseWriter responseWriter, ChannelHandlerContext ctx, boolean proxyingRequest, boolean synchronous) {
        Expectation expectation;
        if (request.getHeaders() == null || !request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
            log.debug("received request:{}", (Object)request);
        }
        if ((expectation = this.httpStateHandler.firstMatchingExpectation(request)) != null && expectation.getHttpAction() != null) {
            HttpAction action = expectation.getHttpAction();
            this.scheduler.schedule(() -> action.handle(request, ctx.channel(), this, responseWriter, synchronous), synchronous);
        } else if (proxyingRequest) {
            if (request.getHeaders() != null && request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
                log.trace("received \"x-forwarded-by\" header caused by exploratory HTTP proxy or proxy loop - falling back to no proxy:{}", (Object)request);
                this.returnNotFound(responseWriter, request, null);
            } else {
                InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress(ctx);
                HttpRequest clonedRequest = this.hopByHopHeaderFilter.onRequest(request).withHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue());
                HttpForwardActionResult responseFuture = new HttpForwardActionResult(clonedRequest, this.httpClient.sendRequest(new HttpRequestInfo(ctx.channel(), clonedRequest, remoteAddress), this.configuration.socketConnectionTimeoutInMillis()), null, remoteAddress);
                this.scheduler.submit(responseFuture, () -> {
                    try {
                        HttpResponse response = responseFuture.getHttpResponse().get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                        if (response == null) {
                            response = HttpResponse.notFoundResponse();
                        }
                        if (response.containsHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
                            response.removeHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName());
                            log.debug("no expectation for: {} returning response: {}", (Object)request, (Object)response);
                        } else {
                            log.debug("returning response:{}\nfor forwarded request" + Character.NEW_LINE + Character.NEW_LINE + " in json:{}", (Object)request, (Object)response);
                        }
                        responseWriter.writeResponse(request, response);
                    }
                    catch (SocketCommunicationException sce) {
                        log.warn("Exception while writing response", (Throwable)sce);
                        this.returnNotFound(responseWriter, request, sce.getMessage());
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException throwable) {
                        if (throwable instanceof TimeoutException) {
                            Thread.currentThread().interrupt();
                        }
                        if (ExceptionHandling.sslHandshakeException(throwable)) {
                            log.error("TLS handshake exception while proxying request {} to remote address {} with channel {}", new Object[]{ctx != null ? String.valueOf(ctx.channel()) : "", request, remoteAddress});
                            this.returnNotFound(responseWriter, request, "TLS handshake exception while proxying request to remote address" + remoteAddress);
                        }
                        if (!ExceptionHandling.connectionClosedException(throwable)) {
                            log.error("connection closed while proxying request to remote address {}", (Object)remoteAddress, (Object)throwable);
                            this.returnNotFound(responseWriter, request, "connection closed while proxying request to remote address " + remoteAddress);
                        }
                        log.error("Exception while proxying request", (Throwable)throwable);
                        this.returnNotFound(responseWriter, request, throwable.getMessage());
                    }
                }, synchronous, throwable -> throwable.getMessage().contains("Connection refused"));
            }
        } else {
            log.error("Returning not found for {}", (Object)request.printLogLineDescription());
            this.returnNotFound(responseWriter, request, null);
        }
    }

    public void executeAfterForwardActionResponse(HttpForwardActionResult responseFuture, BiConsumer<HttpResponse, Throwable> command, boolean synchronous) {
        this.scheduler.submit(responseFuture, command, synchronous);
    }

    public void writeForwardActionResponse(HttpForwardActionResult responseFuture, NettyResponseWriter responseWriter, HttpRequest request, Action action, boolean synchronous) {
        this.scheduler.submit(responseFuture, () -> {
            try {
                HttpResponse response = responseFuture.getHttpResponse().get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                responseWriter.writeResponse(request, response);
                log.debug("returning response: {} for forwarded request" + Character.NEW_LINE + Character.NEW_LINE + " in json: {}" + Character.NEW_LINE + Character.NEW_LINE + "\nfor action: {} from expectation: {}", new Object[]{response, responseFuture.getHttpRequest(), action, action.getExpectationId()});
            }
            catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException throwable) {
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.handleExceptionDuringForwardingRequest(action, request, responseWriter, throwable);
            }
        }, synchronous, throwable -> true);
    }

    public void writeForwardActionResponse(HttpResponse response, NettyResponseWriter responseWriter, HttpRequest request) {
        try {
            responseWriter.writeResponse(request, response);
            log.debug("returning response: {} for forwarded request" + Character.NEW_LINE + Character.NEW_LINE + " in json:{}", (Object)response, (Object)request);
        }
        catch (Exception exception) {
            log.error("Error while returning response", (Throwable)exception);
        }
    }

    public void handleExceptionDuringForwardingRequest(Action action, HttpRequest request, NettyResponseWriter responseWriter, Throwable exception) {
        if (action instanceof CloseChannel) {
            log.debug("closing channel due to close action");
            responseWriter.closeChannel();
        } else if (ExceptionHandling.connectionException(exception)) {
            log.error("failed to connect to remote socket while forwarding request {} for action {}", new Object[]{request, action, exception});
            this.returnNotFound(responseWriter, request, "failed to connect to remote socket while forwarding request");
        } else if (ExceptionHandling.sslHandshakeException(exception)) {
            log.error("TLS handshake exception while forwarding request {} for action {}", new Object[]{request, action, exception});
            this.returnNotFound(responseWriter, request, "TLS handshake exception while forwarding request");
        } else {
            log.error("Exception while forwarding request", exception);
            this.returnNotFound(responseWriter, request, exception != null ? exception.getMessage() : null);
        }
    }

    private void returnNotFound(NettyResponseWriter responseWriter, HttpRequest request, String error) {
        HttpResponse response = HttpResponse.notFoundResponse();
        if (request.getHeaders() != null && request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
            response.withHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue());
            log.trace("no expectation for: {} returning response: {}", (Object)request, (Object)HttpResponse.notFoundResponse());
        } else if (StringUtils.isNotBlank((CharSequence)error)) {
            log.debug("error: {} handling request: {} returning response: {}", new Object[]{error, request, HttpResponse.notFoundResponse()});
        } else {
            log.debug("no expectation for: {} returning response: {}", (Object)request, (Object)HttpResponse.notFoundResponse());
        }
        responseWriter.writeResponse(request, response);
    }

    public HttpForwardActionHandler getHttpForwardActionHandler() {
        if (this.httpForwardActionHandler == null) {
            this.httpForwardActionHandler = new HttpForwardActionHandler(this.httpClient);
        }
        return this.httpForwardActionHandler;
    }

    public static InetSocketAddress getRemoteAddress(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel() != null && ctx.channel().attr(REMOTE_SOCKET) != null) {
            return (InetSocketAddress)ctx.channel().attr(REMOTE_SOCKET).get();
        }
        return null;
    }

    @Generated
    public NettyHttpClient getHttpClient() {
        return this.httpClient;
    }
}

